/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.OrderPurchaseXbjAtomService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.busi.XbjAccessoryBusiService;
import com.cgd.order.busi.XbjCreateOrderFlowSheetBusiService;
import com.cgd.order.busi.XbjSupplierPurchaseOrderRejectBusiService;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjRejectPurchaseOrderReqBO;
import com.cgd.order.busi.bo.XbjRejectPurchaseOrderRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class XbjSupplierPurchaseOrderRejectBusiServiceImpl
implements XbjSupplierPurchaseOrderRejectBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjSupplierPurchaseOrderRejectBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;
    private XbjAccessoryBusiService xbjAccessoryBusiService;
    private OrderPurchaseXbjAtomService orderPurchaseXbjAtomService;
    private XbjCreateOrderFlowSheetBusiService xbjCreateOrderFlowSheetBusiService;
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    private OrderSaleXbjMapper orderSaleXbjMapper;

    public void setOrderPurchaseStatusChngXbjService(OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService) {
        this.orderPurchaseStatusChngXbjService = orderPurchaseStatusChngXbjService;
    }

    public void setXbjAccessoryBusiService(XbjAccessoryBusiService xbjAccessoryBusiService) {
        this.xbjAccessoryBusiService = xbjAccessoryBusiService;
    }

    public void setOrderPurchaseXbjAtomService(OrderPurchaseXbjAtomService orderPurchaseXbjAtomService) {
        this.orderPurchaseXbjAtomService = orderPurchaseXbjAtomService;
    }

    public void setXbjCreateOrderFlowSheetBusiService(XbjCreateOrderFlowSheetBusiService xbjCreateOrderFlowSheetBusiService) {
        this.xbjCreateOrderFlowSheetBusiService = xbjCreateOrderFlowSheetBusiService;
    }

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setOrderSaleXbjAtomService(OrderSaleXbjAtomService orderSaleXbjAtomService) {
        this.orderSaleXbjAtomService = orderSaleXbjAtomService;
    }

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public XbjRejectPurchaseOrderRspBO cancelSupplierPurchaseOrder(XbjRejectPurchaseOrderReqBO xbjRejectPurchaseOrderReqBO) {
        Integer newStatus = XConstant.SALE_ORDER_STATE_REJECT_TO_DEAL;
        this.validateParams(xbjRejectPurchaseOrderReqBO);
        OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjAtomService.queryOrderPurchaseInfo(xbjRejectPurchaseOrderReqBO.getPurchaseOrderId());
        Integer newSaleOrderStatus = orderPurchaseXbjPO.getIsDispatch().equals(XConstant.IS_DISPATCH_NO) ? XConstant.SALE_ORDER_STATE_REJECT_TO_DEAL : XConstant.SALE_ORDER_STATE_TO_CONF;
        this.validate(orderPurchaseXbjPO);
        XbjRejectPurchaseOrderRspBO rsp = new XbjRejectPurchaseOrderRspBO();
        try {
            XbjOrderFlowSheetRspBO xbjOrderFlowSheetRspBO;
            OrderPurchaseStatusChngReqBo orderPurchaseStatusChngReqBo = this.transferOrderPurchaseStatusChngReqBO(xbjRejectPurchaseOrderReqBO.getUserId(), orderPurchaseXbjPO, newStatus, null);
            this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(orderPurchaseStatusChngReqBo);
            this.orderPurchaseXbjMapper.updateCancelInfo(orderPurchaseXbjPO.getPurchaseOrderId(), "GOODS_SUPPLIER_CANCEL", xbjRejectPurchaseOrderReqBO.getCancelRemark(), new Date(), xbjRejectPurchaseOrderReqBO.getUserId());
            OrderSaleXbjPO orderSaleXbjPO = this.orderSaleXbjMapper.selectOrderSaleByCondition(orderPurchaseXbjPO.getSaleOrderId(), orderPurchaseXbjPO.getPurchaserId());
            if (orderSaleXbjPO != null) {
                OrderSaleXbjReqBO orderSaleXbjReqBO = this.transferOrderSaleReqBO(orderSaleXbjPO, "GOODS_SUPPLIER_CANCEL", orderSaleXbjPO.getSaleOrderStatus(), newSaleOrderStatus, xbjRejectPurchaseOrderReqBO.getUserId());
                this.orderSaleXbjAtomService.salerOrderStatusChange(orderSaleXbjReqBO);
                this.orderSaleXbjMapper.updateCancelInfo(orderSaleXbjPO.getSaleOrderId(), "GOODS_SUPPLIER_CANCEL", xbjRejectPurchaseOrderReqBO.getCancelRemark(), new Date(), xbjRejectPurchaseOrderReqBO.getUserId());
            }
            if (xbjRejectPurchaseOrderReqBO.getXbjPurchaseAccessoryReqBOs() != null && !xbjRejectPurchaseOrderReqBO.getXbjPurchaseAccessoryReqBOs().isEmpty()) {
                this.xbjAccessoryBusiService.saveAccessoryByPurchaseOrder(xbjRejectPurchaseOrderReqBO.getPurchaseOrderId(), Constant.REJECT_OBJECT_TYPE, xbjRejectPurchaseOrderReqBO.getXbjPurchaseAccessoryReqBOs());
            }
            XbjOrderFlowSheetReqBO xbjOrderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
            BeanUtils.copyProperties((Object)xbjRejectPurchaseOrderReqBO, (Object)xbjOrderFlowSheetReqBO);
            xbjOrderFlowSheetReqBO.setOrderId(xbjRejectPurchaseOrderReqBO.getPurchaseOrderId());
            xbjOrderFlowSheetReqBO.setOrderType(Constant.ORDER_TYPE_PURCHASE);
            xbjOrderFlowSheetReqBO.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
            xbjOrderFlowSheetReqBO.setOrderBusiType("B_5");
            if (this.isDebugEnabled) {
                log.debug("\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-----------------------------------------------------");
                log.debug(JSON.toJSONString((Object)xbjOrderFlowSheetReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
            if ((xbjOrderFlowSheetRspBO = this.xbjCreateOrderFlowSheetBusiService.createOrderFlowSheet(xbjOrderFlowSheetReqBO)) != null && "8888".equals(xbjOrderFlowSheetRspBO.getRespCode())) {
                throw new BusinessException(xbjOrderFlowSheetRspBO.getRespCode(), xbjOrderFlowSheetRspBO.getRespDesc());
            }
        }
        catch (BusinessException e) {
            throw new BusinessException(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            log.error("\u62d2\u5355\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u62d2\u5355\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    private OrderSaleXbjReqBO transferOrderSaleReqBO(OrderSaleXbjPO orderSaleXbjPO, String cancelReason, Integer oldStatus, Integer newStatus, Long userId) {
        OrderSaleXbjReqBO req = new OrderSaleXbjReqBO();
        req.setSaleOrderId(orderSaleXbjPO.getSaleOrderId());
        req.setSaleOrderStatus(newStatus);
        req.setSaleOrderOldStatus(oldStatus);
        req.setPurchaserId(orderSaleXbjPO.getPurchaserId());
        req.setPurchaserAccountId(orderSaleXbjPO.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(orderSaleXbjPO.getProfessionalOrganizationId());
        req.setCancelReason(cancelReason);
        req.setGoodsSupplierId(orderSaleXbjPO.getGoodsSupplierId());
        req.setModifyOprId(userId);
        req.setPurchaserAccountName(orderSaleXbjPO.getPurchaserAccountName());
        req.setSaleOrderType(orderSaleXbjPO.getSaleOrderType());
        return req;
    }

    private OrderPurchaseStatusChngReqBo transferOrderPurchaseStatusChngReqBO(Long userId, OrderPurchaseXbjPO orderPurchaseXbjPO, Integer purchaseOrderStatus, String arriveTime) {
        OrderPurchaseStatusChngReqBo req = new OrderPurchaseStatusChngReqBo();
        req.setPurchaseOrderId(orderPurchaseXbjPO.getPurchaseOrderId());
        req.setPurchaseOrderOldStatus(orderPurchaseXbjPO.getPurchaseOrderStatus());
        req.setPurchaseOrderStatus(purchaseOrderStatus);
        req.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
        req.setPurchaserAccountId(orderPurchaseXbjPO.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(orderPurchaseXbjPO.getProfessionalOrganizationId());
        req.setSaleOrderId(orderPurchaseXbjPO.getSaleOrderId());
        req.setArriveTime(arriveTime);
        return req;
    }

    private void validate(OrderPurchaseXbjPO orderPurchaseXbjPO) {
        if (orderPurchaseXbjPO == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u91c7\u8d2d\u8ba2\u5355id[purchaseOrderId]\u67e5\u8be2\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355\u8bb0\u5f55");
        }
        if (!Constant.SALSE_ORDER_STATE_SUPPLY_CONFIRMING.equals(orderPurchaseXbjPO.getPurchaseOrderStatus()) && !Constant.SALSE_ORDER_STATE_TO_CONF.equals(orderPurchaseXbjPO.getPurchaseOrderStatus())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001[purchaseOrderStatus]\u4e0d\u7b26\u5408\u8981\u6c42,\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u5e94\u8be5\u4e3a  -> \u4f9b\u5e94\u5546\u786e\u8ba4\u4e2d \u6216 \u8ba2\u5355\u786e\u8ba4\u4e2d");
        }
    }

    private void validateParams(XbjRejectPurchaseOrderReqBO xbjRejectPurchaseOrderReqBO) {
        if (xbjRejectPurchaseOrderReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u529b\u4e13\u533a\u4f9b\u5e94\u5546\u91c7\u8d2d\u5355\u62d2\u5355\u5165\u53c2\u4e3a\u7a7a");
        }
        if (xbjRejectPurchaseOrderReqBO.getPurchaseOrderId() == null || xbjRejectPurchaseOrderReqBO.getPurchaseOrderId() == 0L) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355id[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjRejectPurchaseOrderReqBO.getCancelRemark())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u62d2\u5355\u539f\u56e0[cancelRemark]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

