/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.busi.XbjCreateOrderFlowSheetBusiService;
import com.cgd.order.busi.XbjOrderPurchaseBusiService;
import com.cgd.order.busi.XbjSupplierPurchaseOrderRejectCancelBusiService;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjRejectCancelReqBO;
import com.cgd.order.busi.bo.XbjRejectCancelRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class XbjSupplierPurchaseOrderRejectCancelBusiServiceImpl
implements XbjSupplierPurchaseOrderRejectCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjSupplierPurchaseOrderRejectCancelBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    private XbjOrderPurchaseBusiService xbjOrderPurchaseBusiService;
    private XbjCreateOrderFlowSheetBusiService xbjCreateOrderFlowSheetBusiService;
    private OrderSaleXbjMapper orderSaleXbjMapper;
    private OrderSaleXbjAtomService orderSaleXbjAtomService;

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setXbjOrderPurchaseBusiService(XbjOrderPurchaseBusiService xbjOrderPurchaseBusiService) {
        this.xbjOrderPurchaseBusiService = xbjOrderPurchaseBusiService;
    }

    public void setXbjCreateOrderFlowSheetBusiService(XbjCreateOrderFlowSheetBusiService xbjCreateOrderFlowSheetBusiService) {
        this.xbjCreateOrderFlowSheetBusiService = xbjCreateOrderFlowSheetBusiService;
    }

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public void setOrderSaleXbjAtomService(OrderSaleXbjAtomService orderSaleXbjAtomService) {
        this.orderSaleXbjAtomService = orderSaleXbjAtomService;
    }

    public XbjRejectCancelRspBO cancelRejectOrder(XbjRejectCancelReqBO xbjRejectCancelReqBO) {
        this.validateParams(xbjRejectCancelReqBO);
        if (this.isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u4f9b\u5e94\u5546\u91c7\u8d2d\u5355\u62d2\u5355\u53d6\u6d88\u4e1a\u52a1\u670d\u52a1----------------------------------------------------");
            log.debug("\u5165\u53c2:" + JSON.toJSONString((Object)xbjRejectCancelReqBO));
        }
        OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjMapper.querySupplierOrderPursechaseById(xbjRejectCancelReqBO.getPurchaseOrderId(), xbjRejectCancelReqBO.getPurchaserId());
        this.validate(orderPurchaseXbjPO);
        XbjRejectCancelRspBO rsp = new XbjRejectCancelRspBO();
        try {
            XbjOrderFlowSheetRspBO xbjOrderFlowSheetRspBO;
            this.xbjOrderPurchaseBusiService.updateOrderPurchaseStatus(xbjRejectCancelReqBO.getPurchaseOrderId(), null, xbjRejectCancelReqBO.getOldStatus(), xbjRejectCancelReqBO.getNewStatus(), xbjRejectCancelReqBO.getUserId(), null);
            this.orderPurchaseXbjMapper.updateCancelInfo(orderPurchaseXbjPO.getPurchaseOrderId(), "GOODS_SUPPLIER_REJECT_CANCEL", xbjRejectCancelReqBO.getCancelRemark(), new Date(), xbjRejectCancelReqBO.getUserId());
            OrderSaleXbjPO orderSaleXbjPO = this.orderSaleXbjMapper.selectOrderSaleByCondition(orderPurchaseXbjPO.getSaleOrderId(), orderPurchaseXbjPO.getPurchaserId());
            if (orderSaleXbjPO != null) {
                OrderSaleXbjReqBO orderSaleXbjReqBO = this.transferOrderSaleReqBO(orderSaleXbjPO, "GOODS_SUPPLIER_REJECT_CANCEL", orderSaleXbjPO.getSaleOrderStatus(), xbjRejectCancelReqBO.getNewStatus(), xbjRejectCancelReqBO.getUserId());
                this.orderSaleXbjAtomService.salerOrderStatusChange(orderSaleXbjReqBO);
                this.orderSaleXbjMapper.updateCancelInfo(orderSaleXbjPO.getSaleOrderId(), "GOODS_SUPPLIER_REJECT_CANCEL", xbjRejectCancelReqBO.getCancelRemark(), new Date(), xbjRejectCancelReqBO.getUserId());
            }
            XbjOrderFlowSheetReqBO xbjOrderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
            BeanUtils.copyProperties((Object)xbjRejectCancelReqBO, (Object)xbjOrderFlowSheetReqBO);
            xbjOrderFlowSheetReqBO.setOrderId(xbjRejectCancelReqBO.getPurchaseOrderId());
            xbjOrderFlowSheetReqBO.setOrderType(Constant.ORDER_TYPE_PURCHASE);
            xbjOrderFlowSheetReqBO.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
            xbjOrderFlowSheetReqBO.setOrderBusiType("B_8");
            if (this.isDebugEnabled) {
                log.debug("\u8ba2\u5355\u6d41\u7a0b\u6267\u884c\u751f\u6210\u4e1a\u52a1\u670d\u52a1:-----------------------------------------");
                log.debug(JSON.toJSONString((Object)xbjOrderFlowSheetReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
            if ((xbjOrderFlowSheetRspBO = this.xbjCreateOrderFlowSheetBusiService.createOrderFlowSheet(xbjOrderFlowSheetReqBO)) != null && "8888".equals(xbjOrderFlowSheetRspBO.getRespCode())) {
                throw new BusinessException(xbjOrderFlowSheetRspBO.getRespCode(), xbjOrderFlowSheetRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            rsp.setRespCode("8888");
            rsp.setRespDesc("\u5931\u8d25");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    private OrderSaleXbjReqBO transferOrderSaleReqBO(OrderSaleXbjPO orderSaleXbjPO, String goodsSupplierRejectCancel, int saleOrderStatus, Integer newStatus, Long userId) {
        OrderSaleXbjReqBO req = new OrderSaleXbjReqBO();
        req.setSaleOrderId(orderSaleXbjPO.getSaleOrderId());
        req.setSaleOrderStatus(newStatus);
        req.setSaleOrderOldStatus(saleOrderStatus);
        req.setPurchaserId(orderSaleXbjPO.getPurchaserId());
        req.setPurchaserAccountId(orderSaleXbjPO.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(orderSaleXbjPO.getProfessionalOrganizationId());
        req.setCancelReason(goodsSupplierRejectCancel);
        req.setGoodsSupplierId(orderSaleXbjPO.getGoodsSupplierId());
        req.setModifyOprId(userId);
        req.setPurchaserAccountName(orderSaleXbjPO.getPurchaserAccountName());
        req.setSaleOrderType(orderSaleXbjPO.getSaleOrderType());
        return req;
    }

    private void validate(OrderPurchaseXbjPO orderPurchaseXbjPO) {
        if (orderPurchaseXbjPO == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (!Constant.SALSE_ORDER_STATE_REJECT_TO_DEAL.equals(orderPurchaseXbjPO.getPurchaseOrderStatus())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5f53\u524d\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001[purchaseOrderStatus]\u4e0d\u7b26\u5408\u62d2\u5355\u53d6\u6d88\u8981\u6c42,\u62d2\u5355\u53d6\u6d88\u8981\u6c42\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u662f  -> \u62d2\u5355\u5f85\u5904\u7406");
        }
    }

    private void validateParams(XbjRejectCancelReqBO xbjRejectCancelReqBO) {
        if (xbjRejectCancelReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u62d2\u5355\u53d6\u6d88\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjRejectCancelReqBO.getPurchaseOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355id[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjRejectCancelReqBO.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5546id[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjRejectCancelReqBO.getOldStatus() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65e7\u72b6\u6001[oldStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjRejectCancelReqBO.getNewStatus() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65b0\u72b6\u6001[newStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjRejectCancelReqBO.getUserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237id[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjRejectCancelReqBO.getCancelRemark())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u62d2\u5355\u53d6\u6d88\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

