/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.intfce.impl;

import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.QryOrderListXbjAtomService;
import com.cgd.order.intfce.XbjQryOrderListIntfceService;
import com.cgd.order.intfce.bo.XbjOrderConstrInfoBO;
import com.cgd.order.intfce.bo.XbjOrderListQryReqBO;
import com.cgd.order.intfce.bo.XbjOrderServInfoBO;
import com.cgd.order.intfce.bo.XbjOrderShipInfoBO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XbjQryOrderListIntfceServiceImpl
implements XbjQryOrderListIntfceService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryOrderListIntfceService.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private QryOrderListXbjAtomService qryOrderListXbjAtomService;

    public void setQryOrderListXbjAtomService(QryOrderListXbjAtomService qryOrderListXbjAtomService) {
        this.qryOrderListXbjAtomService = qryOrderListXbjAtomService;
    }

    public RspPageBO<XbjOrderShipInfoBO> qryOrderShipListByOrderId(XbjOrderListQryReqBO reqBO) {
        if (isDebugEnabled) {
            log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2BO:" + reqBO.toString());
        }
        String orderType = this.validateParams(reqBO);
        RspPageBO<XbjOrderShipInfoBO> rspPageBO = new RspPageBO<XbjOrderShipInfoBO>();
        if ("sale".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderShipBySale(reqBO.getSaleOrderId(), reqBO.getPageNo(), reqBO.getPageSize());
        } else if ("purchase".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderShipByPurchase(reqBO.getPurchaseOrderId(), reqBO.getPageNo(), reqBO.getPageSize());
        } else {
            rspPageBO.setRespCode("7777");
            rspPageBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
        }
        return rspPageBO;
    }

    public RspPageBO<XbjOrderConstrInfoBO> qryOrderConstrListByOrderId(XbjOrderListQryReqBO reqBO) {
        if (isDebugEnabled) {
            log.debug("\u5386\u53f2\u65bd\u5de5\u5355\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2BO:" + reqBO.toString());
        }
        String orderType = this.validateParams(reqBO);
        RspPageBO<XbjOrderConstrInfoBO> rspPageBO = new RspPageBO<XbjOrderConstrInfoBO>();
        if ("sale".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderConstrBySale(reqBO.getSaleOrderId(), reqBO.getPageNo(), reqBO.getPageSize());
        } else if ("purchase".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderConstrByPurchase(reqBO.getPurchaseOrderId(), reqBO.getPageNo(), reqBO.getPageSize());
        } else {
            rspPageBO.setRespCode("7777");
            rspPageBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
        }
        return rspPageBO;
    }

    public RspPageBO<XbjOrderServInfoBO> qryOrderServListByOrderId(XbjOrderListQryReqBO reqBO) {
        if (isDebugEnabled) {
            log.debug("\u5386\u53f2\u670d\u52a1\u5355\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2BO:" + reqBO.toString());
        }
        String orderType = this.validateParams(reqBO);
        RspPageBO<XbjOrderServInfoBO> rspPageBO = new RspPageBO<XbjOrderServInfoBO>();
        if ("sale".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderServBySale(reqBO.getSaleOrderId(), reqBO.getPageNo(), reqBO.getPageSize());
        } else if ("purchase".equals(orderType)) {
            rspPageBO = this.qryOrderListXbjAtomService.qryOrderServByPurchase(reqBO.getPurchaseOrderId(), reqBO.getPageNo(), reqBO.getPageSize());
        } else {
            rspPageBO.setRespCode("7777");
            rspPageBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25");
        }
        return rspPageBO;
    }

    private String validateParams(XbjOrderListQryReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u8d27\u5355\u5386\u53f2\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPurchaseOrderId()) && StringUtils.isEmpty((CharSequence)reqBO.getSaleOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u8d27\u5355\u5386\u53f2\u5217\u8868\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u91c7\u8d2d\u8ba2\u5355ID\u6216\u9500\u552e\u8ba2\u5355ID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (reqBO.getSaleOrderId() != null) {
            return "sale";
        }
        if (reqBO.getPurchaseOrderId() != null) {
            return "purchase";
        }
        return "";
    }
}

