/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.intfce.impl;

import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPurchaseXbjAtomService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.bo.OrderSaleInfoXbjRspBO;
import com.cgd.order.busi.XbjOrderSendMsgBusiService;
import com.cgd.order.busi.bo.OrderSendMsgBusiReqBO;
import com.cgd.order.busi.bo.XbjSendMsgInfoReqBO;
import com.cgd.order.busi.bo.XbjSendMsgInfoRspBO;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.intfce.XbjSendMessageToProDeliveryService;
import com.cgd.order.intfce.bo.MessageBaseBO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="xbjSendMessageToProDeliveryService")
public class XbjSendMessageToProDeliveryServiceImpl
implements XbjSendMessageToProDeliveryService {
    private static final Logger log = LoggerFactory.getLogger(XbjSendMessageToProDeliveryServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private XbjOrderSendMsgBusiService orderSendMsgBusiService;
    @Autowired
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    @Autowired
    private OrderPurchaseXbjAtomService orderPurchaseXbjAtomService;

    public XbjSendMsgInfoRspBO dealWithMsgSend(XbjSendMsgInfoReqBO xbjSendMsgInfoReq) {
        XbjSendMsgInfoRspBO xbjSendMsgInfoRsp = new XbjSendMsgInfoRspBO();
        try {
            this.verifyParam(xbjSendMsgInfoReq);
            Map infoParam = new HashMap();
            MessageBaseBO messageBaseBO = this.initSmsMapInfo(xbjSendMsgInfoReq);
            infoParam = messageBaseBO.getInfoMap();
            OrderSendMsgBusiReqBO orderSendMsgBusiReq = new OrderSendMsgBusiReqBO();
            ArrayList<String> typeList = new ArrayList<String>();
            typeList.add(xbjSendMsgInfoReq.getSendType());
            orderSendMsgBusiReq.setSmsTemplateId(xbjSendMsgInfoReq.getTemplateId());
            orderSendMsgBusiReq.setEmailTemplateId(xbjSendMsgInfoReq.getTemplateId());
            orderSendMsgBusiReq.setSendTypes(typeList);
            orderSendMsgBusiReq.setEmailParam(infoParam);
            orderSendMsgBusiReq.setSmsParam(infoParam);
            orderSendMsgBusiReq.setMobile(xbjSendMsgInfoReq.getContactPhone());
            orderSendMsgBusiReq.setEmail(xbjSendMsgInfoReq.getContactEmail());
            orderSendMsgBusiReq.setRemindConfigureId(xbjSendMsgInfoReq.getId());
            orderSendMsgBusiReq.setOrderCode(messageBaseBO.getOrderCode());
            RspInfoBO rspBusiBaseBO = this.orderSendMsgBusiService.dealSendMsg(orderSendMsgBusiReq);
            if (null != rspBusiBaseBO && null != rspBusiBaseBO.getRespCode()) {
                if (!"0000".equals(rspBusiBaseBO.getRespCode())) {
                    if (isDebugEnabled) {
                        log.debug("\u8c03\u7528\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\u5f02\u5e38:" + rspBusiBaseBO.getRespDesc());
                    }
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8c03\u7528\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\u5f02\u5e38:" + rspBusiBaseBO.getRespDesc());
                }
            } else {
                if (isDebugEnabled) {
                    log.debug("\u8c03\u7528\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\u8fd4\u56de\u4e3a\u7a7a\uff01");
                }
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8c03\u7528\u77ed\u4fe1\u53d1\u9001\u670d\u52a1\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
            xbjSendMsgInfoRsp.setRespCode("0000");
            xbjSendMsgInfoRsp.setRespDesc("\u4e13\u4e1a\u673a\u6784\u50ac\u4ea4\u901a\u77e5\u5b9e\u73b0\u670d\u52a1\u6210\u529f\uff01");
        }
        catch (Exception e) {
            xbjSendMsgInfoRsp.setRespCode("8888");
            xbjSendMsgInfoRsp.setRespDesc("\u4e13\u4e1a\u673a\u6784\u50ac\u4ea4\u901a\u77e5\u5b9e\u73b0\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
        return xbjSendMsgInfoRsp;
    }

    private MessageBaseBO initSmsMapInfo(XbjSendMsgInfoReqBO xbjSendMsgInfoReq) {
        HashMap<String, String> infoMap;
        MessageBaseBO messageBaseBO;
        block11: {
            messageBaseBO = new MessageBaseBO();
            infoMap = new HashMap<String, String>();
            try {
                if (xbjSendMsgInfoReq.getOrderType() == OrderCenterConstant.ORDER_TYPE.PURCHASE) {
                    OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjAtomService.qryOrderPurchaseByPurchaseOrderIdAndPurchaserId(xbjSendMsgInfoReq.getOrderId(), xbjSendMsgInfoReq.getPurchaserId());
                    if (null == orderPurchase) break block11;
                    if (null == orderPurchase.getPurchaserAccountName()) {
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355[xbjSendMsgInfoReq.getOrderId()]\u8ba2\u5355Id\u4e3a\u7a7a!");
                    }
                    infoMap.put("companyName", orderPurchase.getPurchaserName());
                    if (null == orderPurchase.getPurchaseOrderCode()) {
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355[xbjSendMsgInfoReq.getOrderId()]\u8ba2\u5355Code\u4e3a\u7a7a!");
                    }
                    infoMap.put("orderCode", orderPurchase.getPurchaseOrderCode());
                    messageBaseBO.setOrderCode(orderPurchase.getPurchaseOrderCode());
                    if (null != orderPurchase.getPurchaseOrderName()) {
                        infoMap.put("orderName", orderPurchase.getPurchaseOrderName());
                        break block11;
                    }
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355[xbjSendMsgInfoReq.getOrderId()]\u8ba2\u5355\u540d\u79f0\u4e3a\u7a7a!");
                }
                if (xbjSendMsgInfoReq.getOrderType() == OrderCenterConstant.ORDER_TYPE.SALE) {
                    OrderSaleInfoXbjRspBO orderSaleInfoRsp = this.orderSaleXbjAtomService.queryOrderByCondition(xbjSendMsgInfoReq.getOrderId(), xbjSendMsgInfoReq.getPurchaserId());
                    if (null == orderSaleInfoRsp) break block11;
                    if (null == orderSaleInfoRsp.getPurchaserAccountName()) {
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355[xbjSendMsgInfoReq.getOrderId()]\u8ba2\u5355Id\u4e3a\u7a7a!");
                    }
                    infoMap.put("companyName", orderSaleInfoRsp.getPurchaserName());
                    if (null == orderSaleInfoRsp.getSaleOrderCode()) {
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355[xbjSendMsgInfoReq.getOrderId()]\u8ba2\u5355Code\u4e3a\u7a7a!");
                    }
                    infoMap.put("orderCode", orderSaleInfoRsp.getSaleOrderCode());
                    messageBaseBO.setOrderCode(orderSaleInfoRsp.getSaleOrderCode());
                    if (null != orderSaleInfoRsp.getSaleOrderName()) {
                        infoMap.put("orderName", orderSaleInfoRsp.getSaleOrderName());
                        break block11;
                    }
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355[xbjSendMsgInfoReq.getOrderId()]\u8ba2\u5355\u540d\u79f0\u4e3a\u7a7a!");
                }
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u8ba2\u5355\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug("\u521d\u59cb\u5316\u53c2\u6570\u5f02\u5e38:" + e.getMessage());
                }
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u521d\u59cb\u5316\u53c2\u6570\u5f02\u5e38:" + e.getMessage());
            }
        }
        messageBaseBO.setInfoMap(infoMap);
        return messageBaseBO;
    }

    private void verifyParam(XbjSendMsgInfoReqBO xbjSendMsgInfoReq) {
        if (null == xbjSendMsgInfoReq) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getContactEmail() && null == xbjSendMsgInfoReq.getContactPhone()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u8054\u7cfb\u4eba\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u914d\u7f6eId[Id]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u8ba2\u5355Id[OrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getOrderType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u8ba2\u5355\u7c7b\u578b[OrderType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u91c7\u8d2d\u5546Id[PurchaserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getSendType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u53d1\u9001\u65b9\u5f0f[SendType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == xbjSendMsgInfoReq.getTemplateId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u6a21\u677fId[TemplateId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

