/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.core.common;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PutObjectResult;
import com.chinaj.common.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class FileUploadUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtil.class);
    private static String endPoint;
    private static String endPointIp;
    private static String accesskeyId;
    private static String secretaccesskey;
    private static String bucketName;
    private static OSSClient client;

    public static OSSClient getOSSClient() {
        log.info("\u521d\u59cb\u5316OSS\u5ba2\u6237\u7aef");
        try {
            ClientConfiguration conf = new ClientConfiguration();
            log.info("endPoint:{}, accesskeyId:{}, secretaccesskey:{}", new Object[]{endPoint, accesskeyId, secretaccesskey});
            return new OSSClient(endPoint, accesskeyId, secretaccesskey);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u963f\u91cc\u4e91OSS\u5ba2\u6237\u7aef\u5bf9\u8c61", (Throwable)e);
            return null;
        }
    }

    @Value(value="${oss.endPoint}")
    public void setEndPoint(String endPoint) {
        FileUploadUtil.endPoint = endPoint;
    }

    @Value(value="${oss.endPoint}")
    public void setEndPointIp(String endPointIp) {
        FileUploadUtil.endPointIp = endPointIp;
    }

    @Value(value="${oss.secretaccesskey}")
    public void setSecretaccesskey(String secretaccesskey) {
        FileUploadUtil.secretaccesskey = secretaccesskey;
    }

    @Value(value="${oss.bucketName}")
    public void setBucketName(String bucketName) {
        FileUploadUtil.bucketName = bucketName;
    }

    @Value(value="${oss.accesskeyId}")
    public void setAccesskeyId(String accesskeyId) {
        FileUploadUtil.accesskeyId = accesskeyId;
    }

    private FileUploadUtil() {
    }

    public static Map<String, String> upload(String fileName, InputStream is) {
        HashMap<String, String> uploadResult = new HashMap<String, String>();
        try {
            String fileExtName;
            String suffixList;
            if (StringUtils.isNotEmpty((String)fileName) && !(suffixList = "DOC-XLS-DOCX-XLSX-RAR-ZIP-JPG-GIF-JPEG-PNG-PDF").contains(fileExtName = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase())) {
                uploadResult.put("errorMsg", "\u4e0a\u4f20\u6587\u4ef6\u4e3a\u4e0d\u5408\u6cd5\u7684\u683c\u5f0f");
                uploadResult.put("isSuccessful", Boolean.FALSE.toString());
                return uploadResult;
            }
            String fileType = "";
            if (fileName != null) {
                String[] split = fileName.split("\\.");
                int length = split.length;
                fileType = split[length - 1];
            }
            String key = fileType + "/" + System.currentTimeMillis() + "/" + fileName;
            log.info("endPoint:{}, accesskeyId:{}, secretaccesskey:{}", new Object[]{endPoint, accesskeyId, secretaccesskey});
            log.info("bucketName:{}", (Object)bucketName);
            OSSClient client = new OSSClient(endPoint, accesskeyId, secretaccesskey);
            PutObjectResult result = client.putObject(bucketName, key, is);
            uploadResult.put("fileType", fileType);
            uploadResult.put("fileName", key);
            uploadResult.put("isSuccessful", Boolean.TRUE.toString());
            client.shutdown();
        }
        catch (Exception e) {
            log.error("OSSClient\u5f02\u5e38\uff1a", (Throwable)e);
            uploadResult.put("errorMsg", "OSSClient\u5f02\u5e38");
            uploadResult.put("isSuccessful", Boolean.FALSE.toString());
            return uploadResult;
        }
        return uploadResult;
    }

    public static void download(String fileName, HttpServletResponse response, HttpServletRequest request) {
        String fileExtName;
        String suffixList;
        if (StringUtils.isNotEmpty((String)fileName) && !(suffixList = "DOC-XLS-DOCX-XLSX-RAR-ZIP-JPG-GIF-JPEG-PNG-PDF").contains(fileExtName = fileName.substring(fileName.lastIndexOf(".") + 1).toUpperCase())) {
            try {
                throw new Exception("\u4e0b\u8f7d\u6587\u4ef6\u4e3a\u4e0d\u5408\u6cd5\u7684\u683c\u5f0f");
            }
            catch (Exception e) {
                log.error("\u4e0b\u8f7d\u5f02\u5e38", (Throwable)e);
            }
        }
        OSSClient client = new OSSClient(endPoint, accesskeyId, secretaccesskey);
        log.info("endPoint:{}, accesskeyId:{}, secretaccesskey:{}", new Object[]{endPoint, accesskeyId, secretaccesskey});
        log.info("bucketName:{}", (Object)bucketName);
        OSSObject object = client.getObject(bucketName, fileName);
        try (InputStream is = object.getObjectContent();
             BufferedInputStream bis = new BufferedInputStream(is);
             BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());){
            String[] split = fileName.split("\\/");
            fileName = split[split.length - 1];
            String userAgent = request.getHeader("user-agent").toLowerCase();
            if (userAgent.contains("msie") || userAgent.contains("like gecko")) {
                fileName = URLEncoder.encode(fileName, "UTF-8");
                fileName = fileName.replaceAll("\\+", "%20");
            } else {
                fileName = new String(fileName.getBytes("UTF-8"), "iso-8859-1");
                fileName = fileName.replaceAll("\\+", "%20");
            }
            response.addHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
            byte[] car = new byte[1024];
            int local = 0;
            while ((local = bis.read(car)) != -1) {
                bos.write(car, 0, local);
            }
            bos.flush();
            client.shutdown();
        }
        catch (IOException e) {
            e.getMessage();
        }
    }

    public static OSSObject getPDFStream(String pdfName) {
        if (client == null) {
            client = FileUploadUtil.getOSSClient();
        }
        OSSObject ossObject = client.getObject(bucketName, pdfName);
        return ossObject;
    }

    public static String getTitleName(String filePath) {
        try {
            if (StringUtils.isNotEmpty((String)filePath)) {
                String[] split = filePath.split("/");
                return split[split.length - 1].split("\\.")[0];
            }
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
            return filePath;
        }
        return filePath;
    }
}

