/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.core.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContextUtil
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SpringContextUtil.class);
    private static ApplicationContext applicationContext = null;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        log.info("------SpringContextUtil setApplicationContext-------");
        SpringContextUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) throws BeansException {
        return applicationContext.getBean(name);
    }

    public static String getService(String className, String method, String[] jsons, String[] args) throws Exception {
        Object targetObj = SpringContextUtil.getBean(className);
        int jsonIndex = 0;
        Object[] argsObj = new Object[args.length];
        Class[] classes = new Class[args.length];
        for (String arg : args) {
            classes[jsonIndex] = Class.forName(arg);
            String json = jsons[jsonIndex];
            argsObj[jsonIndex] = JSON.parseObject((String)json, (Class)classes[jsonIndex]);
            ++jsonIndex;
        }
        Method method1 = targetObj.getClass().getMethod(method, classes);
        Object result = method1.invoke(targetObj, argsObj);
        return JSONObject.toJSONString((Object)result);
    }

    public static <T> T getBeanByName(Class<T> clazz) throws BeansException {
        try {
            char[] cs = clazz.getSimpleName().toCharArray();
            cs[0] = (char)(cs[0] + 32);
            return (T)applicationContext.getBean(String.valueOf(cs));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean containsBean(String name) {
        return applicationContext.containsBean(name);
    }

    public static boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return applicationContext.isSingleton(name);
    }
}

