/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.core.common.aspectj;

import com.chinaj.common.core.domain.BaseEntity;
import com.chinaj.common.core.domain.entity.SysRole;
import com.chinaj.common.core.domain.entity.SysUser;
import com.chinaj.common.core.domain.model.LoginUser;
import com.chinaj.common.utils.ServletUtils;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.common.utils.spring.SpringUtils;
import com.chinaj.core.common.annotations.DataScope;
import com.chinaj.core.framework.TokenService;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataScopeAspect {
    public static final String DATA_SCOPE_ALL = "1";
    public static final String DATA_SCOPE_CUSTOM = "2";
    public static final String DATA_SCOPE_DEPT = "3";
    public static final String DATA_SCOPE_DEPT_AND_CHILD = "4";
    public static final String DATA_SCOPE_SELF = "5";
    public static final String DATA_SCOPE = "dataScope";
    public static final String PERM_TYPE_ROLE = "role";
    public static final String PERM_TYPE_AREA = "area";
    public static final String HEAD_OFFICE_CODE = "09";
    public static final String BEN_BU_FLAG = "1";

    public static void dataScopeFilter(JoinPoint joinPoint, SysUser user, String deptAlias, String userAlias, String permType, String benbuFlag) {
        Object params;
        StringBuilder sqlString;
        block10: {
            block8: {
                Object provinceCode;
                block9: {
                    sqlString = new StringBuilder();
                    if (!PERM_TYPE_AREA.equals(permType)) break block8;
                    if (!StringUtils.isNotEmpty((String)benbuFlag) || !"1".equals(benbuFlag)) break block9;
                    provinceCode = user.getProvinceCode();
                    if (StringUtils.isNotEmpty((String)provinceCode)) {
                        sqlString.append(StringUtils.format((String)" OR {} IN ( select user_id from sys_user su where province_code={}  ) ", (Object[])new Object[]{userAlias, provinceCode}));
                    }
                    break block10;
                }
                provinceCode = user.getProvinceCode();
                if (StringUtils.isNotEmpty((String)provinceCode) && HEAD_OFFICE_CODE.equals(provinceCode)) break block10;
                sqlString.append(StringUtils.format((String)" OR {} IN ( select user_id from sys_user su where province_code={} or province_code='09' ) ", (Object[])new Object[]{userAlias, provinceCode}));
                break block10;
            }
            for (SysRole role : user.getRoles()) {
                String dataScope = role.getDataScope();
                if ("1".equals(dataScope)) {
                    sqlString = new StringBuilder();
                    break;
                }
                if (DATA_SCOPE_CUSTOM.equals(dataScope)) {
                    sqlString.append(StringUtils.format((String)" OR {}.dept_id IN ( SELECT dept_id FROM sys_role_dept WHERE role_id = {} ) ", (Object[])new Object[]{deptAlias, role.getRoleId()}));
                    continue;
                }
                if (DATA_SCOPE_DEPT.equals(dataScope)) {
                    sqlString.append(StringUtils.format((String)" OR {}.dept_id = {} ", (Object[])new Object[]{deptAlias, user.getDeptId()}));
                    continue;
                }
                if (DATA_SCOPE_DEPT_AND_CHILD.equals(dataScope)) {
                    sqlString.append(StringUtils.format((String)" OR {}.dept_id IN ( SELECT dept_id FROM sys_dept WHERE dept_id = {} or find_in_set( {} , ancestors ) )", (Object[])new Object[]{deptAlias, user.getDeptId(), user.getDeptId()}));
                    continue;
                }
                if (!DATA_SCOPE_SELF.equals(dataScope)) continue;
                if (StringUtils.isNotBlank((CharSequence)userAlias)) {
                    sqlString.append(StringUtils.format((String)" OR {}.user_id = {} ", (Object[])new Object[]{userAlias, user.getUserId()}));
                    continue;
                }
                sqlString.append(" OR 1=0 ");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)sqlString.toString()) && StringUtils.isNotNull((Object)(params = joinPoint.getArgs()[0])) && params instanceof BaseEntity) {
            BaseEntity baseEntity = (BaseEntity)params;
            baseEntity.getParams().put(DATA_SCOPE, " AND (" + sqlString.substring(4) + ")");
        }
    }

    @Pointcut(value="@annotation(com.chinaj.core.common.annotations.DataScope)")
    public void dataScopePointCut() {
    }

    @Before(value="dataScopePointCut()")
    public void doBefore(JoinPoint point) throws Throwable {
        this.handleDataScope(point);
    }

    protected void handleDataScope(JoinPoint joinPoint) {
        SysUser currentUser;
        DataScope controllerDataScope = this.getAnnotationLog(joinPoint);
        if (controllerDataScope == null) {
            return;
        }
        LoginUser loginUser = ((TokenService)SpringUtils.getBean(TokenService.class)).getLoginUser(ServletUtils.getRequest());
        if (StringUtils.isNotNull((Object)loginUser) && StringUtils.isNotNull((Object)(currentUser = loginUser.getUser())) && !currentUser.isAdmin()) {
            DataScopeAspect.dataScopeFilter(joinPoint, currentUser, controllerDataScope.deptAlias(), controllerDataScope.userAlias(), controllerDataScope.permType(), controllerDataScope.benbuFlag());
        }
    }

    private DataScope getAnnotationLog(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(DataScope.class);
        }
        return null;
    }
}

