/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.core.common.config;

import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EncryptPropertyConfig {
    @Value(value="${jasypt.encryptor.password:12333}")
    private volatile String password;

    @Bean(value={"jasyptStringEncryptor"})
    public StringEncryptor stringEncryptor() {
        PooledPBEStringEncryptor stringEncrypt = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        config.setPassword(this.password);
        config.setAlgorithm("PBEWithMD5AndDES");
        config.setKeyObtentionIterations("707");
        config.setPoolSize("1");
        config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
        config.setIvGeneratorClassName("org.jasypt.iv.RandomIvGenerator");
        config.setStringOutputType("base64");
        stringEncrypt.setConfig((PBEConfig)config);
        return stringEncrypt;
    }
}

