/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.core.common.ext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.core.domain.entity.SysUser;
import com.chinaj.common.exception.CustomException;
import com.chinaj.common.utils.DateUtils;
import com.chinaj.common.utils.http.HttpUtils;
import com.chinaj.common.utils.sign.Md5Utils;
import com.chinaj.core.common.ext.domain.TokenMemberEntity;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ExtConnUtils {
    private static final Logger log = LoggerFactory.getLogger(ExtConnUtils.class);
    private static String callSystem;
    private static String orgIp;
    private static String orgGroupId;
    private static String commonUrl;
    private static String userInfo;

    @Value(value="${liantong.org.callSystem}")
    public void setCallSystem(String callSystem) {
        ExtConnUtils.callSystem = callSystem;
    }

    @Value(value="${liantong.org.ip}")
    public void setOrgIp(String orgIp) {
        ExtConnUtils.orgIp = orgIp;
    }

    @Value(value="${liantong.org.groupId}")
    public void setOrgGroupId(String orgGroupId) {
        ExtConnUtils.orgGroupId = orgGroupId;
    }

    @Value(value="${liantong.org.commonUrl}")
    public void setCommonUrl(String commonUrl) {
        ExtConnUtils.commonUrl = commonUrl;
    }

    @Value(value="${liantong.org.method.userInfo}")
    public void setUserInfo(String userInfo) {
        ExtConnUtils.userInfo = userInfo;
    }

    public static Map<String, String> getOrgHeader(String sessionId) {
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)sessionId)) {
            log.error("\u5165\u53c2\u4e3a\u7a7a\uff01");
            throw new CustomException("\u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        Date date = new Date();
        header.put("CallSystem", callSystem);
        String dateStr = DateUtils.parseDateToStr((String)"yyyy-MM-dd HH:mm:ss", (Date)date);
        header.put("requestTime", dateStr);
        String key = Md5Utils.hash((String)(callSystem + dateStr));
        header.put("key", key);
        return header;
    }

    public static SysUser getUserInfo(String sessionId) {
        try {
            Map<String, String> header = ExtConnUtils.getOrgHeader(sessionId);
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("token", callSystem);
            params.put("sessionID", sessionId);
            String conn = HttpUtils.postForm((String)(orgIp + orgGroupId + commonUrl + userInfo), params, header);
            if (StringUtils.isNotBlank((CharSequence)conn)) {
                JSONObject connJson = JSON.parseObject((String)conn);
                if ("false".equals(connJson.get((Object)"success"))) {
                    log.error(connJson.getString("msg"));
                    return null;
                }
                TokenMemberEntity rsp = (TokenMemberEntity)JSON.parseObject((String)conn, TokenMemberEntity.class);
                SysUser res = new SysUser();
                res.setUserId(rsp.getUserId() == null ? null : rsp.getUserId());
                res.setDeptId(StringUtils.isBlank((CharSequence)rsp.getOrgCode()) ? null : Long.valueOf(Long.parseLong(rsp.getOrgCode())));
                res.setNickName(StringUtils.isBlank((CharSequence)rsp.getTrueName()) ? null : rsp.getTrueName());
                res.setUserName(StringUtils.isBlank((CharSequence)rsp.getUserName()) ? null : rsp.getUserName());
                res.setEmail(StringUtils.isBlank((CharSequence)rsp.getEmail()) ? null : rsp.getEmail());
                res.setPhonenumber(StringUtils.isBlank((CharSequence)rsp.getMobilePhone()) ? null : rsp.getMobilePhone());
                res.setSex(rsp.getSex() == null ? null : String.valueOf(rsp.getSex()));
                res.setPassword(StringUtils.isBlank((CharSequence)rsp.getPassWord()) ? null : rsp.getPassWord());
                return res;
            }
            return null;
        }
        catch (IOException ioEx) {
            log.error("IOEx\uff1a", (Throwable)ioEx);
            throw new CustomException("IOEx" + ioEx.getMessage());
        }
        catch (Exception e) {
            log.error("http\u8bf7\u6c42\u5931\u8d25\uff1a", (Throwable)e);
            throw new CustomException("http\u8bf7\u6c42\u5931\u8d25" + e.getMessage());
        }
    }
}

