/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.sys.generator.util;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Decoder;

@Service
public class DesService {
    private static final String DES_ALGORITHM = "DES";
    public static final String DES_KEY = "55369106";
    private static final Logger log = LoggerFactory.getLogger(DesService.class);

    public String encryption(String plainData) throws Exception {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(DES_ALGORITHM);
            cipher.init(1, DesService.generateKey(DES_KEY));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            // empty catch block
        }
        try {
            byte[] buf = cipher.doFinal(plainData.getBytes());
            return Base64Utils.encode(buf);
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
            throw new Exception("IllegalBlockSizeException", e);
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
            throw new Exception("BadPaddingException", e);
        }
    }

    public String encryptions(String plainData, String desKey) throws Exception {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(DES_ALGORITHM);
            cipher.init(1, DesService.generateKey(desKey));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return plainData;
    }

    public String encryptionByKey(String plainData, String desKey) throws Exception {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(DES_ALGORITHM);
            cipher.init(1, DesService.generateKey(desKey));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            // empty catch block
        }
        try {
            byte[] buf = cipher.doFinal(plainData.getBytes());
            return Base64Utils.encode(buf);
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
            throw new Exception("IllegalBlockSizeException", e);
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
            throw new Exception("BadPaddingException", e);
        }
    }

    public String decryption(String secretData) throws Exception {
        log.info("\u5f00\u59cb\u89e3\u5bc6\u53c2\u6570\u4e3a\uff1a " + secretData);
        BASE64Decoder base64De = new BASE64Decoder();
        byte[] buf = new byte[]{};
        try {
            Cipher cipher = null;
            cipher = Cipher.getInstance(DES_ALGORITHM);
            cipher.init(2, DesService.generateKey(DES_KEY));
            buf = cipher.doFinal(base64De.decodeBuffer(secretData));
        }
        catch (Exception e) {
            log.info("\u89e3\u5bc6\u5931\u8d25\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
            e.printStackTrace();
        }
        return new String(buf);
    }

    private static SecretKey generateKey(String secretKey) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(DES_ALGORITHM);
        byte[] a = secretKey.getBytes();
        log.info("a===================" + a.length);
        DESKeySpec keySpec = new DESKeySpec(secretKey.getBytes());
        keyFactory.generateSecret(keySpec);
        return keyFactory.generateSecret(keySpec);
    }

    private static class Base64Utils {
        private static char[] alphabet;
        private static byte[] codes;

        private Base64Utils() {
        }

        private static String encode(byte[] data) {
            char[] out = new char[(data.length + 2) / 3 * 4];
            int i = 0;
            int index = 0;
            while (i < data.length) {
                boolean quad = false;
                boolean trip = false;
                int val = 0xFF & data[i];
                val <<= 8;
                if (i + 1 < data.length) {
                    val |= 0xFF & data[i + 1];
                    trip = true;
                }
                val <<= 8;
                if (i + 2 < data.length) {
                    val |= 0xFF & data[i + 2];
                    quad = true;
                }
                out[index + 3] = alphabet[quad ? val & 0x3F : 64];
                out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
                out[index + 1] = alphabet[(val >>= 6) & 0x3F];
                out[index + 0] = alphabet[(val >>= 6) & 0x3F];
                i += 3;
                index += 4;
            }
            return new String(out);
        }

        private static byte[] decode(char[] data) {
            int len = (data.length + 3) / 4 * 3;
            if (data.length > 0 && data[data.length - 1] == '=') {
                --len;
            }
            if (data.length > 1 && data[data.length - 2] == '=') {
                --len;
            }
            byte[] out = new byte[len];
            int shift = 0;
            int accum = 0;
            int index = 0;
            for (int ix = 0; ix < data.length; ++ix) {
                byte value = codes[data[ix] & 0xFF];
                if (value < 0) continue;
                accum <<= 6;
                accum |= value;
                if ((shift += 6) < 8) continue;
                out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
            }
            return out;
        }

        static {
            int i;
            alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
            codes = new byte[256];
            for (i = 0; i < 256; ++i) {
                Base64Utils.codes[i] = -1;
            }
            for (i = 65; i <= 90; ++i) {
                Base64Utils.codes[i] = (byte)(i - 65);
            }
            for (i = 97; i <= 122; ++i) {
                Base64Utils.codes[i] = (byte)(26 + i - 97);
            }
            for (i = 48; i <= 57; ++i) {
                Base64Utils.codes[i] = (byte)(52 + i - 48);
            }
            Base64Utils.codes[43] = 62;
            Base64Utils.codes[47] = 63;
        }
    }
}

