/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.UUID;

public class ClickHouseBigDecimalValue
extends ClickHouseObjectValue<BigDecimal> {
    public static ClickHouseBigDecimalValue ofNull() {
        return ClickHouseBigDecimalValue.ofNull(null);
    }

    public static ClickHouseBigDecimalValue ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseBigDecimalValue ? (ClickHouseBigDecimalValue)((ClickHouseBigDecimalValue)ref).set(null) : new ClickHouseBigDecimalValue(null);
    }

    public static ClickHouseBigDecimalValue of(BigDecimal value) {
        return ClickHouseBigDecimalValue.of(null, value);
    }

    public static ClickHouseBigDecimalValue of(ClickHouseValue ref, BigDecimal value) {
        return ref instanceof ClickHouseBigDecimalValue ? (ClickHouseBigDecimalValue)((ClickHouseBigDecimalValue)ref).set(value) : new ClickHouseBigDecimalValue(value);
    }

    protected ClickHouseBigDecimalValue(BigDecimal value) {
        super(value);
    }

    @Override
    public ClickHouseBigDecimalValue copy(boolean deep) {
        return new ClickHouseBigDecimalValue((BigDecimal)this.getValue());
    }

    @Override
    public byte asByte() {
        return this.isNullOrEmpty() ? (byte)0 : ((BigDecimal)this.getValue()).byteValueExact();
    }

    @Override
    public short asShort() {
        return this.isNullOrEmpty() ? (short)0 : ((BigDecimal)this.getValue()).shortValueExact();
    }

    @Override
    public int asInteger() {
        return this.isNullOrEmpty() ? 0 : ((BigDecimal)this.getValue()).intValueExact();
    }

    @Override
    public long asLong() {
        return this.isNullOrEmpty() ? 0L : ((BigDecimal)this.getValue()).longValueExact();
    }

    @Override
    public BigInteger asBigInteger() {
        if (this.isNullOrEmpty()) {
            return null;
        }
        BigDecimal value = (BigDecimal)this.getValue();
        if (value.remainder(BigDecimal.ONE) != BigDecimal.ZERO) {
            throw new IllegalArgumentException("Failed to convert BigDecimal to BigInteger: " + value);
        }
        return value.toBigInteger();
    }

    @Override
    public float asFloat() {
        return this.isNullOrEmpty() ? 0.0f : ((BigDecimal)this.getValue()).floatValue();
    }

    @Override
    public double asDouble() {
        return this.isNullOrEmpty() ? 0.0 : ((BigDecimal)this.getValue()).doubleValue();
    }

    @Override
    public BigDecimal asBigDecimal() {
        return (BigDecimal)this.getValue();
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        BigDecimal v = (BigDecimal)this.getValue();
        if (v != null && v.scale() != scale) {
            v = v.setScale(scale, RoundingMode.DOWN);
        }
        return v;
    }

    @Override
    public Object asObject() {
        return this.getValue();
    }

    public int getScale() {
        return this.isNullOrEmpty() ? 0 : ((BigDecimal)this.getValue()).scale();
    }

    @Override
    public String toSqlExpression() {
        return this.isNullOrEmpty() ? "NULL" : String.valueOf(this.getValue());
    }

    @Override
    public ClickHouseBigDecimalValue update(boolean value) {
        this.set(value ? BigDecimal.ONE : BigDecimal.ZERO);
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(char value) {
        this.set(BigDecimal.valueOf(value));
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(byte value) {
        this.set(BigDecimal.valueOf(value));
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(short value) {
        this.set(BigDecimal.valueOf(value));
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(int value) {
        this.set(BigDecimal.valueOf(value));
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(long value) {
        this.set(BigDecimal.valueOf(value));
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(float value) {
        this.set(BigDecimal.valueOf(value));
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(double value) {
        this.set(BigDecimal.valueOf(value));
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(BigInteger value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(new BigDecimal(value));
        }
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(BigDecimal value) {
        this.set(value);
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(Enum<?> value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(BigDecimal.valueOf(value.ordinal()));
        }
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(Inet4Address value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(new BigDecimal(ClickHouseValues.convertToBigInteger(value)));
        }
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(Inet6Address value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(new BigDecimal(ClickHouseValues.convertToBigInteger(value)));
        }
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(LocalDate value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(BigDecimal.valueOf(value.toEpochDay()));
        }
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(LocalTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(BigDecimal.valueOf(value.toSecondOfDay()));
        }
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(LocalDateTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(BigDecimal.valueOf(value.toEpochSecond(ZoneOffset.UTC)));
        }
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(String value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(new BigDecimal(value));
        }
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(UUID value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(new BigDecimal(ClickHouseValues.convertToBigInteger(value)));
        }
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(ClickHouseValue value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.asBigDecimal(this.getScale()));
        }
        return this;
    }

    @Override
    public ClickHouseBigDecimalValue update(Object value) {
        if (value instanceof BigDecimal) {
            this.set((BigDecimal)value);
            return this;
        }
        super.update(value);
        return this;
    }
}

