/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.data.BinaryStreamUtils;
import com.clickhouse.client.data.ClickHouseCityHash;
import java.io.IOException;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;

public class ClickHouseLZ4OutputStream
extends OutputStream {
    private static final LZ4Factory factory = LZ4Factory.fastestInstance();
    private final OutputStream output;
    private final LZ4Compressor compressor;
    private final byte[] currentBlock;
    private final byte[] compressedBlock;
    private int pointer;

    public ClickHouseLZ4OutputStream(OutputStream stream, int maxCompressBlockSize) {
        this.output = ClickHouseChecker.nonNull(stream, "output");
        this.compressor = factory.fastCompressor();
        this.currentBlock = new byte[maxCompressBlockSize];
        this.compressedBlock = new byte[this.compressor.maxCompressedLength(maxCompressBlockSize) + 15];
        this.compressedBlock[16] = -126;
        this.pointer = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.currentBlock[this.pointer++] = (byte)b;
        if (this.pointer == this.currentBlock.length) {
            this.writeBlock();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int blockSize = this.currentBlock.length;
        int rest = blockSize - this.pointer;
        while (len >= rest) {
            System.arraycopy(b, off, this.currentBlock, this.pointer, rest);
            this.pointer += rest;
            this.writeBlock();
            off += rest;
            len -= rest;
            rest = blockSize;
        }
        if (len > 0) {
            System.arraycopy(b, off, this.currentBlock, this.pointer, len);
            this.pointer += len;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.pointer != 0) {
            this.writeBlock();
        }
        this.output.flush();
    }

    private void writeBlock() throws IOException {
        int compressed = this.compressor.compress(this.currentBlock, 0, this.pointer, this.compressedBlock, 25);
        int compressedSizeWithHeader = compressed + 9;
        BinaryStreamUtils.setInt32(this.compressedBlock, 17, compressedSizeWithHeader);
        BinaryStreamUtils.setInt32(this.compressedBlock, 21, this.pointer);
        long[] hash = ClickHouseCityHash.cityHash128(this.compressedBlock, 16, compressedSizeWithHeader);
        BinaryStreamUtils.setInt64(this.compressedBlock, 0, hash[0]);
        BinaryStreamUtils.setInt64(this.compressedBlock, 8, hash[1]);
        this.output.write(this.compressedBlock, 0, compressed + 25);
        this.pointer = 0;
    }
}

