/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data.array;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;

public class ClickHouseFloatArrayValue
extends ClickHouseObjectValue<float[]> {
    private static final String TYPE_NAME = "float[]";

    public static ClickHouseFloatArrayValue ofEmpty() {
        return ClickHouseFloatArrayValue.of(ClickHouseValues.EMPTY_FLOAT_ARRAY);
    }

    public static ClickHouseFloatArrayValue of(float[] value) {
        return ClickHouseFloatArrayValue.of(null, value);
    }

    public static ClickHouseFloatArrayValue of(ClickHouseValue ref, float[] value) {
        return ref instanceof ClickHouseFloatArrayValue ? ((ClickHouseFloatArrayValue)ref).set(value) : new ClickHouseFloatArrayValue(value);
    }

    protected ClickHouseFloatArrayValue(float[] value) {
        super(value);
    }

    protected ClickHouseFloatArrayValue set(float[] value) {
        super.set(ClickHouseChecker.nonNull(value, "Array"));
        return this;
    }

    @Override
    public Object[] asArray() {
        float[] v = (float[])this.getValue();
        int len = v.length;
        Object[] array = new Float[len];
        for (int i = 0; i < len; ++i) {
            array[i] = Float.valueOf(v[i]);
        }
        return array;
    }

    public <E> E[] asArray(Class<E> clazz) {
        float[] v = (float[])this.getValue();
        int len = v.length;
        E[] array = ClickHouseValues.createObjectArray(clazz, len, 1);
        for (int i = 0; i < len; ++i) {
            array[i] = clazz.cast(Float.valueOf(v[i]));
        }
        return array;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        float[] v = (float[])this.getValue();
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (int i = 0; i < v.length; ++i) {
            map.put(keyClass.cast(i + 1), valueClass.cast(Float.valueOf(v[i])));
        }
        return map;
    }

    @Override
    public String asString(int length, Charset charset) {
        String str = Arrays.toString((float[])this.getValue());
        if (length > 0) {
            ClickHouseChecker.notWithDifferentLength(str.getBytes(charset == null ? StandardCharsets.UTF_8 : charset), length);
        }
        return str;
    }

    @Override
    public ClickHouseFloatArrayValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseFloatArrayValue((float[])this.getValue());
        }
        float[] value = (float[])this.getValue();
        return new ClickHouseFloatArrayValue(Arrays.copyOf(value, value.length));
    }

    @Override
    public boolean isNullOrEmpty() {
        return ((float[])this.getValue()).length == 0;
    }

    @Override
    public ClickHouseFloatArrayValue resetToNullOrEmpty() {
        this.set(ClickHouseValues.EMPTY_FLOAT_ARRAY);
        return this;
    }

    @Override
    public String toSqlExpression() {
        int len;
        float[] value = (float[])this.getValue();
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder().append('[');
        for (int i = 0; i < len; ++i) {
            builder.append(value[i]).append(',');
        }
        builder.setLength(builder.length() - 1);
        return builder.append(']').toString();
    }

    @Override
    public ClickHouseFloatArrayValue update(boolean[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        float[] v = new float[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i] ? 1.0f : 0.0f;
        }
        return this.set(v);
    }

    @Override
    public ClickHouseFloatArrayValue update(char[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        float[] v = new float[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseFloatArrayValue update(byte value) {
        return this.set(new float[]{value});
    }

    @Override
    public ClickHouseFloatArrayValue update(byte[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        float[] v = new float[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseFloatArrayValue update(short value) {
        return this.set(new float[]{value});
    }

    @Override
    public ClickHouseFloatArrayValue update(short[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        float[] v = new float[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseFloatArrayValue update(int value) {
        return this.set(new float[]{value});
    }

    @Override
    public ClickHouseFloatArrayValue update(int[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        float[] v = new float[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseFloatArrayValue update(long value) {
        return this.set(new float[]{value});
    }

    @Override
    public ClickHouseFloatArrayValue update(long[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        float[] v = new float[len];
        for (int i = 0; i < len; ++i) {
            v[i] = value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseFloatArrayValue update(float value) {
        return this.set(new float[]{value});
    }

    @Override
    public ClickHouseFloatArrayValue update(float[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        return this.set(Arrays.copyOf(value, len));
    }

    @Override
    public ClickHouseFloatArrayValue update(double value) {
        return this.set(new float[]{(float)value});
    }

    @Override
    public ClickHouseFloatArrayValue update(double[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        float[] v = new float[len];
        for (int i = 0; i < len; ++i) {
            v[i] = (float)value[i];
        }
        return this.set(v);
    }

    @Override
    public ClickHouseFloatArrayValue update(BigInteger value) {
        float[] fArray;
        if (value == null) {
            fArray = ClickHouseValues.EMPTY_FLOAT_ARRAY;
        } else {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = value.floatValue();
        }
        return this.set(fArray);
    }

    @Override
    public ClickHouseFloatArrayValue update(BigDecimal value) {
        float[] fArray;
        if (value == null) {
            fArray = ClickHouseValues.EMPTY_FLOAT_ARRAY;
        } else {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = value.floatValue();
        }
        return this.set(fArray);
    }

    @Override
    public ClickHouseFloatArrayValue update(Enum<?> value) {
        float[] fArray;
        if (value == null) {
            fArray = ClickHouseValues.EMPTY_FLOAT_ARRAY;
        } else {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = value.ordinal();
        }
        return this.set(fArray);
    }

    @Override
    public ClickHouseFloatArrayValue update(Inet4Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet4Address", TYPE_NAME);
    }

    @Override
    public ClickHouseFloatArrayValue update(Inet6Address value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("Inet6Address", TYPE_NAME);
    }

    @Override
    public ClickHouseFloatArrayValue update(LocalDate value) {
        float[] fArray;
        if (value == null) {
            fArray = ClickHouseValues.EMPTY_FLOAT_ARRAY;
        } else {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = value.toEpochDay();
        }
        return this.set(fArray);
    }

    @Override
    public ClickHouseFloatArrayValue update(LocalTime value) {
        float[] fArray;
        if (value == null) {
            fArray = ClickHouseValues.EMPTY_FLOAT_ARRAY;
        } else {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = value.toSecondOfDay();
        }
        return this.set(fArray);
    }

    @Override
    public ClickHouseFloatArrayValue update(LocalDateTime value) {
        float[] fArray;
        if (value == null) {
            fArray = ClickHouseValues.EMPTY_FLOAT_ARRAY;
        } else {
            float[] fArray2 = new float[1];
            fArray = fArray2;
            fArray2[0] = value.toEpochSecond(ZoneOffset.UTC);
        }
        return this.set(fArray);
    }

    @Override
    public ClickHouseFloatArrayValue update(Collection<?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        float[] v = new float[size];
        int index = 0;
        for (Object o : value) {
            v[index++] = o == null ? 0.0f : ((Number)o).floatValue();
        }
        return this.set(v);
    }

    @Override
    public ClickHouseFloatArrayValue update(Enumeration<?> value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        LinkedList<Number> v = new LinkedList<Number>();
        while (value.hasMoreElements()) {
            v.add((Number)value.nextElement());
        }
        float[] values = new float[v.size()];
        int index = 0;
        for (Number n : v) {
            values[index++] = n == null ? 0.0f : n.floatValue();
        }
        return this.set(values);
    }

    @Override
    public ClickHouseFloatArrayValue update(Map<?, ?> value) {
        int size;
        int n = size = value == null ? 0 : value.size();
        if (size == 0) {
            return this.resetToNullOrEmpty();
        }
        float[] v = new float[size];
        int index = 0;
        for (Map.Entry<?, ?> e : value.entrySet()) {
            Object o = e.getValue();
            v[index++] = o == null ? 0.0f : ((Number)e.getValue()).floatValue();
        }
        return this.set(v);
    }

    @Override
    public ClickHouseFloatArrayValue update(String value) {
        return this.set(new float[]{Float.parseFloat(value)});
    }

    @Override
    public ClickHouseFloatArrayValue update(UUID value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        throw this.newUnsupportedException("UUID", TYPE_NAME);
    }

    @Override
    public ClickHouseFloatArrayValue update(ClickHouseValue value) {
        if (value == null || value.isNullOrEmpty()) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof ClickHouseFloatArrayValue) {
            this.set((float[])((ClickHouseFloatArrayValue)value).getValue());
        } else {
            this.update(value.asArray());
        }
        return this;
    }

    @Override
    public ClickHouseFloatArrayValue update(Object[] value) {
        int len;
        int n = len = value == null ? 0 : value.length;
        if (len == 0) {
            return this.resetToNullOrEmpty();
        }
        float[] values = new float[len];
        for (int i = 0; i < len; ++i) {
            Object o = value[i];
            values[i] = o == null ? 0.0f : ((Number)o).floatValue();
        }
        this.set(values);
        return this;
    }

    @Override
    public ClickHouseValue updateUnknown(Object value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (value instanceof Number) {
            return this.set(new float[]{((Number)value).floatValue()});
        }
        throw this.newUnsupportedException(value.getClass().getName(), TYPE_NAME);
    }

    @Override
    public ClickHouseFloatArrayValue update(Object value) {
        if (value instanceof float[]) {
            this.set((float[])value);
        } else {
            super.update(value);
        }
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Arrays.equals((float[])this.getValue(), (float[])((ClickHouseFloatArrayValue)obj).getValue());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode((float[])this.getValue());
    }
}

