/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class ClickHouseResponseSummary
implements Serializable {
    private static final long serialVersionUID = 6241261266635143197L;
    static final String ERROR_CANNOT_UPDATE = "Sealed summary cannot be updated";
    public static final ClickHouseResponseSummary EMPTY = new ClickHouseResponseSummary(null, null, true);
    private final AtomicReference<Progress> progress;
    private final AtomicReference<Statistics> stats;
    private final AtomicInteger updates;
    private volatile boolean sealed;

    public ClickHouseResponseSummary(Progress progress, Statistics stats) {
        this(progress, stats, false);
    }

    protected ClickHouseResponseSummary(Progress progress, Statistics stats, boolean sealed) {
        if (progress == null) {
            progress = Progress.EMPTY;
        }
        if (stats == null) {
            stats = Statistics.EMPTY;
        }
        this.progress = new AtomicReference<Progress>(progress);
        this.stats = new AtomicReference<Statistics>(stats);
        this.updates = new AtomicInteger(progress.isEmpty() && stats.isEmpty() ? 0 : 1);
        this.sealed = sealed;
    }

    public void seal() {
        this.sealed = true;
    }

    public int update() {
        if (this.sealed) {
            throw new IllegalStateException(ERROR_CANNOT_UPDATE);
        }
        return this.updates.incrementAndGet();
    }

    public void update(Progress progress) {
        if (this.sealed) {
            throw new IllegalStateException(ERROR_CANNOT_UPDATE);
        }
        if (progress != null) {
            this.progress.set(progress);
        }
    }

    public void add(Progress progress) {
        if (this.sealed) {
            throw new IllegalStateException(ERROR_CANNOT_UPDATE);
        }
        Progress current = this.progress.get();
        this.progress.set(current.add(progress));
        this.updates.incrementAndGet();
    }

    public void update(Statistics stats) {
        if (this.sealed) {
            throw new IllegalStateException(ERROR_CANNOT_UPDATE);
        }
        if (stats != null) {
            this.stats.set(stats);
        }
    }

    public void add(Statistics stats) {
        if (this.sealed) {
            throw new IllegalStateException(ERROR_CANNOT_UPDATE);
        }
        Statistics current = this.stats.get();
        this.stats.set(current.add(stats));
    }

    public void add(ClickHouseResponseSummary summary) {
        if (summary == null) {
            return;
        }
        this.add(summary.getProgress());
        this.add(summary.getStatistics());
    }

    public Progress getProgress() {
        return this.progress.get();
    }

    public Statistics getStatistics() {
        return this.stats.get();
    }

    public long getReadRows() {
        return this.progress.get().getReadRows();
    }

    public long getReadBytes() {
        return this.progress.get().getReadBytes();
    }

    public long getTotalRowsToRead() {
        return this.progress.get().getTotalRowsToRead();
    }

    public long getWrittenRows() {
        return this.progress.get().getWrittenRows();
    }

    public long getWrittenBytes() {
        return this.progress.get().getWrittenBytes();
    }

    public int getUpdateCount() {
        return this.updates.get();
    }

    public long getElapsedTime() {
        return this.progress.get().getElapsedTime();
    }

    public long getResultRows() {
        return this.progress.get().getResultRows();
    }

    public String getQueryId() {
        return this.progress.get().getQueryId();
    }

    public boolean isEmpty() {
        return this.progress.get().isEmpty() && this.stats.get().isEmpty();
    }

    public String toString() {
        return "ClickHouseResponseSummary [readBytes=" + this.getReadBytes() + ", readRows=" + this.getReadRows() + ", totalRowsToRead=" + this.getTotalRowsToRead() + ", writtenBytes=" + this.getWrittenBytes() + ", writtenRows=" + this.getWrittenRows() + ", updates=" + this.getUpdateCount() + ']';
    }

    public static final class Progress
    implements Serializable {
        private static final long serialVersionUID = -1447066780591278108L;
        static final Progress EMPTY = new Progress(0L, 0L, 0L, 0L, 0L, 0L, 0L, "");
        private final long read_rows;
        private final long read_bytes;
        private final long total_rows_to_read;
        private final long written_rows;
        private final long written_bytes;
        private final long elapsed_time;
        private final long result_rows;
        private final String query_id;

        public Progress(long read_rows, long read_bytes, long total_rows_to_read, long written_rows, long written_bytes, long elapsed_time, long result_rows) {
            this(read_rows, read_bytes, total_rows_to_read, written_rows, written_bytes, elapsed_time, result_rows, "");
        }

        public Progress(long read_rows, long read_bytes, long total_rows_to_read, long written_rows, long written_bytes, long elapsed_time, long result_rows, String query_id) {
            this.read_rows = read_rows;
            this.read_bytes = read_bytes;
            this.total_rows_to_read = total_rows_to_read;
            this.written_rows = written_rows;
            this.written_bytes = written_bytes;
            this.elapsed_time = elapsed_time;
            this.result_rows = result_rows;
            this.query_id = query_id;
        }

        public long getReadRows() {
            return this.read_rows;
        }

        public long getReadBytes() {
            return this.read_bytes;
        }

        public long getTotalRowsToRead() {
            return this.total_rows_to_read;
        }

        public long getWrittenRows() {
            return this.written_rows;
        }

        public long getWrittenBytes() {
            return this.written_bytes;
        }

        public long getElapsedTime() {
            return this.elapsed_time;
        }

        public long getResultRows() {
            return this.result_rows;
        }

        public String getQueryId() {
            return this.query_id;
        }

        public Progress add(Progress progress) {
            if (progress == null) {
                return this;
            }
            return new Progress(this.read_rows + progress.read_rows, this.read_bytes + progress.read_bytes, this.total_rows_to_read + progress.total_rows_to_read, this.written_rows + progress.written_rows, this.written_bytes + progress.written_bytes, this.elapsed_time + progress.elapsed_time, this.result_rows + progress.result_rows, this.query_id + ", " + progress.query_id);
        }

        public boolean isEmpty() {
            return this.read_rows == 0L && this.read_bytes == 0L && this.total_rows_to_read == 0L && this.written_rows == 0L && this.written_bytes == 0L;
        }
    }

    public static class Statistics
    implements Serializable {
        private static final long serialVersionUID = -7744796632866829161L;
        static final Statistics EMPTY = new Statistics(0L, 0L, 0L, false, 0L);
        private final long rows;
        private final long blocks;
        private final long allocated_bytes;
        private final boolean applied_limit;
        private final long rows_before_limit;

        public Statistics(long rows, long blocks, long allocated_bytes, boolean applied_limit, long rows_before_limit) {
            this.rows = rows;
            this.blocks = blocks;
            this.allocated_bytes = allocated_bytes;
            this.applied_limit = applied_limit;
            this.rows_before_limit = rows_before_limit;
        }

        public long getRows() {
            return this.rows;
        }

        public long getBlocks() {
            return this.blocks;
        }

        public long getAllocatedBytes() {
            return this.allocated_bytes;
        }

        public boolean hasAppliedLimit() {
            return this.applied_limit;
        }

        public long getRowsBeforeLimit() {
            return this.rows_before_limit;
        }

        public Statistics add(Statistics stats) {
            if (stats == null) {
                return this;
            }
            return new Statistics(this.rows + stats.rows, this.blocks + stats.blocks, this.allocated_bytes + stats.allocated_bytes, this.applied_limit || stats.applied_limit, this.rows_before_limit + stats.rows_before_limit);
        }

        public boolean isEmpty() {
            return this.rows == 0L && this.blocks == 0L && this.allocated_bytes == 0L && !this.applied_limit && this.rows_before_limit == 0L;
        }
    }
}

