/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseClientBuilder;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseNodes;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseProtocol;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseTransaction;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.http.config.ClickHouseHttpOption;
import com.clickhouse.config.ClickHouseDefaultOption;
import com.clickhouse.config.ClickHouseOption;
import com.clickhouse.config.ClickHouseRenameMethod;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.data.ClickHouseRecord;
import com.clickhouse.data.ClickHouseUtils;
import com.clickhouse.data.ClickHouseValues;
import com.clickhouse.data.ClickHouseVersion;
import com.clickhouse.jdbc.ClickHouseConnection;
import com.clickhouse.jdbc.ClickHouseDatabaseMetaData;
import com.clickhouse.jdbc.ClickHouseStatement;
import com.clickhouse.jdbc.DriverV1;
import com.clickhouse.jdbc.JdbcConfig;
import com.clickhouse.jdbc.JdbcParameterizedQuery;
import com.clickhouse.jdbc.JdbcParseHandler;
import com.clickhouse.jdbc.JdbcWrapper;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.AbstractPreparedStatement;
import com.clickhouse.jdbc.internal.ClickHouseJdbcUrlParser;
import com.clickhouse.jdbc.internal.ClickHouseStatementImpl;
import com.clickhouse.jdbc.internal.InputBasedPreparedStatement;
import com.clickhouse.jdbc.internal.JdbcSavepoint;
import com.clickhouse.jdbc.internal.JdbcTransaction;
import com.clickhouse.jdbc.internal.SqlBasedPreparedStatement;
import com.clickhouse.jdbc.internal.StreamBasedPreparedStatement;
import com.clickhouse.jdbc.internal.TableBasedPreparedStatement;
import com.clickhouse.jdbc.parser.ClickHouseSqlParser;
import com.clickhouse.jdbc.parser.ClickHouseSqlStatement;
import com.clickhouse.jdbc.parser.StatementType;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.Serializable;
import java.net.URI;
import java.sql.ClientInfoStatus;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@Deprecated
public class ClickHouseConnectionImpl
extends JdbcWrapper
implements ClickHouseConnection {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseConnectionImpl.class);
    static final String SETTING_READONLY = "readonly";
    static final String SETTING_MAX_INSERT_BLOCK = "max_insert_block_size";
    static final String SETTING_LW_DELETE = "allow_experimental_lightweight_delete";
    static final ClickHouseDefaultOption CUSTOM_CONFIG = new ClickHouseDefaultOption("custom_jdbc_config", (Serializable)((Object)"custom_jdbc_config"));
    private static final String SQL_GET_SERVER_INFO = "select currentUser() user, timezone() timezone, version() version, " + ClickHouseConnectionImpl.getSetting("readonly", ClickHouseDataType.UInt8) + ", " + ClickHouseConnectionImpl.getSetting("throw_on_unsupported_query_inside_transaction", ClickHouseDataType.Int8) + ", " + ClickHouseConnectionImpl.getSetting("wait_changes_become_visible_after_commit_mode", ClickHouseDataType.String) + "," + ClickHouseConnectionImpl.getSetting("implicit_transaction", ClickHouseDataType.Int8) + ", " + ClickHouseConnectionImpl.getSetting("max_insert_block_size", ClickHouseDataType.UInt64) + ", " + ClickHouseConnectionImpl.getSetting("allow_experimental_lightweight_delete", ClickHouseDataType.Int8) + ", " + ClickHouseConnectionImpl.getSetting((String)((Object)CUSTOM_CONFIG.getEffectiveDefaultValue()), ClickHouseDataType.String) + " FORMAT RowBinaryWithNamesAndTypes";
    private final JdbcConfig jdbcConf;
    private final ClickHouseClient client;
    private final ClickHouseRequest<?> clientRequest;
    private boolean autoCommit;
    private boolean closed;
    private String database;
    private boolean readOnly;
    private int networkTimeout;
    private int rsHoldability;
    private int txIsolation;
    private final Optional<TimeZone> clientTimeZone;
    private final Calendar defaultCalendar;
    private final TimeZone jvmTimeZone;
    private final TimeZone serverTimeZone;
    private final ClickHouseVersion serverVersion;
    private final String user;
    private final int initialReadOnly;
    private final int initialNonTxQuerySupport;
    private final String initialTxCommitWaitMode;
    private final int initialImplicitTx;
    private final long initialMaxInsertBlockSize;
    private final int initialDeleteSupport;
    private final Map<String, Class<?>> typeMap;
    private final AtomicReference<JdbcTransaction> txRef;

    private static String getSetting(String setting, ClickHouseDataType type) {
        return ClickHouseConnectionImpl.getSetting(setting, type, null);
    }

    private static String getSetting(String setting, ClickHouseDataType type, String defaultValue) {
        StringBuilder builder = new StringBuilder();
        if (type == ClickHouseDataType.String) {
            builder.append("(ifnull((select value from system.settings where name = '").append(setting).append("'), ");
        } else {
            builder.append("to").append(type.name()).append("(ifnull((select value from system.settings where name = '").append(setting).append("'), ");
        }
        if (ClickHouseChecker.isNullOrEmpty((CharSequence)defaultValue)) {
            builder.append(type.getMaxPrecision() > 0 ? (type.isSigned() ? "'-1'" : "'0'") : "''");
        } else {
            builder.append('\'').append(defaultValue).append('\'');
        }
        return builder.append(")) as ").append(setting).toString();
    }

    protected static ClickHouseRecord getServerInfo(ClickHouseNode node, ClickHouseRequest<?> request, boolean createDbIfNotExist) throws SQLException {
        ClickHouseRecord clickHouseRecord;
        block19: {
            ClickHouseRequest newReq = request.copy().option((ClickHouseOption)ClickHouseClientOption.RENAME_RESPONSE_COLUMN, (Serializable)ClickHouseRenameMethod.NONE);
            if (!createDbIfNotExist) {
                newReq.option((ClickHouseOption)ClickHouseClientOption.DATABASE, (Serializable)((Object)""));
            }
            ClickHouseResponse response = newReq.option((ClickHouseOption)ClickHouseClientOption.ASYNC, (Serializable)Boolean.valueOf(false)).option((ClickHouseOption)ClickHouseClientOption.COMPRESS, (Serializable)Boolean.valueOf(false)).option((ClickHouseOption)ClickHouseClientOption.DECOMPRESS, (Serializable)Boolean.valueOf(false)).option((ClickHouseOption)ClickHouseClientOption.FORMAT, (Serializable)ClickHouseFormat.RowBinaryWithNamesAndTypes).query(SQL_GET_SERVER_INFO).executeAndWait();
            try {
                clickHouseRecord = response.firstRecord();
                if (response == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SQLException sqlExp = SqlExceptionUtils.handle(e, new Throwable[0]);
                    if (createDbIfNotExist && sqlExp.getErrorCode() == 81) {
                        ClickHouseRecord clickHouseRecord2;
                        block20: {
                            String db = node.getDatabase(request.getConfig());
                            ClickHouseResponse resp = newReq.use("").query("CREATE DATABASE IF NOT EXISTS `" + ClickHouseUtils.escape((String)db, (char)'`') + '`').executeAndWait();
                            try {
                                clickHouseRecord2 = ClickHouseConnectionImpl.getServerInfo(node, request, false);
                                if (resp == null) break block20;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    if (resp != null) {
                                        try {
                                            resp.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable3.addSuppressed(throwable4);
                                        }
                                    }
                                    throw throwable3;
                                }
                                catch (SQLException ex) {
                                    throw ex;
                                }
                                catch (Exception ex) {
                                    throw SqlExceptionUtils.handle(ex, new Throwable[0]);
                                }
                            }
                            resp.close();
                        }
                        return clickHouseRecord2;
                    }
                    throw sqlExp;
                }
            }
            response.close();
        }
        return clickHouseRecord;
    }

    protected JdbcTransaction createTransaction() throws SQLException {
        if (!this.isTransactionSupported()) {
            return new JdbcTransaction(null);
        }
        try {
            ClickHouseTransaction tx = this.clientRequest.getManager().createTransaction(this.clientRequest);
            tx.begin();
            this.clientRequest.transaction(tx);
            return new JdbcTransaction(tx);
        }
        catch (ClickHouseException e) {
            throw SqlExceptionUtils.handle(e);
        }
    }

    protected JdbcSavepoint createSavepoint() {
        return new JdbcSavepoint(1, "name");
    }

    protected void ensureOpen() throws SQLException {
        if (this.closed) {
            throw SqlExceptionUtils.clientError("Cannot operate on a closed connection");
        }
    }

    protected void ensureSupport(String feature, boolean silent) throws SQLException {
        String msg = feature + " is not supported";
        if (this.jdbcConf.isJdbcCompliant()) {
            if (silent) {
                log.debug((Object)"[JDBC Compliant Mode] %s. You may change %s to false to throw SQLException instead.", new Object[]{msg, "jdbcCompliant"});
            } else {
                log.warn((Object)"[JDBC Compliant Mode] %s. You may change %s to false to throw SQLException instead.", new Object[]{msg, "jdbcCompliant"});
            }
        } else if (!silent) {
            throw SqlExceptionUtils.unsupportedError(msg);
        }
    }

    protected void ensureTransactionSupport() throws SQLException {
        if (!this.isTransactionSupported()) {
            this.ensureSupport("Transaction", false);
        }
    }

    protected List<ClickHouseColumn> getTableColumns(String dbName, String tableName, String columns) throws SQLException {
        List list;
        if (tableName == null || columns == null) {
            throw SqlExceptionUtils.clientError("Failed to extract table and columns from the query");
        }
        columns = columns.isEmpty() ? "*" : columns.substring(1);
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ").append(columns).append(" FROM ");
        if (!ClickHouseChecker.isNullOrEmpty((CharSequence)dbName)) {
            builder.append('`').append(ClickHouseUtils.escape((String)dbName, (char)'`')).append('`').append('.');
        }
        builder.append('`').append(ClickHouseUtils.escape((String)tableName, (char)'`')).append('`').append(" WHERE 0");
        try (ClickHouseResponse resp = this.clientRequest.copy().format(ClickHouseFormat.RowBinaryWithNamesAndTypes).option((ClickHouseOption)ClickHouseClientOption.RENAME_RESPONSE_COLUMN, (Serializable)ClickHouseRenameMethod.NONE).query(builder.toString()).executeAndWait();){
            list = resp.getColumns();
        }
        catch (Exception e) {
            throw SqlExceptionUtils.handle(e, new Throwable[0]);
        }
        return list;
    }

    protected String getDatabase() throws SQLException {
        this.ensureOpen();
        return this.getCurrentDatabase();
    }

    final JdbcTransaction getJdbcTrasaction() {
        return this.txRef.get();
    }

    public ClickHouseConnectionImpl(String url) throws SQLException {
        this(url, new Properties());
    }

    public ClickHouseConnectionImpl(String url, Properties properties) throws SQLException {
        this(ClickHouseJdbcUrlParser.parse(url, properties));
    }

    public ClickHouseConnectionImpl(ClickHouseJdbcUrlParser.ConnectionInfo connInfo) throws SQLException {
        ClickHouseRequest initialRequest;
        ClickHouseClient initialClient;
        ClickHouseNode node;
        Properties props = connInfo.getProperties();
        this.jvmTimeZone = TimeZone.getDefault();
        if (!(props.get("disable_frameworks_detection") != null && props.get("disable_frameworks_detection").toString().equalsIgnoreCase("true") || (DriverV1.frameworksDetected = DriverV1.FrameworksDetection.getFrameworksDetected()) == null)) {
            props.setProperty(ClickHouseClientOption.PRODUCT_NAME.getKey(), props.getProperty(ClickHouseClientOption.PRODUCT_NAME.getKey()) + DriverV1.frameworksDetected);
        }
        ClickHouseClientBuilder clientBuilder = ClickHouseClient.builder().options(DriverV1.toClientOptions(props)).defaultCredentials(connInfo.getDefaultCredentials());
        ClickHouseNodes nodes = connInfo.getNodes();
        if (nodes.isSingleNode()) {
            try {
                node = nodes.apply(nodes.getNodeSelector());
            }
            catch (Exception e) {
                throw SqlExceptionUtils.clientError("Failed to get single-node", e);
            }
            initialClient = clientBuilder.nodeSelector(ClickHouseNodeSelector.of((ClickHouseProtocol)node.getProtocol(), (ClickHouseProtocol[])new ClickHouseProtocol[0])).build();
            initialRequest = initialClient.read(node);
        } else {
            log.debug((Object)"Selecting node from: %s", new Object[]{nodes});
            initialClient = clientBuilder.build();
            initialRequest = initialClient.read(nodes);
            try {
                node = initialRequest.getServer();
            }
            catch (Exception e) {
                throw SqlExceptionUtils.clientError("No healthy node available", e);
            }
        }
        log.debug((Object)"Connecting to: %s", new Object[]{node});
        ClickHouseConfig config = initialRequest.getConfig();
        String currentUser = null;
        TimeZone timeZone = null;
        ClickHouseVersion version = null;
        ClickHouseRecord r = null;
        if (config.hasServerInfo()) {
            timeZone = config.getServerTimeZone();
            version = config.getServerVersion();
            if (connInfo.getJdbcConfig().isCreateDbIfNotExist()) {
                r = ClickHouseConnectionImpl.getServerInfo(node, initialRequest, true);
            }
        } else {
            r = ClickHouseConnectionImpl.getServerInfo(node, initialRequest, connInfo.getJdbcConfig().isCreateDbIfNotExist());
            currentUser = r.getValue(0).asString();
            String tz = r.getValue(1).asString();
            String ver = r.getValue(2).asString();
            version = ClickHouseVersion.of((String)ver);
            if (version.check("(,20.7)")) {
                throw SqlExceptionUtils.unsupportedError("We apologize, but this driver only works with ClickHouse servers 20.7 and above. Please consider to upgrade your server to a more recent version.");
            }
            if (ClickHouseChecker.isNullOrBlank((CharSequence)tz)) {
                tz = "UTC";
            }
            timeZone = "UTC".equals(tz) ? ClickHouseValues.UTC_TIMEZONE : TimeZone.getTimeZone(tz);
            initialRequest.option((ClickHouseOption)ClickHouseClientOption.SERVER_TIME_ZONE, (Serializable)((Object)tz)).option((ClickHouseOption)ClickHouseClientOption.SERVER_VERSION, (Serializable)((Object)ver));
        }
        boolean useLightWeightDelete = version.check("[23.3,)");
        if (r != null) {
            this.initialReadOnly = r.getValue(3).asInteger();
            this.initialNonTxQuerySupport = r.getValue(4).asInteger();
            this.initialTxCommitWaitMode = r.getValue(5).asString().toLowerCase(Locale.ROOT);
            this.initialImplicitTx = r.getValue(6).asInteger();
            this.initialMaxInsertBlockSize = r.getValue(7).asLong();
            this.initialDeleteSupport = useLightWeightDelete ? 2 : r.getValue(8).asInteger();
            String customConf = ClickHouseUtils.unescape((String)r.getValue(9).asString());
            if (ClickHouseChecker.isNullOrBlank((CharSequence)customConf)) {
                this.jdbcConf = connInfo.getJdbcConfig();
                this.client = initialClient;
                this.clientRequest = initialRequest;
            } else {
                initialClient.close();
                Properties newProps = ClickHouseJdbcUrlParser.newProperties();
                Map options = ClickHouseUtils.extractParameters((String)customConf, null);
                boolean resetAll = Boolean.parseBoolean((String)options.get("*"));
                if (resetAll) {
                    clientBuilder.clearOptions();
                } else {
                    newProps.putAll((Map<?, ?>)connInfo.getJdbcConfig().getProperties());
                    newProps.putAll((Map<?, ?>)props);
                }
                newProps.putAll((Map<?, ?>)options);
                this.jdbcConf = new JdbcConfig(newProps);
                Map clientOpts = ClickHouseConfig.toClientOptions((Map)newProps);
                clientBuilder.options(clientOpts);
                this.client = clientBuilder.build();
                this.clientRequest = this.client.read(node);
                if (resetAll && !initialRequest.getSettings().isEmpty()) {
                    this.clientRequest.clearSettings();
                }
                this.clientRequest.option((ClickHouseOption)ClickHouseClientOption.SERVER_TIME_ZONE, (Serializable)((Object)timeZone.getID())).option((ClickHouseOption)ClickHouseClientOption.SERVER_VERSION, (Serializable)((Object)version.toString()));
                for (Map.Entry o : clientOpts.entrySet()) {
                    this.clientRequest.option((ClickHouseOption)o.getKey(), (Serializable)o.getValue());
                }
                if (resetAll) {
                    this.clientRequest.freezeOptions().freezeSettings();
                }
                config = this.clientRequest.getConfig();
            }
        } else {
            this.jdbcConf = connInfo.getJdbcConfig();
            this.initialReadOnly = (Integer)initialRequest.getSetting(SETTING_READONLY, (Serializable)Integer.valueOf(0));
            this.initialNonTxQuerySupport = (Integer)initialRequest.getSetting("throw_on_unsupported_query_inside_transaction", (Serializable)Integer.valueOf(1));
            this.initialTxCommitWaitMode = (String)((Object)initialRequest.getSetting("wait_changes_become_visible_after_commit_mode", (Serializable)((Object)"wait_unknown")));
            this.initialImplicitTx = (Integer)initialRequest.getSetting("implicit_transaction", (Serializable)Integer.valueOf(0));
            this.initialMaxInsertBlockSize = (Long)initialRequest.getSetting(SETTING_MAX_INSERT_BLOCK, (Serializable)Long.valueOf(0L));
            this.initialDeleteSupport = (Integer)initialRequest.getSetting(SETTING_LW_DELETE, (Serializable)Integer.valueOf(useLightWeightDelete ? 2 : 0));
            this.client = initialClient;
            this.clientRequest = initialRequest;
        }
        this.autoCommit = !this.jdbcConf.isJdbcCompliant() || this.jdbcConf.isAutoCommit();
        this.closed = false;
        this.database = config.getDatabase();
        this.clientRequest.use(this.database);
        this.readOnly = (Integer)this.clientRequest.getSetting(SETTING_READONLY, (Serializable)Integer.valueOf(this.initialReadOnly)) != 0;
        this.networkTimeout = 0;
        this.rsHoldability = 1;
        if (this.isTransactionSupported()) {
            this.txIsolation = 4;
            if (this.jdbcConf.isJdbcCompliant() && !this.readOnly && !this.clientRequest.hasSetting("throw_on_unsupported_query_inside_transaction")) {
                this.clientRequest.set("throw_on_unsupported_query_inside_transaction", (Serializable)Integer.valueOf(0));
            }
        } else {
            this.txIsolation = this.jdbcConf.isJdbcCompliant() ? 2 : 0;
        }
        this.user = currentUser != null ? currentUser : node.getCredentials(config).getUserName();
        this.serverTimeZone = timeZone;
        if (config.isUseServerTimeZone()) {
            this.clientTimeZone = Optional.empty();
            this.defaultCalendar = new GregorianCalendar();
        } else {
            this.clientTimeZone = Optional.of(config.getUseTimeZone());
            this.defaultCalendar = new GregorianCalendar(this.clientTimeZone.get());
        }
        this.serverVersion = version;
        this.typeMap = new HashMap(this.jdbcConf.getTypeMap());
        this.txRef = new AtomicReference<JdbcTransaction>(this.autoCommit ? null : this.createTransaction());
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureOpen();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureOpen();
        if (this.autoCommit == autoCommit) {
            return;
        }
        this.ensureTransactionSupport();
        this.autoCommit = autoCommit;
        if (this.autoCommit) {
            JdbcTransaction tx = this.txRef.getAndSet(null);
            if (tx != null) {
                tx.commit(log);
            }
        } else if (!this.txRef.compareAndSet(null, this.createTransaction())) {
            log.warn((Object)"Not able to start a new transaction, reuse the exist one: %s", new Object[]{this.txRef.get()});
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureOpen();
        return this.autoCommit;
    }

    @Override
    public void begin() throws SQLException {
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot start new transaction in auto-commit mode");
        }
        this.ensureTransactionSupport();
        JdbcTransaction tx = this.txRef.get();
        if (tx == null || !tx.isNew()) {
            throw new SQLException("Transaction has been started", "25000");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit() throws SQLException {
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot commit in auto-commit mode");
        }
        this.ensureTransactionSupport();
        JdbcTransaction tx = this.txRef.get();
        if (tx == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        try {
            tx.commit(log);
            if (this.txRef.compareAndSet(tx, this.createTransaction())) return;
        }
        catch (Throwable throwable) {
            if (this.txRef.compareAndSet(tx, this.createTransaction())) throw throwable;
            log.warn((Object)"Transaction was set to %s unexpectedly", new Object[]{this.txRef.get()});
            throw throwable;
        }
        log.warn((Object)"Transaction was set to %s unexpectedly", new Object[]{this.txRef.get()});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rollback() throws SQLException {
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot rollback in auto-commit mode");
        }
        this.ensureTransactionSupport();
        JdbcTransaction tx = this.txRef.get();
        if (tx == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        try {
            tx.rollback(log);
            if (this.txRef.compareAndSet(tx, this.createTransaction())) return;
        }
        catch (Throwable throwable) {
            if (this.txRef.compareAndSet(tx, this.createTransaction())) throw throwable;
            log.warn((Object)"Transaction was set to %s unexpectedly", new Object[]{this.txRef.get()});
            throw throwable;
        }
        log.warn((Object)"Transaction was set to %s unexpectedly", new Object[]{this.txRef.get()});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws SQLException {
        try {
            this.client.close();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to close connection due to %s", new Object[]{e.getMessage()});
            throw SqlExceptionUtils.handle(e, new Throwable[0]);
        }
        finally {
            this.closed = true;
        }
        JdbcTransaction tx = this.txRef.get();
        if (tx == null) return;
        try {
            tx.commit(log);
            if (this.txRef.compareAndSet(tx, null)) return;
        }
        catch (Throwable throwable) {
            if (this.txRef.compareAndSet(tx, null)) throw throwable;
            log.warn((Object)"Transaction was set to %s unexpectedly", new Object[]{this.txRef.get()});
            throw throwable;
        }
        log.warn((Object)"Transaction was set to %s unexpectedly", new Object[]{this.txRef.get()});
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new ClickHouseDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureOpen();
        if (this.initialReadOnly != 0) {
            if (!readOnly) {
                throw SqlExceptionUtils.clientError("Cannot change the setting on a read-only connection");
            }
        } else {
            if (readOnly) {
                this.clientRequest.set(SETTING_READONLY, (Serializable)Integer.valueOf(2));
            } else {
                this.clientRequest.removeSetting(SETTING_READONLY);
            }
            this.readOnly = readOnly;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureOpen();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.jdbcConf.useCatalog()) {
            this.setCurrentDatabase(catalog, true);
        } else {
            log.warn((Object)"setCatalog method is no-op. Please either change databaseTerm to catalog or use setSchema method instead", new Object[0]);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.jdbcConf.useCatalog() ? this.getDatabase() : null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureOpen();
        if (0 != level && 1 != level && 2 != level && 4 != level && 8 != level) {
            throw new SQLException("Invalid transaction isolation level: " + level);
        }
        this.txIsolation = this.isTransactionSupported() ? 4 : (this.jdbcConf.isJdbcCompliant() ? level : 0);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureOpen();
        return this.txIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.ensureOpen();
        return new HashMap(this.typeMap);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureOpen();
        if (map != null) {
            this.typeMap.putAll(map);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureOpen();
        if (holdability != 2 && holdability != 1) {
            throw new SQLException("Invalid holdability: " + holdability);
        }
        this.rsHoldability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureOpen();
        return this.rsHoldability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot set savepoint in auto-commit mode");
        }
        if (!this.jdbcConf.isJdbcCompliant()) {
            throw SqlExceptionUtils.unsupportedError("setSavepoint not implemented");
        }
        JdbcTransaction tx = this.txRef.get();
        if (tx == null && !this.txRef.compareAndSet(null, tx = this.createTransaction())) {
            tx = this.txRef.get();
        }
        return tx.newSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot rollback to savepoint in auto-commit mode");
        }
        if (!this.jdbcConf.isJdbcCompliant()) {
            throw SqlExceptionUtils.unsupportedError("rollback not implemented");
        }
        if (!(savepoint instanceof JdbcSavepoint)) {
            throw SqlExceptionUtils.clientError("Unsupported type of savepoint: " + savepoint);
        }
        JdbcTransaction tx = this.txRef.get();
        if (tx == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        JdbcSavepoint s = (JdbcSavepoint)savepoint;
        tx.logSavepointDetails(log, s, "rolled back");
        tx.toSavepoint(s);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureOpen();
        if (this.getAutoCommit()) {
            throw SqlExceptionUtils.clientError("Cannot release savepoint in auto-commit mode");
        }
        if (!this.jdbcConf.isJdbcCompliant()) {
            throw SqlExceptionUtils.unsupportedError("rollback not implemented");
        }
        if (!(savepoint instanceof JdbcSavepoint)) {
            throw SqlExceptionUtils.clientError("Unsupported type of savepoint: " + savepoint);
        }
        JdbcTransaction tx = this.txRef.get();
        if (tx == null) {
            throw new SQLException("Transaction not started", "25000");
        }
        JdbcSavepoint s = (JdbcSavepoint)savepoint;
        tx.logSavepointDetails(log, s, "released");
        tx.toSavepoint(s);
    }

    @Override
    public ClickHouseStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpen();
        return new ClickHouseStatementImpl(this, this.clientRequest.copy(), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        JdbcParameterizedQuery preparedQuery;
        this.ensureOpen();
        ClickHouseConfig config = this.clientRequest.getConfig();
        ClickHouseSqlStatement[] stmts = this.parse(sql, config, this.clientRequest.getSettings());
        if (stmts.length != 1) {
            throw SqlExceptionUtils.clientError("Prepared statement only supports one query but we got: " + stmts.length);
        }
        ClickHouseSqlStatement parsedStmt = stmts[0];
        try {
            preparedQuery = this.jdbcConf.useNamedParameter() ? ClickHouseParameterizedQuery.of((ClickHouseConfig)this.clientRequest.getConfig(), (String)parsedStmt.getSQL()) : JdbcParameterizedQuery.of(config, parsedStmt.getSQL());
        }
        catch (RuntimeException e) {
            throw SqlExceptionUtils.clientError(e);
        }
        AbstractPreparedStatement ps = null;
        if (preparedQuery.hasParameter()) {
            if (parsedStmt.hasTempTable() || parsedStmt.hasInput()) {
                throw SqlExceptionUtils.clientError("External table, input function, and query parameter cannot be used together in PreparedStatement.");
            }
            if (parsedStmt.getStatementType() == StatementType.INSERT && !parsedStmt.containsKeyword("SELECT") && parsedStmt.hasValues() && (!parsedStmt.hasFormat() || this.clientRequest.getFormat().name().equals(parsedStmt.getFormat()))) {
                String query = parsedStmt.getSQL();
                boolean useStream = false;
                Integer startIndex = parsedStmt.getPositions().get("ValuesStart");
                if (startIndex != null) {
                    useStream = true;
                    int endIndex = parsedStmt.getPositions().get("ValuesEnd");
                    for (int i = startIndex + 1; i < endIndex; ++i) {
                        char ch = query.charAt(i);
                        if (ch == '?' || ch == ',' || Character.isWhitespace(ch)) continue;
                        useStream = false;
                        break;
                    }
                }
                if (useStream) {
                    ps = new InputBasedPreparedStatement(this, this.clientRequest.write().query(query.substring(0, parsedStmt.getStartPosition("VALUES")), this.newQueryId()), this.getTableColumns(parsedStmt.getDatabase(), parsedStmt.getTable(), parsedStmt.getContentBetweenKeywords("ColumnsStart", "ColumnsEnd")), resultSetType, resultSetConcurrency, resultSetHoldability);
                }
            }
        } else if (parsedStmt.hasTempTable()) {
            ps = new TableBasedPreparedStatement(this, this.clientRequest.copy().query(parsedStmt.getSQL(), this.newQueryId()), parsedStmt, resultSetType, resultSetConcurrency, resultSetHoldability);
        } else if (parsedStmt.getStatementType() == StatementType.INSERT) {
            if (!ClickHouseChecker.isNullOrBlank((CharSequence)parsedStmt.getInput())) {
                ClickHouseRequest.Mutation m = this.clientRequest.write();
                if (parsedStmt.hasFormat()) {
                    m.format(ClickHouseFormat.valueOf((String)parsedStmt.getFormat()));
                }
                ps = new InputBasedPreparedStatement(this, m.query(parsedStmt.getSQL(), this.newQueryId()), ClickHouseColumn.parse((String)parsedStmt.getInput()), resultSetType, resultSetConcurrency, resultSetHoldability);
            } else if (!parsedStmt.containsKeyword("SELECT") && !parsedStmt.hasValues()) {
                ps = parsedStmt.hasFormat() ? new StreamBasedPreparedStatement(this, this.clientRequest.write().query(parsedStmt.getSQL(), this.newQueryId()), parsedStmt, resultSetType, resultSetConcurrency, resultSetHoldability) : new InputBasedPreparedStatement(this, this.clientRequest.write().query(parsedStmt.getSQL(), this.newQueryId()), this.getTableColumns(parsedStmt.getDatabase(), parsedStmt.getTable(), parsedStmt.getContentBetweenKeywords("ColumnsStart", "ColumnsEnd")), resultSetType, resultSetConcurrency, resultSetHoldability);
            }
        }
        return ps != null ? ps : new SqlBasedPreparedStatement(this, this.clientRequest.copy().query((ClickHouseParameterizedQuery)preparedQuery, this.newQueryId()), stmts[0], resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureOpen();
        return this.createClob();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw SqlExceptionUtils.clientError("Negative milliseconds is not allowed");
        }
        timeout = timeout == 0 ? this.clientRequest.getConfig().getConnectionTimeout() : (int)TimeUnit.SECONDS.toMillis(timeout);
        if (this.isClosed()) {
            return false;
        }
        return this.client.ping(this.clientRequest.getServer(), timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.ensureOpen();
        }
        catch (SQLException e) {
            HashMap<String, ClientInfoStatus> failedProps = new HashMap<String, ClientInfoStatus>();
            failedProps.put("ApplicationName", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            failedProps.put("CustomHttpHeaders", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            failedProps.put("CustomHttpParameters", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException(e.getMessage(), failedProps);
        }
        if ("ApplicationName".equals(name)) {
            if (ClickHouseChecker.isNullOrBlank((CharSequence)value)) {
                this.clientRequest.removeOption((ClickHouseOption)ClickHouseClientOption.CLIENT_NAME);
            } else {
                this.clientRequest.option((ClickHouseOption)ClickHouseClientOption.CLIENT_NAME, (Serializable)((Object)value));
            }
        } else if ("CustomHttpHeaders".equals(name)) {
            if (ClickHouseChecker.isNullOrBlank((CharSequence)value)) {
                this.clientRequest.removeOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS);
            } else {
                this.clientRequest.option((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS, (Serializable)((Object)value));
            }
        } else if ("CustomHttpParameters".equals(name)) {
            if (ClickHouseChecker.isNullOrBlank((CharSequence)value)) {
                this.clientRequest.removeOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS);
            } else {
                this.clientRequest.option((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS, (Serializable)((Object)value));
            }
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.ensureOpen();
        }
        catch (SQLException e) {
            HashMap<String, ClientInfoStatus> failedProps = new HashMap<String, ClientInfoStatus>();
            failedProps.put("ApplicationName", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            failedProps.put("CustomHttpHeaders", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            failedProps.put("CustomHttpParameters", ClientInfoStatus.REASON_UNKNOWN_PROPERTY);
            throw new SQLClientInfoException(e.getMessage(), failedProps);
        }
        if (properties != null) {
            String value = properties.getProperty("ApplicationName");
            if (ClickHouseChecker.isNullOrBlank((CharSequence)value)) {
                this.clientRequest.removeOption((ClickHouseOption)ClickHouseClientOption.CLIENT_NAME);
            } else {
                this.clientRequest.option((ClickHouseOption)ClickHouseClientOption.CLIENT_NAME, (Serializable)((Object)value));
            }
            value = properties.getProperty("CustomHttpHeaders");
            if (ClickHouseChecker.isNullOrBlank((CharSequence)value)) {
                this.clientRequest.removeOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS);
            } else {
                this.clientRequest.option((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS, (Serializable)((Object)value));
            }
            value = properties.getProperty("CustomHttpParameters");
            if (ClickHouseChecker.isNullOrBlank((CharSequence)value)) {
                this.clientRequest.removeOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS);
            } else {
                this.clientRequest.option((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS, (Serializable)((Object)value));
            }
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureOpen();
        ClickHouseConfig config = this.clientRequest.getConfig();
        String value = null;
        if ("ApplicationName".equals(name)) {
            value = config.getClientName();
        } else if ("CustomHttpHeaders".equals(name)) {
            value = config.getStrOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS);
        } else if ("CustomHttpParameters".equals(name)) {
            value = config.getStrOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS);
        }
        return value;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureOpen();
        ClickHouseConfig config = this.clientRequest.getConfig();
        Properties props = new Properties();
        props.setProperty("ApplicationName", config.getClientName());
        props.setProperty("CustomHttpHeaders", config.getStrOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_HEADERS));
        props.setProperty("CustomHttpParameters", config.getStrOption((ClickHouseOption)ClickHouseHttpOption.CUSTOM_PARAMS));
        return props;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.jdbcConf.useSchema()) {
            this.setCurrentDatabase(schema, true);
        } else {
            log.warn((Object)"setSchema method is no-op. Please either change databaseTerm to schema or use setCatalog method instead", new Object[0]);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        return this.jdbcConf.useSchema() ? this.getDatabase() : null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw SqlExceptionUtils.clientError("Non-null executor is required");
        }
        executor.execute(() -> {
            try {
                this.client.close();
            }
            finally {
                this.closed = true;
            }
        });
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.ensureOpen();
        if (executor == null) {
            throw SqlExceptionUtils.clientError("Non-null executor is required");
        }
        if (milliseconds < 0) {
            throw SqlExceptionUtils.clientError("Negative milliseconds is not allowed");
        }
        executor.execute(() -> {
            this.networkTimeout = milliseconds;
        });
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.ensureOpen();
        return this.networkTimeout;
    }

    @Override
    public ClickHouseConfig getConfig() {
        return this.clientRequest.getConfig();
    }

    @Override
    public boolean allowCustomSetting() {
        return this.initialReadOnly != 1;
    }

    @Override
    public String getCurrentDatabase() {
        return this.database;
    }

    @Override
    public void setCurrentDatabase(String db, boolean check) throws SQLException {
        block14: {
            this.ensureOpen();
            if (db == null || db.isEmpty()) {
                throw new SQLException("Non-empty database name is required", "3F000");
            }
            this.clientRequest.use(db);
            if (check) {
                try (ClickHouseResponse response = this.clientRequest.query("select 1").executeAndWait();){
                    this.database = db;
                    break block14;
                }
                catch (ClickHouseException e) {
                    throw SqlExceptionUtils.handle(e);
                }
                finally {
                    if (!db.equals(this.database)) {
                        this.clientRequest.use(this.database);
                    }
                }
            }
            this.database = db;
        }
    }

    @Override
    public String getCurrentUser() {
        return this.user;
    }

    @Override
    public Calendar getDefaultCalendar() {
        return this.defaultCalendar;
    }

    @Override
    public Optional<TimeZone> getEffectiveTimeZone() {
        return this.clientTimeZone;
    }

    @Override
    public TimeZone getJvmTimeZone() {
        return this.jvmTimeZone;
    }

    @Override
    public TimeZone getServerTimeZone() {
        return this.serverTimeZone;
    }

    @Override
    public ClickHouseVersion getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public ClickHouseTransaction getTransaction() {
        return this.clientRequest.getTransaction();
    }

    @Override
    public URI getUri() {
        return this.clientRequest.getServer().toUri("jdbc:clickhouse:");
    }

    @Override
    public JdbcConfig getJdbcConfig() {
        return this.jdbcConf;
    }

    @Override
    public long getMaxInsertBlockSize() {
        return this.initialMaxInsertBlockSize;
    }

    @Override
    public boolean isTransactionSupported() {
        return this.jdbcConf.isTransactionSupported() && this.initialNonTxQuerySupport >= 0 && !ClickHouseChecker.isNullOrEmpty((CharSequence)this.initialTxCommitWaitMode);
    }

    @Override
    public boolean isImplicitTransactionSupported() {
        return this.jdbcConf.isTransactionSupported() && this.initialImplicitTx >= 0;
    }

    @Override
    public String newQueryId() {
        String queryId = this.clientRequest.getManager().createQueryId();
        JdbcTransaction tx = this.txRef.get();
        return tx != null ? tx.newQuery(queryId) : queryId;
    }

    @Override
    public ClickHouseSqlStatement[] parse(String sql, ClickHouseConfig config, Map<String, Serializable> settings) {
        JdbcParseHandler handler = null;
        if (this.jdbcConf.isJdbcCompliant()) {
            boolean allowLwDelete = this.initialDeleteSupport > 1;
            boolean allowLwUpdate = false;
            if (settings != null) {
                Serializable value = settings.get(SETTING_LW_DELETE);
                if (!allowLwDelete && (value == null ? this.initialDeleteSupport == 1 : (Boolean)ClickHouseOption.fromString((String)value.toString(), Boolean.class) != false)) {
                    allowLwDelete = true;
                }
            }
            handler = JdbcParseHandler.getInstance(allowLwDelete, allowLwUpdate, this.jdbcConf.useLocalFile());
        } else if (this.jdbcConf.useLocalFile()) {
            handler = JdbcParseHandler.getInstance(false, false, true);
        }
        return ClickHouseSqlParser.parse(sql, config != null ? config : this.clientRequest.getConfig(), handler);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == ClickHouseClient.class || iface == ClickHouseRequest.class || super.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == ClickHouseClient.class) {
            return iface.cast(this.client);
        }
        if (iface == ClickHouseRequest.class) {
            return iface.cast(this.clientRequest);
        }
        return super.unwrap(iface);
    }
}

