/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats.internal;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.data_formats.internal.AbstractBinaryFormatReader;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.data_formats.internal.NumberConverter;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.GenericRecord;
import com.clickhouse.client.api.query.NullValueException;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.value.ClickHouseBitmap;
import com.clickhouse.data.value.ClickHouseGeoMultiPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoPointValue;
import com.clickhouse.data.value.ClickHouseGeoPolygonValue;
import com.clickhouse.data.value.ClickHouseGeoRingValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public class MapBackedRecord
implements GenericRecord {
    private final Map<String, Object> record;
    private final TableSchema schema;
    private Map[] columnConverters;

    public MapBackedRecord(Map<String, Object> record, Map[] columnConverters, TableSchema schema) {
        this.record = new HashMap<String, Object>(record);
        this.schema = schema;
        this.columnConverters = columnConverters;
    }

    public <T> T readValue(int colIndex) {
        if (colIndex < 1 || colIndex > this.schema.getColumns().size()) {
            throw new ClientException("Column index out of bounds: " + colIndex);
        }
        return (T)this.record.get(this.schema.columnIndexToName(colIndex));
    }

    public <T> T readValue(String colName) {
        return (T)this.record.get(colName);
    }

    @Override
    public String getString(String colName) {
        return AbstractBinaryFormatReader.readAsString(this.readValue(colName), this.schema.getColumnByName(colName));
    }

    @Override
    public String getString(int index) {
        return this.getString(this.schema.columnIndexToName(index));
    }

    private <T> T readNumberValue(String colName, NumberConverter.NumberType targetType) {
        int colIndex = this.schema.nameToIndex(colName);
        Function converter = (Function)this.columnConverters[colIndex].get((Object)targetType);
        if (converter != null) {
            T value = this.readValue(colName);
            if (value == null) {
                throw new NullValueException("Column " + colName + " has null value and it cannot be cast to " + targetType.getTypeName());
            }
            return (T)converter.apply(value);
        }
        String columnTypeName = this.schema.getColumnByName(colName).getDataType().name();
        throw new ClientException("Column '" + colName + "' of type " + columnTypeName + " cannot be converted to '" + targetType.getTypeName() + "' value");
    }

    @Override
    public byte getByte(String colName) {
        return (Byte)this.readNumberValue(colName, NumberConverter.NumberType.Byte);
    }

    @Override
    public short getShort(String colName) {
        return (Short)this.readNumberValue(colName, NumberConverter.NumberType.Short);
    }

    @Override
    public int getInteger(String colName) {
        return (Integer)this.readNumberValue(colName, NumberConverter.NumberType.Int);
    }

    @Override
    public long getLong(String colName) {
        return (Long)this.readNumberValue(colName, NumberConverter.NumberType.Long);
    }

    @Override
    public float getFloat(String colName) {
        return ((Float)this.readNumberValue(colName, NumberConverter.NumberType.Float)).floatValue();
    }

    @Override
    public double getDouble(String colName) {
        return (Double)this.readNumberValue(colName, NumberConverter.NumberType.Double);
    }

    @Override
    public boolean getBoolean(String colName) {
        return (Boolean)this.readNumberValue(colName, NumberConverter.NumberType.Boolean);
    }

    @Override
    public BigInteger getBigInteger(String colName) {
        return (BigInteger)this.readNumberValue(colName, NumberConverter.NumberType.BigInteger);
    }

    @Override
    public BigDecimal getBigDecimal(String colName) {
        return (BigDecimal)this.readNumberValue(colName, NumberConverter.NumberType.BigDecimal);
    }

    @Override
    public Instant getInstant(String colName) {
        ClickHouseColumn column = this.schema.getColumnByName(colName);
        switch (column.getDataType()) {
            case Date: 
            case Date32: {
                LocalDate data = (LocalDate)this.readValue(colName);
                return data.atStartOfDay().toInstant(ZoneOffset.UTC);
            }
            case DateTime: 
            case DateTime64: {
                LocalDateTime dateTime = (LocalDateTime)this.readValue(colName);
                return dateTime.toInstant(column.getTimeZone().toZoneId().getRules().getOffset(dateTime));
            }
        }
        throw new ClientException("Column of type " + column.getDataType() + " cannot be converted to Instant");
    }

    @Override
    public ZonedDateTime getZonedDateTime(String colName) {
        ClickHouseColumn column = this.schema.getColumnByName(colName);
        switch (column.getDataType()) {
            case Date: 
            case Date32: 
            case DateTime: 
            case DateTime64: {
                return (ZonedDateTime)this.readValue(colName);
            }
        }
        throw new ClientException("Column of type " + column.getDataType() + " cannot be converted to Instant");
    }

    @Override
    public Duration getDuration(String colName) {
        return (Duration)this.readValue(colName);
    }

    @Override
    public TemporalAmount getTemporalAmount(String colName) {
        return (TemporalAmount)this.readValue(colName);
    }

    @Override
    public Inet4Address getInet4Address(String colName) {
        return (Inet4Address)this.readValue(colName);
    }

    @Override
    public Inet6Address getInet6Address(String colName) {
        return (Inet6Address)this.readValue(colName);
    }

    @Override
    public UUID getUUID(String colName) {
        return (UUID)this.readValue(colName);
    }

    @Override
    public ClickHouseGeoPointValue getGeoPoint(String colName) {
        return ClickHouseGeoPointValue.of((double[])((double[])this.readValue(colName)));
    }

    @Override
    public ClickHouseGeoRingValue getGeoRing(String colName) {
        return ClickHouseGeoRingValue.of((double[][])((double[][])this.readValue(colName)));
    }

    @Override
    public ClickHouseGeoPolygonValue getGeoPolygon(String colName) {
        return ClickHouseGeoPolygonValue.of((double[][][])((double[][][])this.readValue(colName)));
    }

    @Override
    public ClickHouseGeoMultiPolygonValue getGeoMultiPolygon(String colName) {
        return ClickHouseGeoMultiPolygonValue.of((double[][][][])((double[][][][])this.readValue(colName)));
    }

    @Override
    public <T> List<T> getList(String colName) {
        T value = this.readValue(colName);
        if (value instanceof BinaryStreamReader.ArrayValue) {
            return ((BinaryStreamReader.ArrayValue)value).asList();
        }
        throw new ClientException("Column is not of array type");
    }

    private <T> T getPrimitiveArray(String colName) {
        BinaryStreamReader.ArrayValue array = (BinaryStreamReader.ArrayValue)this.readValue(colName);
        if (array.itemType.isPrimitive()) {
            return (T)array.array;
        }
        throw new ClientException("Array is not of primitive type");
    }

    @Override
    public byte[] getByteArray(String colName) {
        return (byte[])this.getPrimitiveArray(colName);
    }

    @Override
    public int[] getIntArray(String colName) {
        return (int[])this.getPrimitiveArray(colName);
    }

    @Override
    public long[] getLongArray(String colName) {
        return (long[])this.getPrimitiveArray(colName);
    }

    @Override
    public float[] getFloatArray(String colName) {
        return (float[])this.getPrimitiveArray(colName);
    }

    @Override
    public double[] getDoubleArray(String colName) {
        return (double[])this.getPrimitiveArray(colName);
    }

    @Override
    public boolean[] getBooleanArray(String colName) {
        return (boolean[])this.getPrimitiveArray(colName);
    }

    @Override
    public boolean hasValue(int colIndex) {
        return this.record.containsKey(this.schema.columnIndexToName(colIndex));
    }

    @Override
    public boolean hasValue(String colName) {
        return this.record.containsKey(colName);
    }

    @Override
    public byte getByte(int index) {
        return this.getByte(this.schema.columnIndexToName(index));
    }

    @Override
    public short getShort(int index) {
        return this.getShort(this.schema.columnIndexToName(index));
    }

    @Override
    public int getInteger(int index) {
        return this.getInteger(this.schema.columnIndexToName(index));
    }

    @Override
    public long getLong(int index) {
        return this.getLong(this.schema.columnIndexToName(index));
    }

    @Override
    public float getFloat(int index) {
        return this.getFloat(this.schema.columnIndexToName(index));
    }

    @Override
    public double getDouble(int index) {
        return this.getDouble(this.schema.columnIndexToName(index));
    }

    @Override
    public boolean getBoolean(int index) {
        return this.getBoolean(this.schema.columnIndexToName(index));
    }

    @Override
    public BigInteger getBigInteger(int index) {
        return (BigInteger)this.readValue(index);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return (BigDecimal)this.readValue(index);
    }

    @Override
    public Instant getInstant(int index) {
        return (Instant)this.readValue(index);
    }

    @Override
    public ZonedDateTime getZonedDateTime(int index) {
        return (ZonedDateTime)this.readValue(index);
    }

    @Override
    public Duration getDuration(int index) {
        return (Duration)this.readValue(index);
    }

    @Override
    public TemporalAmount getTemporalAmount(int index) {
        return (TemporalAmount)this.readValue(index);
    }

    @Override
    public Inet4Address getInet4Address(int index) {
        return (Inet4Address)this.readValue(index);
    }

    @Override
    public Inet6Address getInet6Address(int index) {
        return (Inet6Address)this.readValue(index);
    }

    @Override
    public UUID getUUID(int index) {
        return (UUID)this.readValue(index);
    }

    @Override
    public ClickHouseGeoPointValue getGeoPoint(int index) {
        return (ClickHouseGeoPointValue)this.readValue(index);
    }

    @Override
    public ClickHouseGeoRingValue getGeoRing(int index) {
        return (ClickHouseGeoRingValue)this.readValue(index);
    }

    @Override
    public ClickHouseGeoPolygonValue getGeoPolygon(int index) {
        return (ClickHouseGeoPolygonValue)this.readValue(index);
    }

    @Override
    public ClickHouseGeoMultiPolygonValue getGeoMultiPolygon(int index) {
        return (ClickHouseGeoMultiPolygonValue)this.readValue(index);
    }

    @Override
    public <T> List<T> getList(int index) {
        return this.getList(this.schema.columnIndexToName(index));
    }

    @Override
    public byte[] getByteArray(int index) {
        return (byte[])this.getPrimitiveArray(this.schema.columnIndexToName(index));
    }

    @Override
    public int[] getIntArray(int index) {
        return (int[])this.getPrimitiveArray(this.schema.columnIndexToName(index));
    }

    @Override
    public long[] getLongArray(int index) {
        return (long[])this.getPrimitiveArray(this.schema.columnIndexToName(index));
    }

    @Override
    public float[] getFloatArray(int index) {
        return (float[])this.getPrimitiveArray(this.schema.columnIndexToName(index));
    }

    @Override
    public double[] getDoubleArray(int index) {
        return (double[])this.getPrimitiveArray(this.schema.columnIndexToName(index));
    }

    @Override
    public boolean[] getBooleanArray(int index) {
        return (boolean[])this.getPrimitiveArray(this.schema.columnIndexToName(index));
    }

    @Override
    public Object[] getTuple(int index) {
        return (Object[])this.readValue(index);
    }

    @Override
    public Object[] getTuple(String colName) {
        return (Object[])this.readValue(colName);
    }

    @Override
    public byte getEnum8(String colName) {
        return (Byte)this.readValue(colName);
    }

    @Override
    public byte getEnum8(int index) {
        return (Byte)this.readValue(index);
    }

    @Override
    public short getEnum16(String colName) {
        return (Short)this.readValue(colName);
    }

    @Override
    public short getEnum16(int index) {
        return (Short)this.readValue(index);
    }

    @Override
    public LocalDate getLocalDate(int index) {
        Object value = this.readValue(index);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDate();
        }
        return (LocalDate)value;
    }

    @Override
    public LocalDate getLocalDate(String colName) {
        Object value = this.readValue(colName);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDate();
        }
        return (LocalDate)value;
    }

    @Override
    public LocalDateTime getLocalDateTime(String colName) {
        Object value = this.readValue(colName);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDateTime();
        }
        return (LocalDateTime)value;
    }

    @Override
    public LocalDateTime getLocalDateTime(int index) {
        Object value = this.readValue(index);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toLocalDateTime();
        }
        return (LocalDateTime)value;
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String colName) {
        Object value = this.readValue(colName);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toOffsetDateTime();
        }
        return (OffsetDateTime)value;
    }

    @Override
    public OffsetDateTime getOffsetDateTime(int index) {
        Object value = this.readValue(index);
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toOffsetDateTime();
        }
        return (OffsetDateTime)value;
    }

    @Override
    public ClickHouseBitmap getClickHouseBitmap(String colName) {
        return (ClickHouseBitmap)this.readValue(colName);
    }

    @Override
    public ClickHouseBitmap getClickHouseBitmap(int index) {
        return (ClickHouseBitmap)this.readValue(index);
    }

    @Override
    public TableSchema getSchema() {
        return this.schema;
    }

    @Override
    public Object getObject(String colName) {
        return this.readValue(colName);
    }

    @Override
    public Object getObject(int index) {
        return this.readValue(index);
    }

    @Override
    public Map<String, Object> getValues() {
        return this.record;
    }
}

