/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum DriverProperties {
    IGNORE_UNSUPPORTED_VALUES("jdbc_ignore_unsupported_values", String.valueOf(Boolean.FALSE)),
    SCHEMA_TERM("jdbc_schema_term", "schema"),
    SECURE_CONNECTION("ssl", String.valueOf(Boolean.FALSE)),
    DEFAULT_QUERY_SETTINGS("default_query_settings", null),
    BETA_ROW_BINARY_WRITER("beta.row_binary_for_simple_insert", String.valueOf(Boolean.FALSE)),
    RESULTSET_AUTO_CLOSE("jdbc_resultset_auto_close", String.valueOf(Boolean.TRUE)),
    USE_MAX_RESULT_ROWS("jdbc_use_max_result_rows", String.valueOf(Boolean.FALSE)),
    SQL_PARSER("jdbc_sql_parser", "JAVACC", Arrays.asList("ANTLR4", "ANTLR4_PARAMS_PARSER", "JAVACC"));

    private final String key;
    private final String defaultValue;
    private final List<String> choices;

    private DriverProperties(String key, String defaultValue) {
        this(key, defaultValue, Collections.emptyList());
    }

    private DriverProperties(String key, String defaultValue, List<String> choices) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.choices = choices;
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public List<String> getChoices() {
        return this.choices;
    }
}

