/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.aop.service.impl;

import com.codingapi.tx.annotation.TxTransaction;
import com.codingapi.tx.aop.bean.TxTransactionInfo;
import com.codingapi.tx.aop.bean.TxTransactionLocal;
import com.codingapi.tx.aop.service.AspectBeforeService;
import com.codingapi.tx.aop.service.TransactionServer;
import com.codingapi.tx.aop.service.TransactionServerFactoryService;
import com.codingapi.tx.model.TransactionInvocation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AspectBeforeServiceImpl
implements AspectBeforeService {
    @Autowired
    private TransactionServerFactoryService transactionServerFactoryService;
    private Logger logger = LoggerFactory.getLogger(AspectBeforeServiceImpl.class);

    @Override
    public Object around(String groupId, ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Class<?> clazz = point.getTarget().getClass();
        Object[] args = point.getArgs();
        Method thisMethod = clazz.getMethod(method.getName(), method.getParameterTypes());
        TxTransaction transaction = thisMethod.getAnnotation(TxTransaction.class);
        TxTransactionLocal txTransactionLocal = TxTransactionLocal.current();
        this.logger.debug("around--> groupId-> " + groupId + ",txTransactionLocal->" + txTransactionLocal);
        TransactionInvocation invocation = new TransactionInvocation(clazz, thisMethod.getName(), thisMethod.toString(), args, method.getParameterTypes());
        TxTransactionInfo info = new TxTransactionInfo(transaction, txTransactionLocal, invocation, groupId);
        TransactionServer server = this.transactionServerFactoryService.createTransactionServer(info);
        return server.execute(point, info);
    }
}

