/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.datasource;

import com.codingapi.tx.aop.bean.TxTransactionLocal;
import com.codingapi.tx.datasource.ICallClose;
import com.codingapi.tx.datasource.ILCNResource;
import com.codingapi.tx.datasource.ILCNTransactionControl;
import com.codingapi.tx.datasource.service.DataSourceService;
import com.codingapi.tx.framework.task.TxTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractResourceProxy<C, T extends ILCNResource>
implements ILCNTransactionControl {
    protected Map<String, ILCNResource> pools = new ConcurrentHashMap<String, ILCNResource>();
    private Logger logger = LoggerFactory.getLogger(AbstractResourceProxy.class);
    @Autowired
    protected DataSourceService dataSourceService;
    protected volatile int maxCount = 5;
    protected int maxWaitTime = 30;
    protected volatile int nowCount = 0;
    protected volatile boolean hasTransaction = false;
    private volatile boolean isNoTransaction = false;
    protected ICallClose<ILCNResource> subNowCount = new ICallClose<ILCNResource>(){

        @Override
        public void close(ILCNResource connection) {
            TxTask waitTask = connection.getWaitTask();
            if (waitTask != null && !waitTask.isRemove()) {
                waitTask.remove();
            }
            AbstractResourceProxy.this.pools.remove(connection.getGroupId());
            --AbstractResourceProxy.this.nowCount;
        }
    };

    protected abstract C createLcnConnection(C var1, TxTransactionLocal var2);

    protected abstract void initDbType();

    protected ILCNResource loadConnection() {
        TxTransactionLocal txTransactionLocal = TxTransactionLocal.current();
        if (txTransactionLocal == null) {
            this.logger.debug("loadConnection -> null !");
            return null;
        }
        ILCNResource old = this.pools.get(txTransactionLocal.getGroupId());
        if (old != null) {
            if (txTransactionLocal.isHasConnection()) {
                this.logger.debug("connection is had , transaction get a new connection .");
                return null;
            }
            this.logger.debug("loadConnection -> old !");
            txTransactionLocal.setHasConnection(true);
            return old;
        }
        return null;
    }

    private C createConnection(TxTransactionLocal txTransactionLocal, C connection) {
        if (this.nowCount == this.maxCount) {
            for (int i = 0; i < this.maxWaitTime; ++i) {
                for (int j = 0; j < 100; ++j) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (this.nowCount >= this.maxCount) continue;
                    return this.createLcnConnection(connection, txTransactionLocal);
                }
            }
        } else {
            if (this.nowCount < this.maxCount) {
                return this.createLcnConnection(connection, txTransactionLocal);
            }
            this.logger.info("connection was overload");
            return null;
        }
        return connection;
    }

    protected C initLCNConnection(C connection) {
        this.logger.debug("initLCNConnection");
        C lcnConnection = connection;
        TxTransactionLocal txTransactionLocal = TxTransactionLocal.current();
        if (txTransactionLocal != null && !txTransactionLocal.isHasConnection()) {
            this.logger.debug("lcn datasource transaction control ");
            if (StringUtils.isNotEmpty((String)txTransactionLocal.getGroupId())) {
                this.logger.debug("lcn transaction ");
                return this.createConnection(txTransactionLocal, connection);
            }
        }
        this.logger.debug("load default connection !");
        return lcnConnection;
    }

    @Override
    public boolean hasGroup(String group) {
        return this.pools.containsKey(group);
    }

    @Override
    public boolean executeTransactionOperation() {
        return this.hasTransaction;
    }

    @Override
    public boolean isNoTransactionOperation() {
        return this.isNoTransaction;
    }

    @Override
    public void autoNoTransactionOperation() {
        this.isNoTransaction = true;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }
}

