/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.framework.task;

import com.codingapi.tx.framework.task.TaskGroup;
import com.codingapi.tx.framework.task.TxTask;
import com.lorne.core.framework.utils.task.ConditionUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public class TaskGroupManager {
    private Map<String, TaskGroup> taskMap = new ConcurrentHashMap<String, TaskGroup>();
    private static TaskGroupManager instance = null;

    private TaskGroupManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskGroupManager getInstance() {
        if (instance != null) return instance;
        Class<TaskGroupManager> clazz = TaskGroupManager.class;
        synchronized (TaskGroupManager.class) {
            if (instance != null) return instance;
            instance = new TaskGroupManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public TaskGroup createTask(String key, String type) {
        TaskGroup taskGroup = this.getTaskGroup(key);
        if (taskGroup == null) {
            taskGroup = new TaskGroup();
        }
        taskGroup.setKey(key);
        String taskKey = type + "_" + key;
        TxTask task = new TxTask(ConditionUtils.getInstance().createTask(taskKey));
        taskGroup.setCurrent(task);
        taskGroup.addTask(task);
        this.taskMap.put(key, taskGroup);
        return taskGroup;
    }

    public TaskGroup getTaskGroup(String key) {
        return this.taskMap.get(key);
    }

    public TxTask getTask(String key, String type) {
        String taskKey = type + "_" + key;
        TaskGroup txGroup = this.taskMap.get(key);
        if (txGroup != null) {
            for (TxTask task : txGroup.getTasks()) {
                if (!taskKey.equals(task.getKey())) continue;
                return task;
            }
        }
        return null;
    }

    public void removeKey(String key) {
        if (StringUtils.isNotEmpty((String)key)) {
            this.taskMap.remove(key);
        }
    }
}

