/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.framework.utils;

import com.codingapi.tx.framework.utils.SocketUtils;
import com.codingapi.tx.model.Request;
import com.lorne.core.framework.utils.task.ConditionUtils;
import com.lorne.core.framework.utils.task.IBack;
import com.lorne.core.framework.utils.task.Task;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketManager {
    private static final Logger logger = LoggerFactory.getLogger(SocketManager.class);
    private ChannelHandlerContext ctx;
    private volatile int delay = 1;
    private volatile boolean netState = false;
    private static SocketManager manager = null;
    private ExecutorService threadPool = Executors.newFixedThreadPool(50);
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(50);
    private static final int max_size = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SocketManager getInstance() {
        if (manager != null) return manager;
        Class<SocketManager> clazz = SocketManager.class;
        synchronized (SocketManager.class) {
            if (manager != null) return manager;
            manager = new SocketManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    private SocketManager() {
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public boolean isNetState() {
        return this.netState;
    }

    public void setNetState(boolean netState) {
        this.netState = netState;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    private void sleepSend(Task task, Request request) {
        while (!task.isAwait()) {
            Thread.currentThread();
            if (Thread.interrupted()) break;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        SocketUtils.sendMsg(this.ctx, request.toMsg());
        logger.info("send-msg->" + request.toMsg());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendMsg(final Request request) {
        final String key = request.getKey();
        if (this.ctx != null && this.ctx.channel() != null && this.ctx.channel().isActive()) {
            final Task task = ConditionUtils.getInstance().createTask(key);
            ScheduledFuture<?> future = this.executorService.schedule(new Runnable(){

                @Override
                public void run() {
                    Task task = ConditionUtils.getInstance().getTask(key);
                    if (task != null && !task.isNotify()) {
                        task.setBack(new IBack(){

                            public Object doing(Object ... objs) throws Throwable {
                                return null;
                            }
                        });
                        task.signalTask();
                    }
                }
            }, (long)this.delay, TimeUnit.SECONDS);
            this.threadPool.execute(new Runnable(){

                @Override
                public void run() {
                    SocketManager.this.sleepSend(task, request);
                }
            });
            task.awaitTask();
            if (!future.isDone()) {
                future.cancel(false);
            }
            try {
                Object msg = task.getBack().doing(new Object[0]);
                String string = (String)msg;
                return string;
            }
            catch (Throwable throwable) {
            }
            finally {
                task.remove();
            }
        }
        return null;
    }

    public void close() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

