/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.framework.utils.serializer;

import com.codingapi.tx.framework.utils.serializer.ISerializer;
import com.codingapi.tx.framework.utils.serializer.SchemaCache;
import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import com.lorne.core.framework.exception.SerializerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class ProtostuffSerializer
implements ISerializer {
    private static final SchemaCache cachedSchema = SchemaCache.getInstance();
    private static final Objenesis objenesis = new ObjenesisStd(true);

    private static <T> Schema<T> getSchema(Class<T> cls) {
        return cachedSchema.get(cls);
    }

    @Override
    public byte[] serialize(Object obj) throws SerializerException {
        Class<?> cls = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Schema<?> schema = ProtostuffSerializer.getSchema(cls);
            ProtostuffIOUtil.writeTo((OutputStream)outputStream, (Object)obj, schema, (LinkedBuffer)buffer);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            buffer.clear();
        }
        return outputStream.toByteArray();
    }

    @Override
    public <T> T deSerialize(byte[] param, Class<T> clazz) throws SerializerException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(param);
            Class<T> cls = clazz;
            Object object = objenesis.newInstance(cls);
            Schema<T> schema = ProtostuffSerializer.getSchema(cls);
            ProtostuffIOUtil.mergeFrom((InputStream)inputStream, (Object)object, schema);
            return (T)object;
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }
}

