/*
 * Decompiled with CFR 0.152.
 */
package com.coreos.jetcd.resolver;

import com.coreos.jetcd.resolver.SmartNameResolver;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SmartNameResolverFactory
extends NameResolver.Factory {
    private final List<URI> uris;

    private SmartNameResolverFactory(List<URI> uris) {
        this.uris = uris;
    }

    @Nullable
    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        if ("etcd".equals(targetUri.getScheme())) {
            return new SmartNameResolver(this.uris);
        }
        return null;
    }

    public String getDefaultScheme() {
        return "etcd";
    }

    public static SmartNameResolverFactory forEndpoints(String ... endpoints) {
        return SmartNameResolverFactory.forEndpoints(Arrays.asList(endpoints));
    }

    public static SmartNameResolverFactory forEndpoints(Collection<String> endpoints) {
        List<URI> uris = endpoints.stream().map(endpoint -> {
            try {
                return new URI((String)endpoint);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }).collect(Collectors.toList());
        return new SmartNameResolverFactory(uris);
    }
}

