/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.executor;

import com.dangdang.ddframe.job.api.ShardingContext;
import com.dangdang.ddframe.job.config.JobRootConfiguration;
import com.dangdang.ddframe.job.event.type.JobExecutionEvent;
import com.dangdang.ddframe.job.event.type.JobStatusTraceEvent;
import com.dangdang.ddframe.job.exception.ExceptionUtil;
import com.dangdang.ddframe.job.exception.JobExecutionEnvironmentException;
import com.dangdang.ddframe.job.exception.JobSystemException;
import com.dangdang.ddframe.job.executor.JobFacade;
import com.dangdang.ddframe.job.executor.ShardingContexts;
import com.dangdang.ddframe.job.executor.handler.ExecutorServiceHandler;
import com.dangdang.ddframe.job.executor.handler.ExecutorServiceHandlerRegistry;
import com.dangdang.ddframe.job.executor.handler.JobExceptionHandler;
import com.dangdang.ddframe.job.executor.handler.JobProperties;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractElasticJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbstractElasticJobExecutor.class);
    private final JobFacade jobFacade;
    private final JobRootConfiguration jobRootConfig;
    private final String jobName;
    private final ExecutorService executorService;
    private final JobExceptionHandler jobExceptionHandler;
    private final Map<Integer, String> itemErrorMessages;

    protected AbstractElasticJobExecutor(JobFacade jobFacade) {
        this.jobFacade = jobFacade;
        this.jobRootConfig = jobFacade.loadJobRootConfiguration(true);
        this.jobName = this.jobRootConfig.getTypeConfig().getCoreConfig().getJobName();
        this.executorService = ExecutorServiceHandlerRegistry.getExecutorServiceHandler(this.jobName, (ExecutorServiceHandler)this.getHandler(JobProperties.JobPropertiesEnum.EXECUTOR_SERVICE_HANDLER));
        this.jobExceptionHandler = (JobExceptionHandler)this.getHandler(JobProperties.JobPropertiesEnum.JOB_EXCEPTION_HANDLER);
        this.itemErrorMessages = new ConcurrentHashMap<Integer, String>(this.jobRootConfig.getTypeConfig().getCoreConfig().getShardingTotalCount(), 1.0f);
    }

    private Object getHandler(JobProperties.JobPropertiesEnum jobPropertiesEnum) {
        String handlerClassName = this.jobRootConfig.getTypeConfig().getCoreConfig().getJobProperties().get(jobPropertiesEnum);
        try {
            Class<?> handlerClass = Class.forName(handlerClassName);
            if (jobPropertiesEnum.getClassType().isAssignableFrom(handlerClass)) {
                return handlerClass.newInstance();
            }
            return this.getDefaultHandler(jobPropertiesEnum, handlerClassName);
        }
        catch (ReflectiveOperationException ex) {
            return this.getDefaultHandler(jobPropertiesEnum, handlerClassName);
        }
    }

    private Object getDefaultHandler(JobProperties.JobPropertiesEnum jobPropertiesEnum, String handlerClassName) {
        log.warn("Cannot instantiation class '{}', use default '{}' class.", (Object)handlerClassName, (Object)jobPropertiesEnum.getKey());
        try {
            return Class.forName(jobPropertiesEnum.getDefaultValue()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new JobSystemException(e);
        }
    }

    public final void execute() {
        try {
            this.jobFacade.checkJobExecutionEnvironment();
        }
        catch (JobExecutionEnvironmentException cause) {
            this.jobExceptionHandler.handleException(this.jobName, cause);
        }
        ShardingContexts shardingContexts = this.jobFacade.getShardingContexts();
        if (shardingContexts.isAllowSendJobEvent()) {
            this.jobFacade.postJobStatusTraceEvent(shardingContexts.getTaskId(), JobStatusTraceEvent.State.TASK_STAGING, String.format("Job '%s' execute begin.", this.jobName));
        }
        if (this.jobFacade.misfireIfNecessary(shardingContexts.getShardingItemParameters().keySet())) {
            if (shardingContexts.isAllowSendJobEvent()) {
                this.jobFacade.postJobStatusTraceEvent(shardingContexts.getTaskId(), JobStatusTraceEvent.State.TASK_FINISHED, String.format("Previous job '%s' - shardingItems '%s' is still running, misfired job will start after previous job completed.", this.jobName, shardingContexts.getShardingItemParameters().keySet()));
            }
            return;
        }
        this.jobFacade.cleanPreviousExecutionInfo();
        try {
            this.jobFacade.beforeJobExecuted(shardingContexts);
        }
        catch (Throwable cause) {
            this.jobExceptionHandler.handleException(this.jobName, cause);
        }
        this.execute(shardingContexts, JobExecutionEvent.ExecutionSource.NORMAL_TRIGGER);
        while (this.jobFacade.isExecuteMisfired(shardingContexts.getShardingItemParameters().keySet())) {
            this.jobFacade.clearMisfire(shardingContexts.getShardingItemParameters().keySet());
            this.execute(shardingContexts, JobExecutionEvent.ExecutionSource.MISFIRE);
        }
        this.jobFacade.failoverIfNecessary();
        try {
            this.jobFacade.afterJobExecuted(shardingContexts);
        }
        catch (Throwable cause) {
            this.jobExceptionHandler.handleException(this.jobName, cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(ShardingContexts shardingContexts, JobExecutionEvent.ExecutionSource executionSource) {
        if (shardingContexts.getShardingItemParameters().isEmpty()) {
            if (shardingContexts.isAllowSendJobEvent()) {
                this.jobFacade.postJobStatusTraceEvent(shardingContexts.getTaskId(), JobStatusTraceEvent.State.TASK_FINISHED, String.format("Sharding item for job '%s' is empty.", this.jobName));
            }
            return;
        }
        this.jobFacade.registerJobBegin(shardingContexts);
        String taskId = shardingContexts.getTaskId();
        if (shardingContexts.isAllowSendJobEvent()) {
            this.jobFacade.postJobStatusTraceEvent(taskId, JobStatusTraceEvent.State.TASK_RUNNING, "");
        }
        try {
            this.process(shardingContexts, executionSource);
        }
        finally {
            this.jobFacade.registerJobCompleted(shardingContexts);
            if (this.itemErrorMessages.isEmpty()) {
                if (shardingContexts.isAllowSendJobEvent()) {
                    this.jobFacade.postJobStatusTraceEvent(taskId, JobStatusTraceEvent.State.TASK_FINISHED, "");
                }
            } else if (shardingContexts.isAllowSendJobEvent()) {
                this.jobFacade.postJobStatusTraceEvent(taskId, JobStatusTraceEvent.State.TASK_ERROR, this.itemErrorMessages.toString());
            }
        }
    }

    private void process(final ShardingContexts shardingContexts, JobExecutionEvent.ExecutionSource executionSource) {
        Set<Integer> items = shardingContexts.getShardingItemParameters().keySet();
        if (1 == items.size()) {
            int item = shardingContexts.getShardingItemParameters().keySet().iterator().next();
            JobExecutionEvent jobExecutionEvent = new JobExecutionEvent(shardingContexts.getTaskId(), this.jobName, executionSource, item);
            this.process(shardingContexts, item, jobExecutionEvent);
            return;
        }
        final CountDownLatch latch = new CountDownLatch(items.size());
        Iterator jobExecutionEvent = items.iterator();
        while (jobExecutionEvent.hasNext()) {
            final int each = (Integer)jobExecutionEvent.next();
            final JobExecutionEvent jobExecutionEvent2 = new JobExecutionEvent(shardingContexts.getTaskId(), this.jobName, executionSource, each);
            if (this.executorService.isShutdown()) {
                return;
            }
            this.executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractElasticJobExecutor.this.process(shardingContexts, each, jobExecutionEvent2);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(ShardingContexts shardingContexts, int item, JobExecutionEvent startEvent) {
        if (shardingContexts.isAllowSendJobEvent()) {
            this.jobFacade.postJobExecutionEvent(startEvent);
        }
        log.trace("Job '{}' executing, item is: '{}'.", (Object)this.jobName, (Object)item);
        JobExecutionEvent completeEvent = null;
        try {
            this.process(new ShardingContext(shardingContexts, item));
            completeEvent = startEvent.executionSuccess();
            log.trace("Job '{}' executed, item is: '{}'.", (Object)this.jobName, (Object)item);
        }
        catch (Throwable cause) {
            completeEvent = startEvent.executionFailure(cause);
            this.itemErrorMessages.put(item, ExceptionUtil.transform(cause));
            this.jobExceptionHandler.handleException(this.jobName, cause);
        }
        finally {
            if (shardingContexts.isAllowSendJobEvent()) {
                this.jobFacade.postJobExecutionEvent(completeEvent);
            }
        }
    }

    protected abstract void process(ShardingContext var1);

    protected JobFacade getJobFacade() {
        return this.jobFacade;
    }

    protected JobRootConfiguration getJobRootConfig() {
        return this.jobRootConfig;
    }
}

