/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.util.concurrent;

import com.google.common.base.Joiner;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public final class ExecutorServiceObject {
    private final ThreadPoolExecutor threadPoolExecutor;
    private final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();

    public ExecutorServiceObject(String namingPattern, int threadSize) {
        this.threadPoolExecutor = new ThreadPoolExecutor(threadSize, threadSize, 5L, TimeUnit.MINUTES, this.workQueue, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern(Joiner.on((String)"-").join((Object)namingPattern, (Object)"%s", new Object[0])).build());
        this.threadPoolExecutor.allowCoreThreadTimeOut(true);
    }

    public ExecutorService createExecutorService() {
        return MoreExecutors.listeningDecorator((ExecutorService)MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)this.threadPoolExecutor));
    }

    public boolean isShutdown() {
        return this.threadPoolExecutor.isShutdown();
    }

    public int getActiveThreadCount() {
        return this.threadPoolExecutor.getActiveCount();
    }

    public int getWorkQueueSize() {
        return this.workQueue.size();
    }
}

