/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.api.callback;

import com.dingtalk.open.app.api.DingTalkAppError;
import com.dingtalk.open.app.api.OpenDingTalkAppException;
import com.dingtalk.open.app.api.callback.CallbackMethod;
import com.dingtalk.open.app.api.callback.OpenDingTalkCallbackListener;
import com.dingtalk.open.app.api.callback.SimpleMethod;
import com.dingtalk.open.app.api.common.AopUtils;
import com.dingtalk.open.app.api.common.LambdaUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

class CallbackDescriptor {
    private final CallbackMethod method;
    private final Type parameterType;

    private CallbackDescriptor(CallbackMethod callbackMethod, Type parameterType) {
        this.method = callbackMethod;
        this.parameterType = parameterType;
    }

    public static <Req, Resp> CallbackDescriptor build(OpenDingTalkCallbackListener<Req, Resp> callback) {
        Type target = null;
        if (LambdaUtils.isLambda(callback)) {
            List<Type> types = LambdaUtils.getLambdaParameterTypes(callback);
            if (types == null || types.size() != 1) {
                throw new OpenDingTalkAppException(DingTalkAppError.LAMBDA_PARSE_FAILED, new String[0]);
            }
            target = types.get(0);
        } else {
            Type[] types;
            for (Type type : types = AopUtils.getTargetClass(callback).getGenericInterfaces()) {
                Class rawType;
                if (!(type instanceof ParameterizedType) || !OpenDingTalkCallbackListener.class.isAssignableFrom(rawType = (Class)((ParameterizedType)type).getRawType())) continue;
                target = ((ParameterizedType)type).getActualTypeArguments()[0];
                break;
            }
        }
        if (target == null) {
            throw new OpenDingTalkAppException(DingTalkAppError.ILLEGAL_CALLBACK, new String[0]);
        }
        return new CallbackDescriptor(new SimpleMethod(callback), target);
    }

    public Type getParameterType() {
        return this.parameterType;
    }

    public CallbackMethod getMethod() {
        return this.method;
    }
}

