/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.api.common;

import com.dingtalk.open.app.api.DingTalkAppError;
import com.dingtalk.open.app.api.OpenDingTalkAppException;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LambdaUtils {
    private static final Pattern LAMBDA_PATTERN = Pattern.compile(".*\\$\\$Lambda\\$[0-9]+/.*");
    private static final Pattern PARAMETER_TYPE_PATTERN = Pattern.compile("\\((.*)\\).*");
    private static final String WRITE_REPLACE = "writeReplace";

    public static boolean isLambda(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().isSynthetic() && LAMBDA_PATTERN.matcher(obj.getClass().getSimpleName()).matches();
    }

    public static List<Type> getLambdaParameterTypes(Object obj) {
        try {
            Method method = obj.getClass().getDeclaredMethod(WRITE_REPLACE, new Class[0]);
            method.setAccessible(true);
            SerializedLambda lambda = (SerializedLambda)method.invoke(obj, new Object[0]);
            Matcher matcher = PARAMETER_TYPE_PATTERN.matcher(lambda.getInstantiatedMethodType());
            if (!matcher.find() || matcher.groupCount() != 1) {
                throw new OpenDingTalkAppException(DingTalkAppError.LAMBDA_PARSE_FAILED, new String[0]);
            }
            return Arrays.stream(matcher.group(1).split(";")).filter(s -> !s.isEmpty()).map(s -> s.replace("L", "").replace("/", ".")).map(s -> {
                try {
                    return Class.forName(s);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("can not load class", e);
                }
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            return new ArrayList<Type>();
        }
    }
}

