/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.stream.network.ws;

import com.dingtalk.open.app.stream.network.api.logger.InternalLogger;
import com.dingtalk.open.app.stream.network.api.logger.InternalLoggerFactory;
import com.dingtalk.open.app.stream.network.api.utils.NettyByteBufUtils;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import shade.io.netty.buffer.ByteBuf;
import shade.io.netty.buffer.Unpooled;
import shade.io.netty.channel.Channel;
import shade.io.netty.channel.ChannelHandlerContext;
import shade.io.netty.channel.SimpleChannelInboundHandler;
import shade.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import shade.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import shade.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import shade.io.netty.handler.timeout.IdleStateEvent;
import shade.io.netty.util.HashedWheelTimer;
import shade.io.netty.util.Timeout;
import shade.io.netty.util.concurrent.Future;
import shade.io.netty.util.concurrent.GenericFutureListener;

public class KeepAliveHandler
extends SimpleChannelInboundHandler<PongWebSocketFrame> {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(KeepAliveHandler.class);
    private final Duration timeout;
    private final HashedWheelTimer timer;
    private Channel channel;
    private final Map<String, Timeout> timeouts;
    private final AtomicBoolean active;

    public KeepAliveHandler(Duration timeout) {
        this.timeout = timeout;
        this.timer = new HashedWheelTimer();
        this.active = new AtomicBoolean(false);
        this.timeouts = new ConcurrentHashMap<String, Timeout>();
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE && this.active.compareAndSet(false, true)) {
            this.channel = ctx.channel();
        }
        if (evt instanceof IdleStateEvent) {
            this.channel.eventLoop().execute(new PingTask());
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, PongWebSocketFrame msg) throws Exception {
        byte[] data = NettyByteBufUtils.getBytes(msg.content());
        Timeout out = this.timeouts.remove(new String(data));
        if (out != null) {
            out.cancel();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.shutdown();
        super.channelInactive(ctx);
    }

    private void shutdown() {
        Iterator<Map.Entry<String, Timeout>> it = this.timeouts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Timeout> entry = it.next();
            entry.getValue().cancel();
            it.remove();
        }
        this.timer.stop();
    }

    private class PingTask
    implements Runnable {
        private PingTask() {
        }

        @Override
        public void run() {
            if (!KeepAliveHandler.this.timeouts.isEmpty()) {
                return;
            }
            String seq = UUID.randomUUID().toString();
            ByteBuf byteBuf = Unpooled.copiedBuffer(seq.getBytes());
            PingWebSocketFrame frame = new PingWebSocketFrame(byteBuf);
            KeepAliveHandler.this.channel.writeAndFlush(frame).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    Timeout pingTimeout = KeepAliveHandler.this.timer.newTimeout(timeout -> {
                        LOGGER.warn("[DingTalk] connection ping timeout, channel is closing", new Object[0]);
                        KeepAliveHandler.this.timeouts.remove(seq);
                        KeepAliveHandler.this.channel.close();
                    }, KeepAliveHandler.this.timeout.toMillis(), TimeUnit.MILLISECONDS);
                    KeepAliveHandler.this.timeouts.put(seq, pingTimeout);
                } else {
                    KeepAliveHandler.this.channel.close();
                }
            }));
        }
    }
}

