/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.http;

import com.egzosn.pay.common.http.HttpHeader;
import com.egzosn.pay.common.http.UriVariables;
import com.egzosn.pay.common.util.str.StringUtils;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;

public class HttpStringEntity
extends StringEntity {
    private List<Header> headers;
    private boolean isEmpty = false;

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void setEmpty(boolean empty) {
        this.isEmpty = empty;
    }

    public void requestIsEmpty(Map<String, Object> request) {
        if (null == request || request.isEmpty()) {
            this.isEmpty = true;
        }
    }

    public void requestIsEmpty(String request) {
        if (StringUtils.isEmpty(request)) {
            this.isEmpty = true;
        }
    }

    public HttpStringEntity(Map<String, Object> request, Header ... headers) throws UnsupportedEncodingException {
        this(UriVariables.getMapToParameters(request), headers);
        this.requestIsEmpty(request);
    }

    public HttpStringEntity(Map<String, Object> request, Map<String, String> headers) throws UnsupportedEncodingException {
        this(UriVariables.getMapToParameters(request), headers);
        this.requestIsEmpty(request);
    }

    public HttpStringEntity(Map<String, Object> request, ContentType contentType) {
        super(UriVariables.getMapToParameters(request), contentType);
        this.requestIsEmpty(request);
    }

    public HttpStringEntity(Map<String, Object> request, String charset) {
        super(UriVariables.getMapToParameters(request), charset);
        this.requestIsEmpty(request);
    }

    public HttpStringEntity(Map<String, Object> request, Charset charset) {
        super(UriVariables.getMapToParameters(request), charset);
        this.requestIsEmpty(request);
    }

    public HttpStringEntity(Map<String, Object> request) throws UnsupportedEncodingException {
        super(UriVariables.getMapToParameters(request));
        this.requestIsEmpty(request);
    }

    public HttpStringEntity(String request, ContentType contentType) throws UnsupportedCharsetException {
        super(request, contentType);
        this.requestIsEmpty(request);
    }

    public HttpStringEntity(String request, String charset) throws UnsupportedCharsetException {
        super(request, charset);
        this.requestIsEmpty(request);
    }

    public HttpStringEntity(String request, Charset charset) {
        super(request, charset);
        this.requestIsEmpty(request);
    }

    public HttpStringEntity(String request, Header ... headers) throws UnsupportedEncodingException {
        super(request);
        this.requestIsEmpty(request);
        if (null != headers) {
            this.headers = Arrays.asList(headers);
        }
    }

    public HttpStringEntity(String request, Map<String, String> headers) throws UnsupportedEncodingException {
        super(request);
        this.requestIsEmpty(request);
        this.headers = new ArrayList<Header>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.addHeader((Header)new BasicHeader(entry.getKey(), entry.getValue()));
        }
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public void addHeader(Header header) {
        if (null == this.headers) {
            this.headers = new ArrayList<Header>();
        }
        this.headers.add(header);
    }

    public void setHeaders(List<Header> headers) {
        this.headers = headers;
    }

    public void setHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.addHeader((Header)new BasicHeader(entry.getKey(), entry.getValue()));
        }
    }

    public void setHeaders(HttpHeader header) {
        this.headers = header.getHeaders();
    }
}

