/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.http;

import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.util.str.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UriVariables {
    private static final Logger LOG = LoggerFactory.getLogger(UriVariables.class);
    public static final String QUESTION = "?";

    private UriVariables() {
    }

    public static String getUri(String uri, Object ... uriVariables) {
        if (null == uriVariables) {
            return uri;
        }
        for (Object variable : uriVariables) {
            if (null == variable) continue;
            uri = uri.replaceFirst("\\{\\w+\\}", variable.toString());
        }
        return uri;
    }

    public static String getUri(String uri, Map<String, Object> uriVariables) {
        if (null == uriVariables) {
            return uri;
        }
        for (Map.Entry<String, Object> entry : uriVariables.entrySet()) {
            Object uriVariable = entry.getValue();
            if (null == uriVariable) continue;
            uri = uri.replace("{" + entry.getKey() + "}", uriVariable.toString());
        }
        return uri;
    }

    public static String getMapToParameters(Map<String, ?> pe) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, ?> entry : pe.entrySet()) {
            Object o = entry.getValue();
            if (null == o) continue;
            if (o instanceof List) {
                o = ((List)o).toArray();
            }
            if (o instanceof Object[]) {
                Object[] os = (Object[])o;
                String valueStr = "";
                int len = os.length;
                for (int i = 0; i < len; ++i) {
                    if (null == os[i]) continue;
                    String value = os[i].toString().trim();
                    valueStr = valueStr + (i == len - 1 ? value : value + ",");
                }
                builder.append(entry.getKey()).append("=").append(UriVariables.urlEncoder(valueStr)).append("&");
                continue;
            }
            builder.append(entry.getKey()).append("=").append(UriVariables.urlEncoder(entry.getValue().toString())).append("&");
        }
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static JSONObject getParametersToMap(String str) {
        JSONObject map = new JSONObject();
        int len = str.length();
        StringBuilder temp = new StringBuilder();
        String key = null;
        boolean isKey = true;
        boolean isOpen = false;
        char openName = '\u0000';
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                char curChar = str.charAt(i);
                if (isKey) {
                    if (curChar == '=') {
                        key = temp.toString();
                        temp.setLength(0);
                        isKey = false;
                        continue;
                    }
                    temp.append(curChar);
                    continue;
                }
                if (isOpen) {
                    if (curChar == openName) {
                        isOpen = false;
                    }
                } else {
                    if (curChar == '{') {
                        isOpen = true;
                        openName = '}';
                    }
                    if (curChar == '[') {
                        isOpen = true;
                        openName = ']';
                    }
                }
                if (curChar == '&' && !isOpen) {
                    UriVariables.putKeyValueToMap(temp, false, key, (Map<String, Object>)map);
                    temp.setLength(0);
                    isKey = true;
                    continue;
                }
                temp.append(curChar);
            }
            UriVariables.putKeyValueToMap(temp, isKey, key, (Map<String, Object>)map);
        }
        return map;
    }

    private static void putKeyValueToMap(StringBuilder temp, boolean isKey, String key, Map<String, Object> map) {
        if (isKey) {
            key = temp.toString();
            if (key.length() == 0) {
                throw new PayErrorException(new PayException("QString format illegal", "\u5185\u5bb9\u683c\u5f0f\u6709\u8bef"));
            }
            map.put(key, "");
        } else {
            if (key.length() == 0) {
                throw new PayErrorException(new PayException("QString format illegal", "\u5185\u5bb9\u683c\u5f0f\u6709\u8bef"));
            }
            map.put(key, temp.toString());
        }
    }

    public static String urlEncoder(String str) {
        return UriVariables.urlEncoder(str, "utf-8");
    }

    public static String urlEncoder(String str, String enc) {
        try {
            return URLEncoder.encode(str, enc);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("", (Throwable)e);
            return str;
        }
    }

    public static String getCanonicalUrl(String url) {
        if (StringUtils.isEmpty(url)) {
            return url;
        }
        try {
            URI uri = new URI(url);
            String path = uri.getPath();
            String encodedQuery = uri.getQuery();
            if (StringUtils.isNotEmpty(encodedQuery)) {
                path = path + QUESTION.concat(encodedQuery);
            }
            return path;
        }
        catch (URISyntaxException e) {
            throw new PayErrorException(new PayException("failure", "\u53bb\u9664\u57df\u540d\u7684\u6807\u51c6url\u5931\u8d25"), (Throwable)e);
        }
    }
}

