/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.util;

import java.lang.ref.SoftReference;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.http.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_T_HH_MM_SS_SSSXXX = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final String YYYY_MM_DD_T_HH_MM_SS_XX = "yyyy-MM-dd'T'HH:mm:ssXXX";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String MMDD = "MMdd";
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYY_MM = "yyyy-MM";

    private DateUtils() {
    }

    public static String formatDate(Date date, String pattern) {
        Args.notNull((Object)date, (String)"Date");
        Args.notNull((Object)pattern, (String)"Pattern");
        SimpleDateFormat formatFor = DateFormatHolder.formatFor(pattern);
        return formatFor.format(date);
    }

    public static Date parseDate(String date, String pattern) {
        Args.notNull((Object)date, (String)"Date");
        Args.notNull((Object)pattern, (String)"Pattern");
        SimpleDateFormat formatFor = DateFormatHolder.formatFor(pattern);
        try {
            return formatFor.parse(date);
        }
        catch (ParseException e) {
            LOG.error("", (Throwable)e);
            return null;
        }
    }

    public static Date parse(String date) {
        return DateUtils.parseDate(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static String format(Date date) {
        return DateUtils.formatDate(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static Date parseDay(String date) {
        return DateUtils.parseDate(date, YYYY_MM_DD);
    }

    public static String formatDay(Date date) {
        return DateUtils.formatDate(date, YYYY_MM_DD);
    }

    public static long minutesRemaining(Date date) {
        return date.getTime() / 1000L / 60L - DateUtils.toEpochSecond() / 60L;
    }

    public static long remainingHours(Date date) {
        return DateUtils.minutesRemaining(date) / 60L;
    }

    public static long remainingDays(Date date) {
        return DateUtils.remainingHours(date) / 24L;
    }

    public static long toEpochSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    static final class DateFormatHolder {
        private static final ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>> THREADLOCAL_FORMATS = new ThreadLocal();

        DateFormatHolder() {
        }

        public static SimpleDateFormat formatFor(String pattern) {
            SimpleDateFormat format;
            Map<String, SimpleDateFormat> formats;
            SoftReference<Map<String, SimpleDateFormat>> ref = THREADLOCAL_FORMATS.get();
            Map<String, SimpleDateFormat> map = formats = ref == null ? null : ref.get();
            if (formats == null) {
                formats = new HashMap<String, SimpleDateFormat>();
                THREADLOCAL_FORMATS.set(new SoftReference<Map<String, SimpleDateFormat>>(formats));
            }
            if ((format = formats.get(pattern)) == null) {
                format = new SimpleDateFormat(pattern);
                format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                formats.put(pattern, format);
            }
            return format;
        }

        public static void clearThreadLocal() {
            THREADLOCAL_FORMATS.remove();
        }
    }
}

