/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.util.sign;

import com.egzosn.pay.common.util.str.StringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertDescriptor {
    protected static final Logger LOG = LoggerFactory.getLogger(CertDescriptor.class);
    private KeyStore keyStore = null;
    private X509Certificate publicKeyCert = null;
    private X509Certificate rootKeyCert = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate initCert(InputStream certIn) {
        X509Certificate encryptCertTemp = null;
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            encryptCertTemp = (X509Certificate)cf.generateCertificate(certIn);
            if (LOG.isWarnEnabled()) {
                LOG.warn("[CertId=" + encryptCertTemp.getSerialNumber().toString() + "]");
            }
        }
        catch (CertificateException e) {
            LOG.error("InitCert Error", (Throwable)e);
        }
        finally {
            if (null != certIn) {
                try {
                    certIn.close();
                }
                catch (IOException e) {
                    LOG.error(e.toString());
                }
            }
        }
        return encryptCertTemp;
    }

    private static X509Certificate initCert(String path) {
        X509Certificate encryptCertTemp = null;
        Object cf = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
            encryptCertTemp = CertDescriptor.initCert(in);
        }
        catch (FileNotFoundException e) {
            LOG.error("InitCert Error File Not Found", (Throwable)e);
        }
        return encryptCertTemp;
    }

    public PrivateKey getSignCertPrivateKey(String pwd) {
        try {
            Enumeration<String> aliasenum = this.keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(keyAlias, pwd.toCharArray());
            return privateKey;
        }
        catch (KeyStoreException e) {
            LOG.error("getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
        catch (UnrecoverableKeyException e) {
            LOG.error("getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("getSignCertPrivateKey Error", (Throwable)e);
            return null;
        }
    }

    public String getSignCertId() {
        try {
            Enumeration<String> aliasenum = this.keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            LOG.error("getSignCertId Error", (Throwable)e);
            return null;
        }
    }

    public void initPrivateSignCert(String signCertPath, String signCertPwd, String signCertType) {
        if (null != this.keyStore) {
            this.keyStore = null;
        }
        try {
            this.keyStore = this.getKeyInfo(signCertPath, signCertPwd, signCertType);
            if (LOG.isInfoEnabled()) {
                LOG.info("InitSignCert Successful. CertId=[" + this.getSignCertId() + "]");
            }
        }
        catch (IOException e) {
            LOG.error("InitSignCert Error", (Throwable)e);
        }
    }

    public void initPrivateSignCert(InputStream signCert, String signCertPwd, String signCertType) {
        if (null != this.keyStore) {
            this.keyStore = null;
        }
        this.keyStore = this.getKeyInfo(signCert, signCertPwd, signCertType);
        if (LOG.isInfoEnabled()) {
            LOG.info("InitSignCert Successful. CertId=[" + this.getSignCertId() + "]");
        }
    }

    private KeyStore getKeyInfo(String fxKeyFile, String keyPwd, String type) throws IOException {
        if (LOG.isWarnEnabled()) {
            LOG.warn("\u52a0\u8f7d\u7b7e\u540d\u8bc1\u4e66==>" + fxKeyFile);
        }
        FileInputStream fis = new FileInputStream(fxKeyFile);
        return this.getKeyInfo(fis, keyPwd, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getKeyInfo(InputStream fxKeyFile, String keyPwd, String type) {
        try {
            KeyStore ks = KeyStore.getInstance(type);
            if (LOG.isWarnEnabled()) {
                LOG.warn("Load RSA CertPath,Pwd=[" + keyPwd + "],type=[" + type + "]");
            }
            char[] nPassword = null;
            char[] cArray = nPassword = null == keyPwd || "".equals(keyPwd.trim()) ? null : keyPwd.toCharArray();
            if (null != ks) {
                ks.load(fxKeyFile, nPassword);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            LOG.error("getKeyInfo Error", (Throwable)e);
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (null != fxKeyFile) {
                try {
                    fxKeyFile.close();
                }
                catch (IOException e) {
                    LOG.error("getKeyInfo Error", (Throwable)e);
                }
            }
        }
    }

    private String getCertIdIdByStore(KeyStore keyStore) {
        Enumeration<String> aliasenum = null;
        try {
            aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(keyAlias);
            return cert.getSerialNumber().toString();
        }
        catch (KeyStoreException e) {
            LOG.error("getCertIdIdByStore Error", (Throwable)e);
            return null;
        }
    }

    public void initPublicCert(String certPath) {
        if (!StringUtils.isEmpty(certPath)) {
            this.publicKeyCert = CertDescriptor.initCert(certPath);
            if (LOG.isInfoEnabled()) {
                LOG.info("Load PublicKeyCert Successful");
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("PublicKeyCert is empty");
        }
    }

    public void initPublicCert(InputStream cert) {
        if (null != cert) {
            this.publicKeyCert = CertDescriptor.initCert(cert);
            if (LOG.isInfoEnabled()) {
                LOG.info("Load PublicKeyCert Successful");
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("PublicKeyCert is empty");
        }
    }

    public void initRootCert(String certPath) {
        if (!StringUtils.isEmpty(certPath)) {
            try {
                this.initRootCert(new FileInputStream(certPath));
            }
            catch (FileNotFoundException e) {
                LOG.info("RootCert is empty");
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("RootCert is empty");
        }
    }

    public void initRootCert(InputStream cert) {
        if (null != cert) {
            this.rootKeyCert = CertDescriptor.initCert(cert);
            if (LOG.isInfoEnabled()) {
                LOG.info("Load RootCert Successful");
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("RootCert is empty");
        }
    }

    public X509Certificate getPublicCert() {
        return this.publicKeyCert;
    }

    public X509Certificate getRootCert() {
        return this.rootKeyCert;
    }
}

