/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.common.util.sign;

import com.egzosn.pay.common.bean.SignType;
import com.egzosn.pay.common.util.sign.SignTextUtils;
import com.egzosn.pay.common.util.sign.encrypt.HmacSha256;
import com.egzosn.pay.common.util.sign.encrypt.MD5;
import com.egzosn.pay.common.util.sign.encrypt.RSA;
import com.egzosn.pay.common.util.sign.encrypt.RSA2;
import com.egzosn.pay.common.util.sign.encrypt.SHA1;
import com.egzosn.pay.common.util.sign.encrypt.SHA256;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public enum SignUtils implements SignType
{
    MD5{

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            return com.egzosn.pay.common.util.sign.encrypt.MD5.sign(content, key, characterEncoding);
        }

        @Override
        public boolean verify(String text, String sign, String key, String characterEncoding) {
            return com.egzosn.pay.common.util.sign.encrypt.MD5.verify(text, sign, key, characterEncoding);
        }
    }
    ,
    HMACSHA256{

        @Override
        public String getName() {
            return "HMAC-SHA256";
        }

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            return HmacSha256.createSign(content, key, characterEncoding);
        }

        @Override
        public boolean verify(String text, String sign, String key, String characterEncoding) {
            return this.createSign(text, key, characterEncoding).equals(sign);
        }
    }
    ,
    RSA{

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            return com.egzosn.pay.common.util.sign.encrypt.RSA.sign(content, key, characterEncoding);
        }

        @Override
        public boolean verify(String text, String sign, String publicKey, String characterEncoding) {
            return com.egzosn.pay.common.util.sign.encrypt.RSA.verify(text, sign, publicKey, characterEncoding);
        }
    }
    ,
    RSA2{

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            return com.egzosn.pay.common.util.sign.encrypt.RSA2.sign(content, key, characterEncoding);
        }

        @Override
        public boolean verify(String text, String sign, String publicKey, String characterEncoding) {
            return com.egzosn.pay.common.util.sign.encrypt.RSA2.verify(text, sign, publicKey, characterEncoding);
        }
    }
    ,
    SHA1{

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            return com.egzosn.pay.common.util.sign.encrypt.SHA1.sign(content, key, characterEncoding);
        }

        @Override
        public boolean verify(String text, String sign, String publicKey, String characterEncoding) {
            return com.egzosn.pay.common.util.sign.encrypt.SHA1.verify(text, sign, publicKey, characterEncoding);
        }
    }
    ,
    SHA256{

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            return com.egzosn.pay.common.util.sign.encrypt.SHA256.sign(content, key, characterEncoding);
        }

        @Override
        public boolean verify(String text, String sign, String publicKey, String characterEncoding) {
            return com.egzosn.pay.common.util.sign.encrypt.SHA256.verify(text, sign, publicKey, characterEncoding);
        }
    }
    ,
    SM3{

        @Override
        public String createSign(String content, String key, String characterEncoding) {
            return com.egzosn.pay.common.util.sign.encrypt.RSA2.sign(content, key, characterEncoding);
        }

        @Override
        public boolean verify(String text, String sign, String publicKey, String characterEncoding) {
            return com.egzosn.pay.common.util.sign.encrypt.RSA2.verify(text, sign, publicKey, characterEncoding);
        }
    };


    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String sign(Map parameters, String key, String characterEncoding) {
        return this.createSign(SignTextUtils.parameterText(parameters, "&"), key, characterEncoding);
    }

    @Override
    public String sign(Map parameters, String key, String separator, String characterEncoding) {
        return this.createSign(SignTextUtils.parameterText(parameters, separator), key, characterEncoding);
    }

    @Override
    public boolean verify(Map params, String sign, String key, String characterEncoding) {
        return this.verify(SignTextUtils.parameterText(params), sign, key, characterEncoding);
    }

    public static void initBc() {
        if (null == Security.getProvider("BC")) {
            Security.removeProvider("SunEC");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

