/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.fly.http.cache;

import android.os.StatFs;
import com.tiamosu.fly.http.FlyHttp;
import com.tiamosu.fly.http.cache.converter.IDiskConverter;
import com.tiamosu.fly.http.cache.converter.SerializableDiskConverter;
import com.tiamosu.fly.http.cache.core.CacheCore;
import com.tiamosu.fly.http.cache.core.LruDiskCache;
import com.tiamosu.fly.http.cache.model.CacheMode;
import com.tiamosu.fly.http.cache.model.CacheResult;
import com.tiamosu.fly.http.cache.stategy.IStrategy;
import com.tiamosu.fly.http.utils.FlyHttpLog;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import io.reactivex.rxjava3.core.ObservableOnSubscribe;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u000267B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#2\b\u0010&\u001a\u0004\u0018\u00010\u0011J \u0010'\u001a\b\u0012\u0004\u0012\u0002H(0#\"\b\b\u0000\u0010(*\u00020\u00012\b\u0010&\u001a\u0004\u0018\u00010\u0011J(\u0010'\u001a\b\u0012\u0004\u0012\u0002H(0#\"\b\b\u0000\u0010(*\u00020\u00012\b\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u0010)\u001a\u00020\u0015J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0006\u0010.\u001a\u00020\u0004J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020$0#2\b\u0010&\u001a\u0004\u0018\u00010\u0011J)\u00100\u001a\b\u0012\u0004\u0012\u00020$0#\"\u0004\b\u0000\u0010(2\b\u0010&\u001a\u0004\u0018\u00010\u00112\u0006\u00101\u001a\u0002H(\u00a2\u0006\u0002\u00102J*\u00103\u001a\u0014\u0012\u0004\u0012\u0002H(\u0012\n\u0012\b\u0012\u0004\u0012\u0002H(0504\"\b\b\u0000\u0010(*\u00020\u00012\u0006\u0010,\u001a\u00020-R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017\u00a8\u00068"}, d2={"Lcom/tiamosu/fly/http/cache/RxCache;", "", "()V", "builder", "Lcom/tiamosu/fly/http/cache/RxCache$Builder;", "(Lcom/tiamosu/fly/http/cache/RxCache$Builder;)V", "appVersion", "", "getAppVersion", "()I", "cacheCore", "Lcom/tiamosu/fly/http/cache/core/CacheCore;", "getCacheCore", "()Lcom/tiamosu/fly/http/cache/core/CacheCore;", "setCacheCore", "(Lcom/tiamosu/fly/http/cache/core/CacheCore;)V", "cacheKey", "", "getCacheKey", "()Ljava/lang/String;", "cacheTime", "", "getCacheTime", "()J", "diskConverter", "Lcom/tiamosu/fly/http/cache/converter/IDiskConverter;", "getDiskConverter", "()Lcom/tiamosu/fly/http/cache/converter/IDiskConverter;", "diskDir", "Ljava/io/File;", "getDiskDir", "()Ljava/io/File;", "diskMaxSize", "getDiskMaxSize", "clear", "Lio/reactivex/rxjava3/core/Observable;", "", "containsKey", "key", "load", "T", "time", "loadStrategy", "Lcom/tiamosu/fly/http/cache/stategy/IStrategy;", "cacheMode", "Lcom/tiamosu/fly/http/cache/model/CacheMode;", "newBuilder", "remove", "save", "value", "(Ljava/lang/String;Ljava/lang/Object;)Lio/reactivex/rxjava3/core/Observable;", "transformer", "Lio/reactivex/rxjava3/core/ObservableTransformer;", "Lcom/tiamosu/fly/http/cache/model/CacheResult;", "Builder", "SimpleSubscribe", "fly-http_release"})
public final class RxCache {
    @Nullable
    private CacheCore cacheCore;
    @Nullable
    private final String cacheKey;
    private final long cacheTime;
    @Nullable
    private final IDiskConverter diskConverter;
    @Nullable
    private final File diskDir;
    private final int appVersion;
    private final long diskMaxSize;

    @Nullable
    public final CacheCore getCacheCore() {
        return this.cacheCore;
    }

    public final void setCacheCore(@Nullable CacheCore cacheCore) {
        this.cacheCore = cacheCore;
    }

    @Nullable
    public final String getCacheKey() {
        return this.cacheKey;
    }

    public final long getCacheTime() {
        return this.cacheTime;
    }

    @Nullable
    public final IDiskConverter getDiskConverter() {
        return this.diskConverter;
    }

    @Nullable
    public final File getDiskDir() {
        return this.diskDir;
    }

    public final int getAppVersion() {
        return this.appVersion;
    }

    public final long getDiskMaxSize() {
        return this.diskMaxSize;
    }

    public RxCache() {
        this(new Builder());
    }

    public RxCache(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.cacheKey = builder.getCachekey();
        this.cacheTime = builder.getCacheTime();
        this.diskDir = builder.getDiskDir();
        this.appVersion = builder.getAppVersion();
        this.diskMaxSize = builder.getDiskMaxSize();
        this.diskConverter = builder.getDiskConverter();
        if (this.diskConverter != null && this.diskDir != null) {
            this.cacheCore = new CacheCore(new LruDiskCache(this.diskConverter, this.diskDir, this.appVersion, this.diskMaxSize));
        }
    }

    @NotNull
    public final Builder newBuilder() {
        return new Builder(this);
    }

    @NotNull
    public final <T> ObservableTransformer<T, CacheResult<T>> transformer(@NotNull CacheMode cacheMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)cacheMode), (String)"cacheMode");
        IStrategy strategy = this.loadStrategy(cacheMode);
        return arg_0 -> RxCache.transformer$lambda-0(this, strategy, arg_0);
    }

    @NotNull
    public final <T> Observable<T> load(@Nullable String key) {
        return this.load(key, -1L);
    }

    @NotNull
    public final <T> Observable<T> load(@Nullable String key, long time) {
        Observable observable = Observable.create((ObservableOnSubscribe)new SimpleSubscribe<T>(this, key, time){
            final /* synthetic */ RxCache this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ long $time;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$time = $time;
            }

            @Nullable
            public T execute() {
                CacheCore cacheCore = this.this$0.getCacheCore();
                return cacheCore != null ? (T)cacheCore.load(this.$key, this.$time) : null;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"fun <T : Any> load(key: \u2026       }\n        })\n    }");
        return observable;
    }

    @NotNull
    public final <T> Observable<Boolean> save(@Nullable String key, T value) {
        Observable observable = Observable.create((ObservableOnSubscribe)new SimpleSubscribe<Boolean>(this, key, value){
            final /* synthetic */ RxCache this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ T $value;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$value = $value;
            }

            @NotNull
            public Boolean execute() throws Throwable {
                block0: {
                    CacheCore cacheCore = this.this$0.getCacheCore();
                    if (cacheCore == null) break block0;
                    cacheCore.save(this.$key, this.$value);
                }
                return true;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"fun <T> save(key: String\u2026       }\n        })\n    }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> containsKey(@Nullable String key) {
        Observable observable = Observable.create((ObservableOnSubscribe)new SimpleSubscribe<Boolean>(this, key){
            final /* synthetic */ RxCache this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
            }

            @NotNull
            public Boolean execute() throws Throwable {
                CacheCore cacheCore = this.this$0.getCacheCore();
                if (cacheCore == null) {
                    return false;
                }
                return cacheCore.containsKey(this.$key);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"fun containsKey(key: Str\u2026       }\n        })\n    }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> remove(@Nullable String key) {
        Observable observable = Observable.create((ObservableOnSubscribe)new SimpleSubscribe<Boolean>(this, key){
            final /* synthetic */ RxCache this$0;
            final /* synthetic */ String $key;
            {
                this.this$0 = $receiver;
                this.$key = $key;
            }

            @NotNull
            public Boolean execute() throws Throwable {
                CacheCore cacheCore = this.this$0.getCacheCore();
                if (cacheCore == null) {
                    return false;
                }
                return cacheCore.remove(this.$key);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"fun remove(key: String?)\u2026       }\n        })\n    }");
        return observable;
    }

    @NotNull
    public final Observable<Boolean> clear() {
        Observable observable = Observable.create((ObservableOnSubscribe)new SimpleSubscribe<Boolean>(this){
            final /* synthetic */ RxCache this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Boolean execute() throws Throwable {
                CacheCore cacheCore = this.this$0.getCacheCore();
                if (cacheCore == null) {
                    return false;
                }
                return cacheCore.clear();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"fun clear(): Observable<\u2026       }\n        })\n    }");
        return observable;
    }

    private final IStrategy loadStrategy(CacheMode cacheMode) {
        IStrategy iStrategy;
        try {
            Package package_ = IStrategy.class.getPackage();
            String pkName = package_ != null ? package_.getName() : null;
            Object obj = Class.forName(pkName + "." + cacheMode.getClassName()).newInstance();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type com.tiamosu.fly.http.cache.stategy.IStrategy");
            iStrategy = (IStrategy)obj;
        }
        catch (Exception e) {
            throw new RuntimeException("loadStrategy(" + cacheMode + ") err!!" + e.getMessage());
        }
        return iStrategy;
    }

    private static final ObservableSource transformer$lambda-0(RxCache this$0, IStrategy $strategy, Observable upstream) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$strategy, (String)"$strategy");
        FlyHttpLog.INSTANCE.iLog("cacheKey=" + this$0.cacheKey);
        String string = this$0.cacheKey;
        long l = this$0.cacheTime;
        Intrinsics.checkNotNullExpressionValue((Object)upstream, (String)"upstream");
        return (ObservableSource)$strategy.execute(this$0, string, l, upstream);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\u0005\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/tiamosu/fly/http/cache/RxCache$SimpleSubscribe;", "T", "", "Lio/reactivex/rxjava3/core/ObservableOnSubscribe;", "()V", "execute", "()Ljava/lang/Object;", "subscribe", "", "subscriber", "Lio/reactivex/rxjava3/core/ObservableEmitter;", "fly-http_release"})
    private static abstract class SimpleSubscribe<T>
    implements ObservableOnSubscribe<T> {
        public void subscribe(@NotNull ObservableEmitter<T> subscriber) throws Exception {
            Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
            try {
                T data = this.execute();
                if (!subscriber.isDisposed()) {
                    if (data == null) {
                        subscriber.onError((Throwable)new NullPointerException());
                        return;
                    }
                    subscriber.onNext(data);
                }
            }
            catch (Throwable e) {
                FlyHttpLog.INSTANCE.eLog(e.getMessage());
                if (!subscriber.isDisposed()) {
                    subscriber.onError(e);
                }
                Exceptions.throwIfFatal((Throwable)e);
                return;
            }
            if (!subscriber.isDisposed()) {
                subscriber.onComplete();
            }
        }

        @Nullable
        public abstract T execute() throws Throwable;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u0000 .2\u00020\u0001:\u0001.B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020\u0004J\u0010\u0010(\u001a\u00020\u00002\b\u0010(\u001a\u0004\u0018\u00010\u0013J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010)\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001e\u001a\u00020\u00002\b\u0010*\u001a\u0004\u0018\u00010\u001fJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\rJ\u0006\u0010-\u001a\u00020\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u000f\"\u0004\b&\u0010\u0011\u00a8\u0006/"}, d2={"Lcom/tiamosu/fly/http/cache/RxCache$Builder;", "", "()V", "rxCache", "Lcom/tiamosu/fly/http/cache/RxCache;", "(Lcom/tiamosu/fly/http/cache/RxCache;)V", "appVersion", "", "getAppVersion", "()I", "setAppVersion", "(I)V", "cacheTime", "", "getCacheTime", "()J", "setCacheTime", "(J)V", "cachekey", "", "getCachekey", "()Ljava/lang/String;", "setCachekey", "(Ljava/lang/String;)V", "diskConverter", "Lcom/tiamosu/fly/http/cache/converter/IDiskConverter;", "getDiskConverter", "()Lcom/tiamosu/fly/http/cache/converter/IDiskConverter;", "setDiskConverter", "(Lcom/tiamosu/fly/http/cache/converter/IDiskConverter;)V", "diskDir", "Ljava/io/File;", "getDiskDir", "()Ljava/io/File;", "setDiskDir", "(Ljava/io/File;)V", "diskMaxSize", "getDiskMaxSize", "setDiskMaxSize", "build", "cacheKey", "converter", "directory", "diskMax", "maxSize", "init", "Companion", "fly-http_release"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int appVersion;
        private long diskMaxSize;
        @Nullable
        private File diskDir;
        @Nullable
        private IDiskConverter diskConverter;
        @Nullable
        private String cachekey;
        private long cacheTime;
        private static final int MIN_DISK_CACHE_SIZE = 0x500000;
        private static final int MAX_DISK_CACHE_SIZE = 0x3200000;
        private static final long CACHE_NEVER_EXPIRE = -1L;

        public final int getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(int n) {
            this.appVersion = n;
        }

        public final long getDiskMaxSize() {
            return this.diskMaxSize;
        }

        public final void setDiskMaxSize(long l) {
            this.diskMaxSize = l;
        }

        @Nullable
        public final File getDiskDir() {
            return this.diskDir;
        }

        public final void setDiskDir(@Nullable File file) {
            this.diskDir = file;
        }

        @Nullable
        public final IDiskConverter getDiskConverter() {
            return this.diskConverter;
        }

        public final void setDiskConverter(@Nullable IDiskConverter iDiskConverter) {
            this.diskConverter = iDiskConverter;
        }

        @Nullable
        public final String getCachekey() {
            return this.cachekey;
        }

        public final void setCachekey(@Nullable String string) {
            this.cachekey = string;
        }

        public final long getCacheTime() {
            return this.cacheTime;
        }

        public final void setCacheTime(long l) {
            this.cacheTime = l;
        }

        public Builder() {
            this.diskConverter = new SerializableDiskConverter();
            this.cacheTime = -1L;
            this.appVersion = 1;
        }

        public Builder(@NotNull RxCache rxCache2) {
            Intrinsics.checkNotNullParameter((Object)rxCache2, (String)"rxCache");
            this.appVersion = rxCache2.getAppVersion();
            this.diskMaxSize = rxCache2.getDiskMaxSize();
            this.diskDir = rxCache2.getDiskDir();
            this.diskConverter = rxCache2.getDiskConverter();
            this.cachekey = rxCache2.getCacheKey();
            this.cacheTime = rxCache2.getCacheTime();
        }

        @NotNull
        public final Builder init() {
            return this;
        }

        @NotNull
        public final Builder appVersion(int appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        @NotNull
        public final Builder diskDir(@Nullable File directory) {
            this.diskDir = directory;
            return this;
        }

        @NotNull
        public final Builder diskConverter(@Nullable IDiskConverter converter) {
            this.diskConverter = converter;
            return this;
        }

        @NotNull
        public final Builder diskMax(long maxSize) {
            this.diskMaxSize = maxSize;
            return this;
        }

        @NotNull
        public final Builder cacheKey(@Nullable String cacheKey) {
            this.cachekey = cacheKey;
            return this;
        }

        @NotNull
        public final Builder cacheTime(long cacheTime) {
            this.cacheTime = cacheTime;
            return this;
        }

        @NotNull
        public final RxCache build() {
            IDiskConverter iDiskConverter;
            File file = this.diskDir;
            if (file == null) {
                file = this.diskDir = FlyHttp.Companion.getCacheDirectory();
            }
            if ((iDiskConverter = this.diskConverter) == null) {
                iDiskConverter = this.diskConverter = (IDiskConverter)new SerializableDiskConverter();
            }
            if (this.diskMaxSize <= 0L && this.diskDir != null) {
                File file2 = this.diskDir;
                Intrinsics.checkNotNull((Object)file2);
                this.diskMaxSize = Builder.Companion.calculateDiskCacheSize(file2);
            }
            this.cacheTime = RangesKt.coerceAtLeast((long)-1L, (long)this.cacheTime);
            this.appVersion = RangesKt.coerceAtLeast((int)1, (int)this.appVersion);
            return new RxCache(this);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/tiamosu/fly/http/cache/RxCache$Builder$Companion;", "", "()V", "CACHE_NEVER_EXPIRE", "", "MAX_DISK_CACHE_SIZE", "", "MIN_DISK_CACHE_SIZE", "calculateDiskCacheSize", "dir", "Ljava/io/File;", "fly-http_release"})
        public static final class Companion {
            private Companion() {
            }

            private final long calculateDiskCacheSize(File dir) {
                long size = 0L;
                try {
                    StatFs statFs = new StatFs(dir.getAbsolutePath());
                    long available = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
                    size = available / (long)50;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return RangesKt.coerceAtLeast((long)RangesKt.coerceAtMost((long)size, (long)0x3200000L), (long)0x500000L);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

