/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.fly.http.cache.core;

import com.tiamosu.fly.http.cache.core.LruDiskCache;
import com.tiamosu.fly.http.utils.FlyHttpLog;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tJ%\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\u0004\b\u0000\u0010\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tJ#\u0010\u0010\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u0002H\u000b\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/tiamosu/fly/http/cache/core/CacheCore;", "", "disk", "Lcom/tiamosu/fly/http/cache/core/LruDiskCache;", "(Lcom/tiamosu/fly/http/cache/core/LruDiskCache;)V", "clear", "", "containsKey", "key", "", "load", "T", "time", "", "(Ljava/lang/String;J)Ljava/lang/Object;", "remove", "save", "value", "(Ljava/lang/String;Ljava/lang/Object;)Z", "fly-http_release"})
public final class CacheCore {
    @NotNull
    private final LruDiskCache disk;

    public CacheCore(@NotNull LruDiskCache disk) {
        Intrinsics.checkNotNullParameter((Object)disk, (String)"disk");
        this.disk = disk;
    }

    @Nullable
    public final synchronized <T> T load(@Nullable String key, long time) {
        String string;
        String string2 = key;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            byte[] byArray = it.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            string = ByteString.Companion.of(Arrays.copyOf(byArray2, byArray2.length)).md5().hex();
        } else {
            string = null;
        }
        String cacheKey = string;
        FlyHttpLog.INSTANCE.dLog("loadCache  key=" + cacheKey);
        return this.disk.load(cacheKey, time);
    }

    public final synchronized <T> boolean save(@Nullable String key, T value) {
        String string;
        String string2 = key;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            byte[] byArray = it.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            string = ByteString.Companion.of(Arrays.copyOf(byArray2, byArray2.length)).md5().hex();
        } else {
            string = null;
        }
        String cacheKey = string;
        FlyHttpLog.INSTANCE.dLog("saveCache  key=" + cacheKey);
        return this.disk.save(cacheKey, value);
    }

    public final synchronized boolean containsKey(@Nullable String key) {
        String string;
        String string2 = key;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            byte[] byArray = it.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            string = ByteString.Companion.of(Arrays.copyOf(byArray2, byArray2.length)).md5().hex();
        } else {
            string = null;
        }
        String cacheKey = string;
        FlyHttpLog.INSTANCE.dLog("containsCache  key=" + cacheKey);
        return this.disk.containsKey(cacheKey);
    }

    public final synchronized boolean remove(@Nullable String key) {
        String string;
        String string2 = key;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            byte[] byArray = it.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            string = ByteString.Companion.of(Arrays.copyOf(byArray2, byArray2.length)).md5().hex();
        } else {
            string = null;
        }
        String cacheKey = string;
        FlyHttpLog.INSTANCE.dLog("removeCache  key=" + cacheKey);
        return this.disk.remove(cacheKey);
    }

    public final synchronized boolean clear() {
        return this.disk.clear();
    }
}

