/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.fly.http.cache.core;

import com.blankj.utilcode.util.CloseUtils;
import com.jakewharton.disklrucache.DiskLruCache;
import com.tiamosu.fly.http.cache.converter.IDiskConverter;
import com.tiamosu.fly.http.cache.core.BaseCache;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\u001f\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\u0004\b\u0000\u0010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J%\u0010\u001b\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001c\u001a\u0002H\u0018H\u0014\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\tH\u0002J\u001a\u0010!\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/tiamosu/fly/http/cache/core/LruDiskCache;", "Lcom/tiamosu/fly/http/cache/core/BaseCache;", "diskConverter", "Lcom/tiamosu/fly/http/cache/converter/IDiskConverter;", "diskDir", "Ljava/io/File;", "appVersion", "", "diskMaxSize", "", "(Lcom/tiamosu/fly/http/cache/converter/IDiskConverter;Ljava/io/File;IJ)V", "diskLruCache", "Lcom/jakewharton/disklrucache/DiskLruCache;", "kotlin.jvm.PlatformType", "getDiskLruCache", "()Lcom/jakewharton/disklrucache/DiskLruCache;", "diskLruCache$delegate", "Lkotlin/Lazy;", "doClear", "", "doContainsKey", "key", "", "doLoad", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "doRemove", "doSave", "value", "(Ljava/lang/String;Ljava/lang/Object;)Z", "isCacheDataFailure", "dataFile", "time", "isExpiry", "existTime", "fly-http_release"})
public final class LruDiskCache
extends BaseCache {
    @NotNull
    private final IDiskConverter diskConverter;
    @NotNull
    private final Lazy diskLruCache$delegate;

    public LruDiskCache(@NotNull IDiskConverter diskConverter, @NotNull File diskDir, int appVersion, long diskMaxSize) {
        Intrinsics.checkNotNullParameter((Object)diskConverter, (String)"diskConverter");
        Intrinsics.checkNotNullParameter((Object)diskDir, (String)"diskDir");
        this.diskConverter = diskConverter;
        this.diskLruCache$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DiskLruCache>(diskDir, appVersion, diskMaxSize){
            final /* synthetic */ File $diskDir;
            final /* synthetic */ int $appVersion;
            final /* synthetic */ long $diskMaxSize;
            {
                this.$diskDir = $diskDir;
                this.$appVersion = $appVersion;
                this.$diskMaxSize = $diskMaxSize;
                super(0);
            }

            public final DiskLruCache invoke() {
                return DiskLruCache.open((File)this.$diskDir, (int)this.$appVersion, (int)1, (long)this.$diskMaxSize);
            }
        }));
    }

    private final DiskLruCache getDiskLruCache() {
        Lazy lazy = this.diskLruCache$delegate;
        return (DiskLruCache)lazy.getValue();
    }

    @Override
    @Nullable
    protected <T> T doLoad(@Nullable String key) {
        if (this.getDiskLruCache() == null) {
            return null;
        }
        try {
            DiskLruCache.Editor editor = this.getDiskLruCache().edit(key);
            if (editor == null) {
                return null;
            }
            DiskLruCache.Editor edit = editor;
            InputStream source = edit.newInputStream(0);
            T value = null;
            if (source != null) {
                value = this.diskConverter.load(source);
                Closeable[] closeableArray = new Closeable[]{source};
                CloseUtils.closeIO((Closeable[])closeableArray);
                edit.commit();
                return value;
            }
            edit.abort();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    protected <T> boolean doSave(@Nullable String key, T value) {
        if (this.getDiskLruCache() == null) {
            return false;
        }
        try {
            DiskLruCache.Editor editor = this.getDiskLruCache().edit(key);
            if (editor == null) {
                return false;
            }
            DiskLruCache.Editor edit = editor;
            OutputStream sink = edit.newOutputStream(0);
            if (sink != null) {
                boolean result = this.diskConverter.writer(sink, value);
                Closeable[] closeableArray = new Closeable[]{sink};
                CloseUtils.closeIO((Closeable[])closeableArray);
                edit.commit();
                return result;
            }
            edit.abort();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    protected boolean doContainsKey(@Nullable String key) {
        if (this.getDiskLruCache() == null) {
            return false;
        }
        try {
            return this.getDiskLruCache().get(key) != null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected boolean doRemove(@Nullable String key) {
        if (this.getDiskLruCache() == null) {
            return false;
        }
        try {
            return this.getDiskLruCache().remove(key);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected boolean doClear() {
        boolean state = false;
        try {
            DiskLruCache diskLruCache2 = this.getDiskLruCache();
            if (diskLruCache2 != null) {
                diskLruCache2.delete();
            }
            state = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return state;
    }

    @Override
    protected boolean isExpiry(@Nullable String key, long existTime) {
        if (this.getDiskLruCache() == null) {
            return false;
        }
        if (existTime > -1L) {
            File file = new File(this.getDiskLruCache().getDirectory(), key + ".0");
            return this.isCacheDataFailure(file, existTime);
        }
        return false;
    }

    private final boolean isCacheDataFailure(File dataFile, long time) {
        if (!dataFile.exists()) {
            return false;
        }
        long existTime = System.currentTimeMillis() - dataFile.lastModified();
        return existTime > time * (long)1000;
    }
}

