/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.fly.http.interceptors;

import com.tiamosu.fly.http.utils.FlyHttpLog;
import com.tiamosu.fly.http.utils.FlyHttpUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J(\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001aH&J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001bH\u0002J\u0013\u0010#\u001a\u00028\u00002\u0006\u0010#\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010$\u001a\u00028\u00002\u0006\u0010$\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0014R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/tiamosu/fly/http/interceptors/BaseDynamicInterceptor;", "R", "Lokhttp3/Interceptor;", "()V", "httpUrl", "Lokhttp3/HttpUrl;", "getHttpUrl", "()Lokhttp3/HttpUrl;", "setHttpUrl", "(Lokhttp3/HttpUrl;)V", "isAccessToken", "", "()Z", "setAccessToken", "(Z)V", "isSign", "setSign", "isTimeStamp", "setTimeStamp", "accessToken", "(Z)Lcom/tiamosu/fly/http/interceptors/BaseDynamicInterceptor;", "addGetParamsSign", "Lokhttp3/Request;", "request", "addPostParamsSign", "dynamic", "Ljava/util/TreeMap;", "", "dynamicMap", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "parseUrl", "url", "sign", "timeStamp", "fly-http_release"})
public abstract class BaseDynamicInterceptor<R extends BaseDynamicInterceptor<R>>
implements Interceptor {
    @Nullable
    private HttpUrl httpUrl;
    private boolean isSign;
    private boolean isTimeStamp;
    private boolean isAccessToken;

    @Nullable
    protected final HttpUrl getHttpUrl() {
        return this.httpUrl;
    }

    protected final void setHttpUrl(@Nullable HttpUrl httpUrl) {
        this.httpUrl = httpUrl;
    }

    protected final boolean isSign() {
        return this.isSign;
    }

    protected final void setSign(boolean bl) {
        this.isSign = bl;
    }

    protected final boolean isTimeStamp() {
        return this.isTimeStamp;
    }

    protected final void setTimeStamp(boolean bl) {
        this.isTimeStamp = bl;
    }

    protected final boolean isAccessToken() {
        return this.isAccessToken;
    }

    protected final void setAccessToken(boolean bl) {
        this.isAccessToken = bl;
    }

    @NotNull
    public final R sign(boolean sign) {
        this.isSign = sign;
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type R of com.tiamosu.fly.http.interceptors.BaseDynamicInterceptor");
        return (R)this;
    }

    @NotNull
    public final R timeStamp(boolean timeStamp) {
        this.isTimeStamp = timeStamp;
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type R of com.tiamosu.fly.http.interceptors.BaseDynamicInterceptor");
        return (R)this;
    }

    @NotNull
    public final R accessToken(boolean accessToken) {
        this.isAccessToken = accessToken;
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type R of com.tiamosu.fly.http.interceptors.BaseDynamicInterceptor");
        return (R)this;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        if (Intrinsics.areEqual((Object)request.method(), (Object)"GET")) {
            String string = request.url().url().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.url.toUrl().toString()");
            this.httpUrl = HttpUrl.Companion.parse(this.parseUrl(string));
            request = this.addGetParamsSign(request);
        } else if (Intrinsics.areEqual((Object)request.method(), (Object)"POST")) {
            this.httpUrl = request.url();
            request = this.addPostParamsSign(request);
        }
        return chain.proceed(request);
    }

    private final Request addGetParamsSign(Request request) throws UnsupportedEncodingException {
        Request newRequest = request;
        HttpUrl httpUrl = newRequest.url();
        HttpUrl.Builder newBuilder = httpUrl.newBuilder();
        Set nameSet = httpUrl.queryParameterNames();
        ArrayList nameList = new ArrayList();
        nameList.addAll(nameSet);
        TreeMap<String, String> oldParams = new TreeMap<String, String>();
        int n = nameList.size();
        for (int i = 0; i < n; ++i) {
            String string;
            Object e = nameList.get(i);
            Intrinsics.checkNotNullExpressionValue(e, (String)"nameList[i]");
            List values = httpUrl.queryParameterValues((String)e);
            if (!((Collection)values).isEmpty()) {
                string = (String)values.get(0);
                if (string == null) {
                    string = "";
                }
            } else {
                string = "";
            }
            String value = string;
            Map map = oldParams;
            Object e2 = nameList.get(i);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"nameList[i]");
            map.put(e2, value);
        }
        String nameKeys = CollectionsKt.listOf(nameList).toString();
        TreeMap<String, String> newParams = this.dynamic(oldParams);
        for (Map.Entry entry : ((Map)newParams).entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            String urlValue = URLEncoder.encode(value, FlyHttpUtils.getUTF8().name());
            if (StringsKt.contains$default((CharSequence)nameKeys, (CharSequence)key, (boolean)false, (int)2, null)) continue;
            newBuilder.addQueryParameter(key, urlValue);
        }
        httpUrl = newBuilder.build();
        newRequest = newRequest.newBuilder().url(httpUrl).build();
        return newRequest;
    }

    private final Request addPostParamsSign(Request request) throws UnsupportedEncodingException {
        Request newRequest = request;
        if (newRequest.body() instanceof FormBody) {
            FormBody.Builder bodyBuilder = new FormBody.Builder(null, 1, null);
            RequestBody requestBody = newRequest.body();
            Intrinsics.checkNotNull((Object)requestBody, (String)"null cannot be cast to non-null type okhttp3.FormBody");
            FormBody formBody = (FormBody)requestBody;
            TreeMap<String, String> oldParams = new TreeMap<String, String>();
            int n = formBody.size();
            for (int i = 0; i < n; ++i) {
                ((Map)oldParams).put(formBody.encodedName(i), formBody.encodedValue(i));
            }
            TreeMap<String, String> newParams = this.dynamic(oldParams);
            for (Map.Entry entry : ((Map)newParams).entrySet()) {
                String key = (String)entry.getKey();
                String value1 = (String)entry.getValue();
                String value = URLDecoder.decode(value1, FlyHttpUtils.getUTF8().name());
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                bodyBuilder.addEncoded(key, value);
            }
            HttpUrl httpUrl = this.httpUrl;
            if (httpUrl != null) {
                HttpUrl it = httpUrl;
                boolean bl = false;
                String string = it.url().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toUrl().toString()");
                String url = FlyHttpUtils.createUrlFromParams$default(string, newParams, false, 4, null);
                FlyHttpLog.INSTANCE.iLog(url);
            }
            formBody = bodyBuilder.build();
            newRequest = newRequest.newBuilder().post((RequestBody)formBody).build();
        } else if (newRequest.body() instanceof MultipartBody) {
            RequestBody requestBody = newRequest.body();
            Intrinsics.checkNotNull((Object)requestBody, (String)"null cannot be cast to non-null type okhttp3.MultipartBody");
            MultipartBody multipartBody = (MultipartBody)requestBody;
            MultipartBody.Builder bodyBuilder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
            List oldParts = multipartBody.parts();
            List newParts = new ArrayList(oldParts);
            TreeMap<String, String> oldParams = new TreeMap<String, String>();
            TreeMap<String, String> newParams = this.dynamic(oldParams);
            for (Map.Entry bl : ((Map)newParams).entrySet()) {
                String key = (String)bl.getKey();
                String value = (String)bl.getValue();
                MultipartBody.Part part = MultipartBody.Part.Companion.createFormData(key, value);
                newParts.add(part);
            }
            for (MultipartBody.Part part : newParts) {
                bodyBuilder.addPart(part);
            }
            multipartBody = bodyBuilder.build();
            newRequest = newRequest.newBuilder().post((RequestBody)multipartBody).build();
        }
        return newRequest;
    }

    private final String parseUrl(String url) {
        String newUrl = url;
        if (!Intrinsics.areEqual((Object)"", (Object)newUrl) && StringsKt.contains$default((CharSequence)newUrl, (CharSequence)"?", (boolean)false, (int)2, null)) {
            String string = newUrl.substring(0, StringsKt.indexOf$default((CharSequence)newUrl, (char)'?', (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            newUrl = string;
        }
        return newUrl;
    }

    @NotNull
    public abstract TreeMap<String, String> dynamic(@NotNull TreeMap<String, String> var1);
}

