/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.fly.http.interceptors;

import com.tiamosu.fly.http.utils.FlyHttpLog;
import com.tiamosu.fly.http.utils.FlyHttpUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&J\u0012\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH&\u00a8\u0006\u0010"}, d2={"Lcom/tiamosu/fly/http/interceptors/BaseExpiredInterceptor;", "Lokhttp3/Interceptor;", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "isResponseExpired", "", "response", "bodyString", "", "isText", "mediaType", "Lokhttp3/MediaType;", "responseExpired", "fly-http_release"})
public abstract class BaseExpiredInterceptor
implements Interceptor {
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Buffer buffer;
        MediaType contentType;
        BufferedSource source;
        ResponseBody responseBody;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Response response = chain.proceed(request);
        ResponseBody responseBody2 = responseBody = response.body();
        BufferedSource bufferedSource = source = responseBody2 != null ? responseBody2.source() : null;
        if (bufferedSource != null) {
            bufferedSource.request(Long.MAX_VALUE);
        }
        BufferedSource bufferedSource2 = source;
        Buffer buffer2 = bufferedSource2 != null ? bufferedSource2.getBuffer() : null;
        Charset charset = FlyHttpUtils.getUTF8();
        ResponseBody responseBody3 = responseBody;
        Object object = contentType = responseBody3 != null ? responseBody3.contentType() : null;
        if (contentType != null) {
            Charset charset2 = contentType.charset(FlyHttpUtils.getUTF8());
            Intrinsics.checkNotNull((Object)charset2);
            charset = charset2;
        }
        String bodyString = (buffer = buffer2) != null && (buffer = buffer.clone()) != null ? buffer.readString(charset) : null;
        FlyHttpLog.INSTANCE.iLog("\u7f51\u7edc\u62e6\u622a\u5668:" + bodyString + " host:" + request.url());
        boolean isText = this.isText(contentType);
        if (!isText) {
            return response;
        }
        return this.isResponseExpired(response, bodyString) ? this.responseExpired(chain, bodyString) : response;
    }

    private final boolean isText(MediaType mediaType) {
        block3: {
            block2: {
                MediaType mediaType2 = mediaType;
                if (Intrinsics.areEqual((Object)(mediaType2 != null ? mediaType2.type() : null), (Object)"text")) break block2;
                MediaType mediaType3 = mediaType;
                if (!Intrinsics.areEqual((Object)(mediaType3 != null ? mediaType3.subtype() : null), (Object)"json")) break block3;
            }
            return true;
        }
        return false;
    }

    public abstract boolean isResponseExpired(@NotNull Response var1, @Nullable String var2);

    @NotNull
    public abstract Response responseExpired(@NotNull Interceptor.Chain var1, @Nullable String var2);
}

