/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.fly.http.interceptors;

import com.blankj.utilcode.util.NetworkUtils;
import com.tiamosu.fly.http.interceptors.CacheInterceptor;
import com.tiamosu.fly.http.utils.FlyHttpLog;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/tiamosu/fly/http/interceptors/CacheInterceptorOffline;", "Lcom/tiamosu/fly/http/interceptors/CacheInterceptor;", "()V", "cacheControlValue", "", "(Ljava/lang/String;)V", "cacheOnlineControlValue", "(Ljava/lang/String;Ljava/lang/String;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "fly-http_release"})
public final class CacheInterceptorOffline
extends CacheInterceptor {
    public CacheInterceptorOffline() {
        super(null, 1, null);
    }

    public CacheInterceptorOffline(@Nullable String cacheControlValue) {
        super(cacheControlValue);
    }

    public CacheInterceptorOffline(@Nullable String cacheControlValue, @Nullable String cacheOnlineControlValue) {
        super(cacheControlValue, cacheOnlineControlValue);
    }

    @Override
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        if (!NetworkUtils.isConnected()) {
            FlyHttpLog.INSTANCE.iLog(" no network load cache:" + request.cacheControl());
            request = request.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
            Response response = chain.proceed(request);
            return response.newBuilder().removeHeader("Pragma").removeHeader("Cache-Control").header("Cache-Control", "public, only-if-cached, " + this.getCacheControlValueOffline()).build();
        }
        return chain.proceed(request);
    }
}

