/*
 * Decompiled with CFR 0.152.
 */
package com.tiamosu.fly.http.utils;

import com.tiamosu.fly.http.model.HttpParams;
import com.tiamosu.fly.http.utils.FlyHttpUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a2\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u0002H\u000e0\n\"\u0004\b\u0000\u0010\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u0001H\u000e\u0018\u00010\n\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u001a\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001c"}, d2={"UTF8", "Ljava/nio/charset/Charset;", "getUTF8", "()Ljava/nio/charset/Charset;", "UTF8$delegate", "Lkotlin/Lazy;", "createUrlFromParams", "", "url", "params", "", "isEncode", "", "escapeParams", "V", "map", "guessMimeType", "Lokhttp3/MediaType;", "fileName", "toByteArray", "", "input", "Ljava/io/InputStream;", "write", "", "inputStream", "outputStream", "Ljava/io/OutputStream;", "fly-http_release"})
@JvmName(name="FlyHttpUtils")
public final class FlyHttpUtils {
    @NotNull
    private static final Lazy UTF8$delegate = LazyKt.lazy((Function0)UTF8.2.INSTANCE);

    @NotNull
    public static final Charset getUTF8() {
        Lazy lazy = UTF8$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-UTF8>(...)");
        return (Charset)object;
    }

    @NotNull
    public static final <V> Map<String, V> escapeParams(@Nullable Map<String, ? extends V> map) {
        if (map == null || map.isEmpty()) {
            return MapsKt.emptyMap();
        }
        LinkedHashMap hashMap = new LinkedHashMap();
        for (Map.Entry<String, V> entry : map.entrySet()) {
            String key = entry.getKey();
            V value = entry.getValue();
            if (key == null || value == null) continue;
            ((Map)hashMap).put(key, value);
        }
        return hashMap;
    }

    @NotNull
    public static final String createUrlFromParams(@NotNull String url, @NotNull Map<String, String> params, boolean isEncode) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        if (params.isEmpty()) {
            return url;
        }
        StringBuilder $this$createUrlFromParams_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createUrlFromParams_u24lambda_u2d0.append(url);
        if (StringsKt.indexOf$default((CharSequence)url, (char)'&', (int)0, (boolean)false, (int)6, null) > 0 || StringsKt.indexOf$default((CharSequence)url, (char)'?', (int)0, (boolean)false, (int)6, null) > 0) {
            $this$createUrlFromParams_u24lambda_u2d0.append("&");
        } else {
            $this$createUrlFromParams_u24lambda_u2d0.append("?");
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String value;
            String key = entry.getKey();
            String newValue = value = entry.getValue();
            if (isEncode) {
                String string = URLEncoder.encode(newValue, FlyHttpUtils.getUTF8().name());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(newValue, UTF8.name())");
                newValue = string;
            }
            $this$createUrlFromParams_u24lambda_u2d0.append(key).append("=").append(newValue).append("&");
        }
        if ($this$createUrlFromParams_u24lambda_u2d0.length() > 0) {
            $this$createUrlFromParams_u24lambda_u2d0.deleteCharAt($this$createUrlFromParams_u24lambda_u2d0.length() - 1);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply {\n\u2026       }\n    }.toString()");
        return string;
    }

    public static /* synthetic */ String createUrlFromParams$default(String string, Map map, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return FlyHttpUtils.createUrlFromParams(string, map, bl);
    }

    @Nullable
    public static final MediaType guessMimeType(@Nullable String fileName) {
        String string = fileName;
        if (string == null) {
            return HttpParams.Companion.getMEDIA_TYPE_STREAM();
        }
        String newFileName = string;
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        newFileName = StringsKt.replace$default((String)newFileName, (String)"#", (String)"", (boolean)false, (int)4, null);
        String string2 = fileNameMap.getContentTypeFor(newFileName);
        if (string2 == null) {
            return HttpParams.Companion.getMEDIA_TYPE_STREAM();
        }
        String contentType = string2;
        return MediaType.Companion.parse(contentType);
    }

    @Nullable
    public static final byte[] toByteArray(@Nullable InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FlyHttpUtils.write(input, output);
        output.close();
        return output.toByteArray();
    }

    private static final void write(InputStream inputStream, OutputStream outputStream) throws IOException {
        int len = 0;
        byte[] buffer = new byte[4096];
        while (true) {
            int n;
            int it = n = inputStream.read(buffer);
            boolean bl = false;
            len = it;
            if (n == -1) break;
            outputStream.write(buffer, 0, len);
        }
    }
}

