/*
 * Decompiled with CFR 0.152.
 */
package com.bastiaanjansen.otp;

import com.bastiaanjansen.otp.HMACAlgorithm;
import com.bastiaanjansen.otp.HOTPGenerator;
import com.bastiaanjansen.otp.HOTPVerifier;
import com.bastiaanjansen.otp.OTP;
import com.bastiaanjansen.otp.helpers.URIHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class HOTP
extends OTP
implements HOTPGenerator,
HOTPVerifier {
    private static final String OTP_TYPE = "hotp";

    private HOTP(Builder builder) {
        super(builder);
    }

    public static HOTP fromURI(URI uri) throws URISyntaxException {
        Map<String, String> query = URIHelper.queryItems(uri);
        byte[] secret = Optional.ofNullable(query.get("secret")).map(String::getBytes).orElseThrow(() -> new IllegalArgumentException("Secret query parameter must be set"));
        Builder builder = new Builder(secret);
        try {
            Optional.ofNullable(query.get("digits")).map(Integer::valueOf).ifPresent(builder::withPasswordLength);
            Optional.ofNullable(query.get("algorithm")).map(String::toUpperCase).map(HMACAlgorithm::valueOf).ifPresent(builder::withAlgorithm);
        }
        catch (Exception e) {
            throw new URISyntaxException(uri.toString(), "URI could not be parsed");
        }
        return builder.build();
    }

    public static HOTP withDefaultValues(byte[] secret) {
        return new Builder(secret).build();
    }

    @Override
    public String generate(long counter) throws IllegalArgumentException {
        return super.generate(counter);
    }

    public URI getURI(int counter, String issuer) throws URISyntaxException {
        return this.getURI(counter, issuer, "");
    }

    public URI getURI(int counter, String issuer, String account) throws URISyntaxException {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put("counter", String.valueOf(counter));
        return this.getURI(OTP_TYPE, issuer, account, query);
    }

    public static class Builder
    extends OTP.Builder<HOTP, Builder> {
        public Builder(byte[] secret) {
            super(secret);
        }

        @Override
        protected Builder getBuilder() {
            return this;
        }

        @Override
        public HOTP build() {
            return new HOTP(this);
        }
    }
}

