/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql;

import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.n3r.eql.EStmt;
import org.n3r.eql.EqlTran;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.impl.EqlRsRetriever;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.param.EqlParamsBinder;
import org.n3r.eql.util.Closes;
import org.slf4j.Logger;

public class ESelectStmt
implements Closeable,
EStmt {
    private ResultSet resultSet;
    private PreparedStatement preparedStatement;
    private boolean resultSetNext;
    private EqlRsRetriever rsRetriever;
    private int rowNum;
    private EqlRun eqlRun;
    private Logger logger;
    private Object[] params;
    private int fetchSize;

    public void executeQuery() {
        this.executeQuery(this.params);
    }

    public void executeQuery(Object ... params) {
        this.resultSetNext = true;
        this.rowNum = 0;
        try {
            this.eqlRun.setParams(params);
            new EqlParamsBinder().preparBindParams(this.eqlRun);
            this.eqlRun.bindParams(this.preparedStatement);
            this.resultSet = this.preparedStatement.executeQuery();
            if (this.fetchSize > 0) {
                this.resultSet.setFetchSize(this.fetchSize);
            }
        }
        catch (SQLException e) {
            throw new EqlExecuteException("executeQuery", e);
        }
    }

    public <T> T next() {
        if (!this.resultSetNext) {
            return null;
        }
        try {
            Object rowBean = this.rsRetriever.selectRow(this.resultSet, ++this.rowNum);
            if (rowBean == null) {
                this.resultSetNext = false;
                this.closeRs();
            }
            return (T)rowBean;
        }
        catch (SQLException e) {
            throw new EqlExecuteException("select row", e);
        }
    }

    public void closeRs() {
        Closes.closeQuietly(this.resultSet);
        this.resultSet = null;
    }

    @Override
    public void closeStmt() {
        Closes.closeQuietly(this.preparedStatement);
        this.preparedStatement = null;
    }

    @Override
    public void setPreparedStatment(PreparedStatement preparedStatement) {
        this.preparedStatement = preparedStatement;
    }

    public void setRsRetriever(EqlRsRetriever rsRetriever) {
        this.rsRetriever = rsRetriever;
    }

    @Override
    public void close() {
        this.closeRs();
        this.closeStmt();
    }

    @Override
    public void setEqlRun(EqlRun eqlRun) {
        this.eqlRun = eqlRun;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void setEqlTran(EqlTran eqlTran) {
    }

    @Override
    public void params(Object ... params) {
        this.params = params;
    }

    @Override
    public Object[] getParams() {
        return this.params;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }
}

