/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql;

import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.n3r.eql.EStmt;
import org.n3r.eql.EqlTran;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.param.EqlParamsBinder;
import org.n3r.eql.util.Closes;
import org.slf4j.Logger;

public class EUpdateStmt
implements Closeable,
EStmt {
    private boolean autoCommit = true;
    private PreparedStatement preparedStatement;
    private EqlRun eqlRun;
    private Logger logger;
    private EqlTran eqlTran;
    private Object[] params;

    @Override
    public void close() {
    }

    public int update() {
        return this.update(this.params);
    }

    public int update(Object ... params) {
        this.eqlRun.setParams(params);
        new EqlParamsBinder().preparBindParams(this.eqlRun);
        this.eqlRun.bindParams(this.preparedStatement);
        try {
            int ret = this.preparedStatement.executeUpdate();
            if (this.autoCommit && this.eqlTran != null) {
                this.eqlTran.commit();
            }
            return ret;
        }
        catch (SQLException e) {
            throw new EqlExecuteException("executeUpdate failed", e);
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void commit() {
        if (this.eqlTran != null) {
            this.eqlTran.commit();
        }
    }

    public void rollback() {
        if (this.eqlTran != null) {
            this.eqlTran.rollback();
        }
    }

    @Override
    public void setPreparedStatment(PreparedStatement preparedStatement) {
        this.preparedStatement = preparedStatement;
    }

    @Override
    public void setEqlRun(EqlRun eqlRun) {
        this.eqlRun = eqlRun;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void closeStmt() {
        Closes.closeQuietly(this.preparedStatement);
        this.preparedStatement = null;
    }

    @Override
    public void setEqlTran(EqlTran eqlTran) {
        this.eqlTran = eqlTran;
    }

    @Override
    public Object[] getParams() {
        return this.params;
    }

    @Override
    public void params(Object[] params) {
        this.params = params;
    }
}

