/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.n3r.eql.DbDialect;
import org.n3r.eql.ESelectStmt;
import org.n3r.eql.EStmt;
import org.n3r.eql.EUpdateStmt;
import org.n3r.eql.EqlPage;
import org.n3r.eql.EqlTran;
import org.n3r.eql.Eqll;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.config.EqlConfigCache;
import org.n3r.eql.config.EqlConfigDecorator;
import org.n3r.eql.config.EqlConfigManager;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.impl.DefaultEqlConfigDecorator;
import org.n3r.eql.impl.EqlBatch;
import org.n3r.eql.impl.EqlProc;
import org.n3r.eql.impl.EqlRsRetriever;
import org.n3r.eql.map.EqlRowMapper;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.map.EqlType;
import org.n3r.eql.param.EqlParamsBinder;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.util.C;
import org.n3r.eql.util.Closes;
import org.n3r.eql.util.HostAddress;
import org.n3r.eql.util.S;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Eql {
    public static final String DEFAULT_CONN_NAME = "DEFAULT";
    public static final int STACKTRACE_DEEP_FOUR = 4;
    public static final int STACKTRACE_DEEP_FIVE = 5;
    protected static Logger logger = LoggerFactory.getLogger(Eql.class);
    protected EqlConfigDecorator eqlConfig;
    protected EqlBlock eqlBlock;
    protected Object[] params;
    private String sqlClassPath;
    private EqlPage page;
    protected EqlBatch batch;
    protected Object[] dynamics;
    private EqlTran externalTran;
    private EqlTran internalTran;
    private DbDialect dbDialect;
    protected EqlRsRetriever rsRetriever = new EqlRsRetriever();
    private int fetchSize;
    protected List<EqlRun> eqlRuns;
    protected EqlRun currRun;
    protected Map<String, Object> executionContext;
    private String defaultSqlId;
    private boolean cached = true;

    public Eql() {
        this(5);
    }

    public Eql(int stackDeep) {
        EqlConfig localConfig = Eqll.eqlConfigLocal.get();
        if (localConfig == null) {
            this.init(EqlConfigCache.getEqlConfig(DEFAULT_CONN_NAME), stackDeep);
        } else {
            this.init(localConfig, stackDeep);
        }
    }

    public Eql(String connectionName) {
        this.init(EqlConfigCache.getEqlConfig(connectionName), 4);
    }

    public Eql(EqlConfig eqlConfig) {
        this.init(eqlConfig, 4);
    }

    public Eql(EqlConfig eqlConfig, int stackDeep) {
        this.init(eqlConfig, stackDeep);
    }

    private void init(EqlConfig eqlConfig, int stackDeep) {
        this.eqlConfig = eqlConfig instanceof EqlConfigDecorator ? (EqlConfigDecorator)eqlConfig : new DefaultEqlConfigDecorator(eqlConfig);
        this.prepareDefaultSqlId(stackDeep);
    }

    private void prepareDefaultSqlId(int stackDeep) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement e = stackTrace[stackDeep];
        this.defaultSqlId = e.getMethodName();
    }

    public Connection getConnection() {
        return Eql.newTran(this.eqlConfig, this).getConn();
    }

    protected Connection getConn() {
        Connection connection = this.internalTran != null ? this.internalTran.getConn() : this.externalTran.getConn();
        this.dbDialect = DbDialect.parseDbType(connection);
        this.executionContext.put("_databaseId", this.dbDialect.getDatabaseId());
        return connection;
    }

    public Eql addContext(String key, Object value) {
        this.executionContext.put(key, value);
        return this;
    }

    public List<EqlRun> evaluate(String ... directSqls) {
        this.checkPreconditions(directSqls);
        this.newExecutionContext();
        if (directSqls.length > 0) {
            this.eqlBlock = new EqlBlock();
        }
        List<EqlRun> runs = this.eqlBlock.createEqlRuns(this.eqlConfig, this.executionContext, this.params, this.dynamics, directSqls);
        if (logger.isDebugEnabled()) {
            for (EqlRun run : runs) {
                logger.debug(run.getPrintSql());
            }
        }
        return runs;
    }

    public <T> T execute(String ... directSqls) {
        this.checkPreconditions(directSqls);
        Object o = this.tryGetCache(directSqls);
        if (o != null) {
            return (T)o;
        }
        this.newExecutionContext();
        Object ret = null;
        try {
            if (this.batch == null) {
                this.tranStart();
            }
            Connection conn = this.getConn();
            if (directSqls.length > 0) {
                this.eqlBlock = new EqlBlock();
            }
            this.eqlRuns = this.eqlBlock.createEqlRuns(this.eqlConfig, this.executionContext, this.params, this.dynamics, directSqls);
            Iterator<EqlRun> i$ = this.eqlRuns.iterator();
            while (i$.hasNext()) {
                EqlRun eqlRun;
                this.currRun = eqlRun = i$.next();
                new EqlParamsBinder().preparBindParams(this.currRun);
                this.checkBatchCmdsSupporting(this.currRun);
                this.currRun.setConnection(conn);
                ret = this.runEql();
                this.currRun.setConnection(null);
                this.updateLastResultToExecutionContext(ret);
                this.currRun.setResult(ret);
                this.trySetCache(directSqls);
            }
            if (this.batch == null) {
                this.tranCommit();
            }
        }
        catch (SQLException e) {
            logger.error("sql exception", (Throwable)e);
            if (this.batch != null) {
                this.batch.cleanupBatch();
            }
            throw new EqlExecuteException("exec sql failed[" + this.currRun.getPrintSql() + "]" + e.getMessage());
        }
        finally {
            this.resetState();
            this.close();
        }
        return (T)ret;
    }

    private void trySetCache(String[] directSqls) {
        if (!this.isCachUsable(directSqls)) {
            return;
        }
        this.eqlBlock.cacheResult(this.currRun, this.page);
    }

    private Object tryGetCache(String[] directSqls) {
        if (!this.isCachUsable(directSqls)) {
            return null;
        }
        Optional<Object> cachedResult = this.eqlBlock.getCachedResult(this.params, this.dynamics, this.page);
        if (cachedResult == null) {
            return null;
        }
        return cachedResult.orNull();
    }

    private boolean isCachUsable(String[] directSqls) {
        return directSqls.length == 0 && this.cached;
    }

    private void checkBatchCmdsSupporting(EqlRun currRun) {
        if (this.batch == null) {
            return;
        }
        switch (currRun.getSqlType()) {
            case INSERT: 
            case UPDATE: 
            case MERGE: 
            case DELETE: {
                break;
            }
            default: {
                throw new EqlExecuteException(currRun.getPrintSql() + " is not supported in batch mode");
            }
        }
    }

    protected void updateLastResultToExecutionContext(Object ret) {
        Object lastResult = ret;
        if (ret instanceof List) {
            List list = (List)ret;
            if (list.size() == 0) {
                lastResult = null;
            } else if (list.size() == 1) {
                lastResult = list.get(0);
            }
        }
        this.executionContext.put("_lastResult", lastResult);
    }

    protected void newExecutionContext() {
        this.executionContext = Maps.newHashMap();
        this.executionContext.put("_time", new Timestamp(System.currentTimeMillis()));
        this.executionContext.put("_date", new Date());
        this.executionContext.put("_host", HostAddress.getHost());
        this.executionContext.put("_ip", HostAddress.getIp());
        this.executionContext.put("_results", Lists.newArrayList());
        this.executionContext.put("_lastResult", "");
        this.executionContext.put("_params", this.params);
        if (this.params != null) {
            this.executionContext.put("_paramsCount", this.params.length);
            for (int i = 0; i < this.params.length; ++i) {
                this.executionContext.put("_" + (i + 1), this.params[i]);
            }
        }
        this.executionContext.put("_dynamics", this.dynamics);
        if (this.dynamics != null) {
            this.executionContext.put("_dynamicsCount", this.dynamics.length);
        }
    }

    public List<EqlRun> getEqlRuns() {
        return this.eqlRuns;
    }

    protected void resetState() {
        this.rsRetriever.resetMaxRows();
    }

    public void close() {
        if (this.batch == null) {
            this.tranClose();
        }
    }

    public ESelectStmt selectStmt() {
        this.newExecutionContext();
        this.tranStart();
        Connection conn = this.getConn();
        List<EqlRun> sqlSubs = this.eqlBlock.createEqlRunsByEqls(this.eqlConfig, this.executionContext, this.params, this.dynamics);
        if (sqlSubs.size() != 1) {
            throw new EqlExecuteException("only one select sql supported");
        }
        this.currRun = sqlSubs.get(0);
        if (this.currRun.getSqlType() != EqlType.SELECT) {
            throw new EqlExecuteException("only one select sql supported");
        }
        this.currRun.setConnection(conn);
        ESelectStmt selectStmt = new ESelectStmt();
        this.prepareStmt(selectStmt);
        selectStmt.setRsRetriever(this.rsRetriever);
        selectStmt.setFetchSize(this.fetchSize);
        return selectStmt;
    }

    public EUpdateStmt updateStmt() {
        this.newExecutionContext();
        this.tranStart();
        Connection conn = this.getConn();
        List<EqlRun> sqlSubs = this.eqlBlock.createEqlRunsByEqls(this.eqlConfig, this.executionContext, this.params, this.dynamics);
        if (sqlSubs.size() != 1) {
            throw new EqlExecuteException("only one update sql supported in this method");
        }
        this.currRun = sqlSubs.get(0);
        if (!this.currRun.getSqlType().isUpdateStmt()) {
            throw new EqlExecuteException("only one update/merge/delete/insert sql supported in this method");
        }
        this.currRun.setConnection(conn);
        EUpdateStmt updateStmt = new EUpdateStmt();
        this.prepareStmt(updateStmt);
        return updateStmt;
    }

    protected void checkPreconditions(String ... directSqls) {
        if (this.eqlBlock != null || directSqls.length > 0) {
            return;
        }
        if (S.isBlank(this.defaultSqlId)) {
            throw new EqlExecuteException("No sqlid defined!");
        }
        this.initSqlId(this.defaultSqlId, 5);
    }

    protected Object runEql() throws SQLException {
        try {
            return this.currRun.getSqlType().isDdl() ? Boolean.valueOf(this.execDdl()) : this.pageExecute();
        }
        catch (Exception ex) {
            if (!this.currRun.getEqlBlock().isOnerrResume()) {
                throw Throwables.propagate((Throwable)ex);
            }
            logger.warn("execute sql {} error", (Object)this.currRun.getPrintSql(), (Object)ex);
            return 0;
        }
    }

    private boolean execDdl() {
        boolean bl;
        Statement stmt = null;
        logger.debug("ddl sql {}: {}", (Object)this.getSqlId(), (Object)this.currRun.getPrintSql());
        try {
            stmt = this.currRun.getConnection().createStatement();
            bl = stmt.execute(this.currRun.getRunSql());
        }
        catch (SQLException ex) {
            try {
                throw new EqlExecuteException(ex);
            }
            catch (Throwable throwable) {
                Closes.closeQuietly(stmt);
                throw throwable;
            }
        }
        Closes.closeQuietly(stmt);
        return bl;
    }

    private Object pageExecute() throws SQLException {
        if (this.page == null || !this.currRun.isLastSelectSql()) {
            return this.execDml();
        }
        if (this.page.getTotalRows() == 0) {
            this.page.setTotalRows(this.executeTotalRowsSql());
        }
        return this.executePageSql();
    }

    private Object executePageSql() throws SQLException {
        EqlRun temp = this.currRun;
        this.currRun = this.dbDialect.createPageSql(this.currRun, this.page);
        new EqlParamsBinder().preparBindParams(this.currRun);
        Object o = this.execDml();
        this.currRun = temp;
        return o;
    }

    private int executeTotalRowsSql() throws SQLException {
        EqlRun temp = this.currRun;
        this.currRun = this.dbDialect.createTotalSql(this.currRun);
        Object totalRows = this.execDml();
        this.currRun = temp;
        if (totalRows instanceof Number) {
            return ((Number)totalRows).intValue();
        }
        throw new EqlExecuteException("returned total rows object " + totalRows + " is not a number");
    }

    private Object execDml() throws SQLException {
        Object execRet = this.batch != null ? this.execDmlInBatch() : this.execDmlNoBatch();
        logger.debug("result {}: {}", (Object)this.getSqlId(), execRet);
        return execRet;
    }

    private Object execDmlInBatch() throws SQLException {
        return this.batch.addBatch(this.currRun);
    }

    private void prepareStmt(EStmt stmt) {
        PreparedStatement ps = null;
        try {
            ps = this.prepareSql();
            stmt.setPreparedStatment(ps);
            stmt.setEqlRun(this.currRun);
            stmt.setLogger(logger);
            stmt.params(this.params);
            stmt.setEqlTran(this.externalTran != null ? this.externalTran : this.internalTran);
        }
        catch (Exception ex) {
            Closes.closeQuietly(ps);
            throw new EqlExecuteException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execDmlNoBatch() throws SQLException {
        PreparedStatement ps;
        ResultSet rs;
        block6: {
            block5: {
                Object object;
                rs = null;
                ps = null;
                try {
                    ps = this.prepareSql();
                    this.currRun.bindParams(ps);
                    if (this.currRun.getSqlType() != EqlType.SELECT) break block5;
                    rs = ps.executeQuery();
                    if (this.fetchSize > 0) {
                        rs.setFetchSize(this.fetchSize);
                    }
                    object = this.rsRetriever.convert(rs, this.currRun);
                }
                catch (Throwable throwable) {
                    Closes.closeQuietly(rs, ps);
                    throw throwable;
                }
                Closes.closeQuietly(rs, ps);
                return object;
            }
            if (!this.currRun.getSqlType().isProcedure()) break block6;
            Object object = new EqlProc(this.currRun, this.rsRetriever).dealProcedure(ps);
            Closes.closeQuietly(rs, ps);
            return object;
        }
        Integer n = ps.executeUpdate();
        Closes.closeQuietly(rs, ps);
        return n;
    }

    private PreparedStatement prepareSql() throws SQLException {
        return this.prepareSql(this.currRun);
    }

    public PreparedStatement prepareSql(EqlRun eqlRun) throws SQLException {
        logger.debug("prepare sql {}: {} ", (Object)this.getSqlId(), (Object)eqlRun.getPrintSql());
        return eqlRun.getSqlType().isProcedure() ? eqlRun.getConnection().prepareCall(eqlRun.getRunSql()) : eqlRun.getConnection().prepareStatement(eqlRun.getRunSql());
    }

    public Eql returnType(Class<?> returnType) {
        this.rsRetriever.setReturnType(returnType);
        return this;
    }

    public Eql returnType(EqlRowMapper eqlRowMapper) {
        this.rsRetriever.setEqlRowMapper(eqlRowMapper);
        return this;
    }

    protected void initSqlId(String sqlId) {
        this.initSqlId(sqlId, 5);
    }

    protected void initSqlId(String sqlId, int level) {
        this.sqlClassPath = Strings.isNullOrEmpty((String)this.sqlClassPath) ? C.getSqlClassPath(level) : this.sqlClassPath;
        this.eqlBlock = this.eqlConfig.getSqlResourceLoader().loadEqlBlock(this.sqlClassPath, sqlId);
        this.rsRetriever.setEqlBlock(this.eqlBlock);
    }

    public Eql useSqlFile(Class<?> sqlBoundClass) {
        this.sqlClassPath = sqlBoundClass.getName().replace('.', '/') + ".eql";
        return this;
    }

    public Eql useSqlFile(String sqlClassPath) {
        this.sqlClassPath = sqlClassPath;
        return this;
    }

    public Eql id(String sqlId) {
        this.initSqlId(sqlId);
        return this;
    }

    public Eql merge(String sqlId) {
        this.initSqlId(sqlId);
        return this;
    }

    public Eql replace(String sqlId) {
        this.initSqlId(sqlId);
        return this;
    }

    public Eql update(String sqlId) {
        this.initSqlId(sqlId);
        return this;
    }

    public Eql insert(String sqlId) {
        this.initSqlId(sqlId);
        return this;
    }

    public Eql delete(String sqlId) {
        this.initSqlId(sqlId);
        return this;
    }

    public Eql select(String sqlId) {
        this.initSqlId(sqlId);
        return this;
    }

    public Eql selectFirst(String sqlId) {
        this.initSqlId(sqlId);
        this.limit(1);
        return this;
    }

    public Eql procedure(String sqlId) {
        this.initSqlId(sqlId);
        return this;
    }

    public String getSqlId() {
        return this.eqlBlock.getSqlId();
    }

    protected void tranStart() {
        if (this.externalTran != null) {
            return;
        }
        if (this.internalTran != null) {
            return;
        }
        this.internalTran = Eql.newTran(this.eqlConfig, this);
        this.internalTran.start();
    }

    protected void tranCommit() {
        if (this.externalTran != null) {
            return;
        }
        this.internalTran.commit();
    }

    private void tranClose() {
        if (this.internalTran != null) {
            Closes.closeQuietly(this.internalTran);
        }
        this.internalTran = null;
    }

    public EqlTran newTran() {
        EqlTran tran = Eql.newTran(this.eqlConfig, this);
        this.useTran(tran);
        return tran;
    }

    public Eql useTran(EqlTran tran) {
        this.externalTran = tran;
        return this;
    }

    public static EqlTran newTran(EqlConfigDecorator eqlConfig, Eql eql) {
        return EqlConfigManager.getConfig(eqlConfig).createTran(eql);
    }

    public EqlConfig getEqlConfig() {
        return this.eqlConfig;
    }

    public String getSqlPath() {
        return this.sqlClassPath;
    }

    public Eql params(Object ... params) {
        this.params = params;
        return this;
    }

    public Eql limit(EqlPage page) {
        this.page = page;
        return this;
    }

    public Eql startBatch() {
        return this.startBatch(0);
    }

    public Eql startBatch(int maxBatches) {
        this.batch = new EqlBatch(this);
        this.batch.startBatch(maxBatches);
        this.tranStart();
        return this;
    }

    public int executeBatch() {
        int totalRows = 0;
        try {
            totalRows = this.batch.executeBatch();
            this.tranCommit();
        }
        catch (SQLException e) {
            throw new EqlExecuteException("executeBatch failed:" + e.getMessage());
        }
        finally {
            this.tranClose();
            this.batch = null;
        }
        return totalRows;
    }

    public Eql dynamics(Object ... dynamics) {
        this.dynamics = dynamics;
        return this;
    }

    public Eql limit(int maxRows) {
        this.rsRetriever.setMaxRows(maxRows);
        return this;
    }

    public Object[] getParams() {
        return this.params;
    }

    public Logger getLogger() {
        return logger;
    }

    public Eql returnType(String returnTypeName) {
        this.rsRetriever.setReturnTypeName(returnTypeName);
        return this;
    }

    public Eql setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public Eql cached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public void resetTran() {
        this.externalTran = null;
        this.internalTran = null;
    }
}

