/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import org.n3r.eql.base.AfterPropertiesSet;
import org.n3r.eql.joor.Reflect;
import org.n3r.eql.map.EqlBeanRowMapper;
import org.n3r.eql.map.EqlCallableResultBeanMapper;
import org.n3r.eql.map.EqlCallableReturnMapMapper;
import org.n3r.eql.map.EqlCallableReturnMapper;
import org.n3r.eql.map.EqlMapMapper;
import org.n3r.eql.map.EqlRowMapper;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.map.EqlSingleValueMapper;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.util.Rs;
import org.n3r.eql.util.S;

public class EqlRsRetriever {
    private EqlBlock eqlBlock;
    private static int DEFAULT_MAXROWS = 100000;
    private int maxRows = DEFAULT_MAXROWS;
    private EqlRowMapper eqlRowMapper;
    private String returnTypeName;
    private Class<?> returnType;

    public Object convert(ResultSet rs, EqlRun subSql) throws SQLException {
        return this.maxRows <= 1 || subSql.isWillReturnOnlyOneRow() ? this.firstRow(rs) : this.selectList(rs);
    }

    private Object firstRow(ResultSet rs) throws SQLException {
        if (!rs.next()) {
            return null;
        }
        if (rs.getMetaData().getColumnCount() == 1) {
            return this.convertSingleValue(Rs.getResultSetValue(rs, 1));
        }
        return this.rowBeanCreate(rs, 1);
    }

    public Object selectRow(ResultSet rs, int rownum) throws SQLException {
        return rownum <= this.maxRows && rs.next() ? this.rowBeanCreate(rs, rownum) : null;
    }

    private Object selectList(ResultSet rs) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int rownum = 1; rs.next() && rownum <= this.maxRows; ++rownum) {
            Object rowObject = this.rowBeanCreate(rs, rownum);
            if (rowObject == null) continue;
            result.add(rowObject);
        }
        return result;
    }

    private Object rowBeanCreate(ResultSet rs, int rowNum) throws SQLException {
        Object rowBean = this.getRowMapper(rs.getMetaData()).mapRow(rs, rowNum);
        if (rowBean instanceof AfterPropertiesSet) {
            ((AfterPropertiesSet)rowBean).afterPropertiesSet();
        }
        return rowBean;
    }

    private EqlRowMapper getRowMapper(ResultSetMetaData metaData) throws SQLException {
        if (this.eqlRowMapper != null) {
            return this.eqlRowMapper;
        }
        if (this.returnType == null && this.eqlBlock != null) {
            this.returnType = this.eqlBlock.getReturnType();
        }
        if (this.returnType != null && EqlRowMapper.class.isAssignableFrom(this.returnType)) {
            return (EqlRowMapper)Reflect.on(this.returnType).create().get();
        }
        if (this.returnType != null && !Map.class.isAssignableFrom(this.returnType)) {
            return new EqlBeanRowMapper(this.returnType);
        }
        return metaData.getColumnCount() > 1 ? new EqlMapMapper() : new EqlSingleValueMapper();
    }

    public EqlCallableReturnMapper getCallableReturnMapper() {
        if (this.returnType == null && this.eqlBlock != null) {
            this.returnType = this.eqlBlock.getReturnType();
        }
        if (this.returnType != null && EqlCallableReturnMapper.class.isAssignableFrom(this.returnType)) {
            return (EqlCallableReturnMapper)Reflect.on(this.returnType).create().get();
        }
        if (this.returnType != null && !Map.class.isAssignableFrom(this.returnType)) {
            return new EqlCallableResultBeanMapper(this.returnType);
        }
        return new EqlCallableReturnMapMapper();
    }

    private Object convertSingleValue(Object value) {
        String returnTypeName;
        if (value == null) {
            return null;
        }
        if (this.returnType == null && this.eqlBlock != null) {
            this.returnType = this.eqlBlock.getReturnType();
        }
        if ((returnTypeName = this.returnTypeName) == null) {
            String string = returnTypeName = this.eqlBlock == null ? null : this.eqlBlock.getOptions().get("returnType");
        }
        if (this.returnType == null && returnTypeName == null) {
            return value;
        }
        if ("string".equalsIgnoreCase(returnTypeName)) {
            if (value instanceof byte[]) {
                return S.bytesToStr((byte[])value);
            }
            return String.valueOf(value);
        }
        if ("int".equalsIgnoreCase(returnTypeName)) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }
        if ("long".equalsIgnoreCase(returnTypeName)) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(value.toString());
        }
        return value;
    }

    public void setEqlBlock(EqlBlock eqlBlock) {
        this.eqlBlock = eqlBlock;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setEqlRowMapper(EqlRowMapper eqlRowMapper) {
        this.eqlRowMapper = eqlRowMapper;
    }

    public void setReturnTypeName(String returnTypeName) {
        this.returnTypeName = returnTypeName;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public void resetMaxRows() {
        this.maxRows = DEFAULT_MAXROWS;
    }
}

