/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.n3r.eql.base.EqlResourceLoader;
import org.n3r.eql.impl.AbstractEqlResourceLoader;
import org.n3r.eql.impl.EqlResourceLoaderHelper;
import org.n3r.eql.impl.EqlUniqueSqlId;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.util.C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileEqlResourceLoader
extends AbstractEqlResourceLoader {
    static Logger log = LoggerFactory.getLogger(FileEqlResourceLoader.class);
    static Cache<String, Optional<Map<String, EqlBlock>>> fileCache = CacheBuilder.newBuilder().build();
    static LoadingCache<EqlUniqueSqlId, Optional<EqlBlock>> sqlCache = EqlResourceLoaderHelper.buildSqlCache(fileCache);

    @Override
    public EqlBlock loadEqlBlock(String sqlClassPath, String sqlId) {
        this.load(this, sqlClassPath);
        Optional eqlBlock = (Optional)sqlCache.getUnchecked((Object)new EqlUniqueSqlId(sqlClassPath, sqlId));
        if (eqlBlock.isPresent()) {
            return (EqlBlock)eqlBlock.get();
        }
        throw new RuntimeException("unable to find sql id " + sqlId);
    }

    @Override
    public Map<String, EqlBlock> load(String classPath) {
        return this.load(this, classPath);
    }

    private Map<String, EqlBlock> load(final EqlResourceLoader eqlResourceLoader, final String sqlClassPath) {
        Callable<Optional<Map<String, EqlBlock>>> valueLoader = new Callable<Optional<Map<String, EqlBlock>>>(){

            @Override
            public Optional<Map<String, EqlBlock>> call() throws Exception {
                String sqlContent = C.classResourceToString(sqlClassPath);
                if (sqlContent == null) {
                    log.warn("classpath sql {} not found", (Object)sqlClassPath);
                    return Optional.absent();
                }
                return Optional.of(EqlResourceLoaderHelper.updateFileCache(sqlContent, eqlResourceLoader, sqlClassPath, FileEqlResourceLoader.this.eqlLazyLoad));
            }
        };
        try {
            return (Map)((Optional)fileCache.get((Object)sqlClassPath, (Callable)valueLoader)).orNull();
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)Throwables.getRootCause((Throwable)e));
            return null;
        }
    }
}

