/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.map;

import com.google.common.collect.Maps;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Map;
import org.n3r.eql.joor.Reflect;
import org.n3r.eql.map.RsAware;
import org.n3r.eql.util.Names;
import org.n3r.eql.util.O;
import org.n3r.eql.util.Rs;

public class EqlBaseBeanMapper {
    protected Class<?> mappedClass;
    protected Map<String, PropertyDescriptor> mappedProperties;
    protected Map<String, Field> mappedFields;

    public EqlBaseBeanMapper(Class<?> mappedClass) {
        this.initialize(mappedClass);
    }

    protected void initialize(Class<?> mappedClass) {
        Field[] declaredFields;
        PropertyDescriptor[] pds;
        this.mappedClass = mappedClass;
        this.mappedProperties = Maps.newHashMap();
        for (PropertyDescriptor pd : pds = O.getBeanInfo(mappedClass).getPropertyDescriptors()) {
            if (pd.getWriteMethod() == null) continue;
            this.mappedProperties.put(pd.getName().toLowerCase(), pd);
            String underscoredName = Names.underscore(pd.getName());
            if (pd.getName().toLowerCase().equals(underscoredName)) continue;
            this.mappedProperties.put(underscoredName, pd);
        }
        this.mappedFields = Maps.newHashMap();
        for (Field field : declaredFields = mappedClass.getDeclaredFields()) {
            this.mappedFields.put(field.getName().toLowerCase(), field);
        }
    }

    protected void setColumnValue(RsAware rs, Object mappedObject, int index, String columnName) throws SQLException {
        Object value;
        boolean succ;
        String lowerCaseName = columnName.replaceAll(" ", "").replaceAll("_", "").toLowerCase();
        PropertyDescriptor pd = this.mappedProperties.get(lowerCaseName);
        if (pd != null && (succ = O.setProperty(mappedObject, pd, value = Rs.getResultSetValue(rs, index, pd.getPropertyType())))) {
            return;
        }
        Field field = this.mappedFields.get(lowerCaseName);
        if (field != null) {
            Object value2 = Rs.getResultSetValue(rs, index, field.getType());
            Reflect.on(mappedObject).set(field.getName(), value2);
            return;
        }
        Object value3 = Rs.getResultSetValue(rs, index);
        O.setValue(mappedObject, columnName, value3);
    }
}

