/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.map;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.n3r.eql.config.EqlConfigDecorator;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.map.EqlDynamic;
import org.n3r.eql.map.EqlType;
import org.n3r.eql.param.EqlParamPlaceholder;
import org.n3r.eql.param.PlaceholderType;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.util.P;
import org.n3r.eql.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqlRun
implements Cloneable {
    public List<Pair<Integer, Object>> realParams = Lists.newArrayList();
    private String boundParams;
    private Connection connection;
    List<Pair<Integer, Integer>> outParameters = Lists.newArrayList();
    Logger logger = LoggerFactory.getLogger(EqlRun.class);
    private String runSql;
    private String printSql;
    private Object result;
    private EqlConfigDecorator eqlConfig;
    private EqlBlock eqlBlock;
    private int placeholderNum;
    private EqlParamPlaceholder[] placeHolders;
    private PlaceholderType placeHolderType;
    private PlaceholderType placeHolderOutType;
    private EqlType sqlType;
    private boolean lastSelectSql;
    private boolean willReturnOnlyOneRow;
    private Object[] extraBindParams;
    private EqlDynamic eqlDynamic;
    private int outCount;
    private Map<String, Object> executionContext;
    private Object[] params;
    private Object[] dynamics;
    private Object paramBean;
    Map<String, Object> mergedParamProperties;
    Map<String, Object> mergedDynamicsProperties;

    public void addRealParam(int index, Object value) {
        this.realParams.add(Pair.of(index, value));
    }

    public void registerOutParameter(int index, int type) {
        this.outParameters.add(Pair.of(index, type));
    }

    public void setBoundParams(String boundParams) {
        this.boundParams = boundParams;
    }

    public void bindParams(PreparedStatement ps) {
        try {
            for (Pair<Integer, Object> pair : this.realParams) {
                ps.setObject((Integer)pair._1, pair._2);
            }
            for (Pair<Integer, Object> pair : this.outParameters) {
                ((CallableStatement)ps).registerOutParameter((int)((Integer)pair._1), (int)((Integer)pair._2));
            }
        }
        catch (SQLException e) {
            throw new EqlExecuteException(e);
        }
        if (this.boundParams != null && this.boundParams.length() > 0) {
            this.logger.debug("param: {}", (Object)this.boundParams);
        }
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public EqlRun clone() {
        try {
            return (EqlRun)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public EqlConfigDecorator getEqlConfig() {
        return this.eqlConfig;
    }

    public void setEqlConfig(EqlConfigDecorator eqlConfig) {
        this.eqlConfig = eqlConfig;
    }

    public void setParamBean(Object paramBean) {
        this.paramBean = paramBean;
    }

    public Object getParamBean() {
        return this.paramBean;
    }

    public void setDynamics(Object[] dynamics) {
        this.dynamics = dynamics;
    }

    public Object[] getDynamics() {
        return this.dynamics;
    }

    private Object getDynamicsBean() {
        return this.dynamics == null || this.dynamics.length == 0 ? null : this.dynamics[0];
    }

    public void setExecutionContext(Map<String, Object> executionContext) {
        this.executionContext = executionContext;
    }

    public Map<String, Object> getExecutionContext() {
        return this.executionContext;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public Object[] getParams() {
        return this.params;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public String getPrintSql() {
        return this.printSql;
    }

    public void setPrintSql(String printSql) {
        this.printSql = printSql;
    }

    public void createPrintSql() {
        this.printSql = this.runSql.replaceAll("\\r?\\n", " ");
    }

    public void setRunSql(String runSql) {
        this.runSql = runSql;
    }

    public String getRunSql() {
        return this.runSql;
    }

    public String getSqlId() {
        return this.eqlBlock != null ? this.eqlBlock.getSqlId() : "<AUTO>";
    }

    public void setPlaceHolders(EqlParamPlaceholder[] placeHolders) {
        this.placeHolders = placeHolders;
        this.outCount = 0;
        for (EqlParamPlaceholder placeHolder : placeHolders) {
            if (placeHolder.getInOut() == EqlParamPlaceholder.InOut.IN) continue;
            ++this.outCount;
        }
    }

    public EqlParamPlaceholder[] getPlaceHolders() {
        return this.placeHolders;
    }

    public EqlParamPlaceholder getPlaceHolder(int index) {
        return index < this.placeHolders.length ? this.placeHolders[index] : null;
    }

    public void setPlaceHolderType(PlaceholderType placeHolderType) {
        this.placeHolderType = placeHolderType;
    }

    public PlaceholderType getPlaceHolderType() {
        return this.placeHolderType;
    }

    public int getPlaceholderNum() {
        return this.placeholderNum;
    }

    public void setPlaceholderNum(int placeholderNum) {
        this.placeholderNum = placeholderNum;
    }

    public EqlBlock getEqlBlock() {
        return this.eqlBlock;
    }

    public void setEqlBlock(EqlBlock eqlBlock) {
        this.eqlBlock = eqlBlock;
    }

    public EqlType getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(EqlType sqlType) {
        this.sqlType = sqlType;
    }

    public void setLastSelectSql(boolean lastSelectSql) {
        this.lastSelectSql = lastSelectSql;
    }

    public boolean isLastSelectSql() {
        return this.lastSelectSql;
    }

    public boolean isWillReturnOnlyOneRow() {
        return this.willReturnOnlyOneRow;
    }

    public void setWillReturnOnlyOneRow(boolean willReturnOnlyOneRow) {
        this.willReturnOnlyOneRow = willReturnOnlyOneRow;
    }

    public Object[] getExtraBindParams() {
        return this.extraBindParams;
    }

    public void setExtraBindParams(Object ... extraBindParams) {
        this.extraBindParams = extraBindParams;
    }

    public void setEqlDynamic(EqlDynamic eqlDynamic) {
        this.eqlDynamic = eqlDynamic;
    }

    public EqlDynamic getEqlDynamic() {
        return this.eqlDynamic;
    }

    public int getOutCount() {
        return this.outCount;
    }

    public PlaceholderType getPlaceHolderOutType() {
        return this.placeHolderOutType;
    }

    public void setPlaceHolderOutType(PlaceholderType placeHolderOutType) {
        this.placeHolderOutType = placeHolderOutType;
    }

    public Map<String, Object> getMergedParamProperties() {
        if (this.mergedParamProperties != null) {
            return this.mergedParamProperties;
        }
        this.mergedParamProperties = P.mergeProperties(this.executionContext, this.getParamBean());
        return this.mergedParamProperties;
    }

    public Map<String, Object> getMergedDynamicsProperties() {
        if (this.mergedDynamicsProperties != null) {
            return this.mergedDynamicsProperties;
        }
        this.mergedDynamicsProperties = P.mergeProperties(this.executionContext, this.getDynamicsBean());
        return this.mergedDynamicsProperties;
    }
}

