/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.map;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.n3r.eql.util.O;

public enum EqlType {
    SELECT,
    UPDATE,
    INSERT,
    MERGE,
    DELETE,
    DROP,
    CREATE,
    TRUNCATE,
    CALL,
    COMMENT,
    ALTER,
    BEGIN,
    DECLARE,
    REPLACE,
    UNKOWN;

    private static Pattern FIRST_WORD;

    public boolean isUpdateStmt() {
        switch (this) {
            case UPDATE: 
            case MERGE: 
            case DELETE: 
            case INSERT: 
            case REPLACE: {
                return true;
            }
        }
        return false;
    }

    public boolean isDdl() {
        switch (this) {
            case CREATE: 
            case DROP: 
            case TRUNCATE: 
            case ALTER: 
            case COMMENT: {
                return true;
            }
        }
        return false;
    }

    public boolean isProcedure() {
        return O.in(this, CALL, DECLARE, BEGIN);
    }

    public static EqlType parseSqlType(String rawSql) {
        Matcher matcher = FIRST_WORD.matcher(rawSql);
        matcher.find();
        String firstWord = matcher.group(1).toUpperCase();
        try {
            return EqlType.valueOf(firstWord);
        }
        catch (IllegalArgumentException e) {
            return UNKOWN;
        }
    }

    static {
        FIRST_WORD = Pattern.compile("\\b(\\w+)\\b");
    }
}

