/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.matrix;

import com.alibaba.druid.pool.DruidDataSource;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.trans.EqlConnection;
import org.n3r.eql.util.S;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqlMatrixConnection
implements EqlConnection {
    public static final String DEFAULT = "default";
    LoadingCache<String, DruidDataSource> dataSourceCache;
    static ThreadLocal<String> databaseNameTl = new ThreadLocal();
    Logger logger = LoggerFactory.getLogger(EqlMatrixConnection.class);

    public static void chooseDatabase(String databaseName) {
        databaseNameTl.set(databaseName);
    }

    public static void chooseDefaultDatabase() {
        databaseNameTl.set(DEFAULT);
    }

    @Override
    public void initialize(EqlConfig eqlConfig) {
        final String url = eqlConfig.getStr("url");
        final String username = eqlConfig.getStr("username");
        final String password = eqlConfig.getStr("password");
        final String initialSize = eqlConfig.getStr("initialSize");
        final String minIdle = eqlConfig.getStr("minIdle");
        final String maxActive = eqlConfig.getStr("maxActive");
        final String maxWait = eqlConfig.getStr("maxWait");
        final String timeBetweenEvictionRunsMillis = eqlConfig.getStr("timeBetweenEvictionRunsMillis");
        final String minEvictableIdleTimeMillis = eqlConfig.getStr("minEvictableIdleTimeMillis");
        final String validationQuery = eqlConfig.getStr("validationQuery");
        this.dataSourceCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, DruidDataSource>(){

            public DruidDataSource load(String database) throws Exception {
                return EqlMatrixConnection.this.createDruidDataSource(database, url, username, password, initialSize, minIdle, maxActive, maxWait, timeBetweenEvictionRunsMillis, minEvictableIdleTimeMillis, validationQuery);
            }
        });
    }

    private DruidDataSource createDruidDataSource(String database, String url, String username, String password, String initialSize, String minIdle, String maxActive, String maxWait, String timeBetweenEvictionRunsMillis, String minEvictableIdleTimeMillis, String validationQuery) {
        String myValidationQuery;
        int myMinEvictableIdleTimeMillis;
        int myTimeBetweenEvictionRunsMillis;
        int myMaxWait;
        int myMaxActive;
        int myMinIdle;
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(this.parseParameter(url, database));
        dataSource.setUsername(this.parseParameter(username, database));
        dataSource.setPassword(this.parseParameter(password, database));
        int myInitialSize = this.parseIntParameter(initialSize, database);
        if (myInitialSize > 0) {
            dataSource.setInitialSize(myInitialSize);
        }
        if ((myMinIdle = this.parseIntParameter(minIdle, database)) > 0) {
            dataSource.setMinIdle(myMinIdle);
        }
        if ((myMaxActive = this.parseIntParameter(maxActive, database)) > 0) {
            dataSource.setMaxActive(myMaxActive);
        }
        if ((myMaxWait = this.parseIntParameter(maxWait, database)) > 0) {
            dataSource.setMaxWait((long)myMaxWait);
        }
        if ((myTimeBetweenEvictionRunsMillis = this.parseIntParameter(timeBetweenEvictionRunsMillis, database)) > 0) {
            dataSource.setTimeBetweenEvictionRunsMillis((long)myTimeBetweenEvictionRunsMillis);
        }
        if ((myMinEvictableIdleTimeMillis = this.parseIntParameter(minEvictableIdleTimeMillis, database)) > 0) {
            dataSource.setMinEvictableIdleTimeMillis((long)myMinEvictableIdleTimeMillis);
        }
        if ((myValidationQuery = this.parseParameter(validationQuery, database)).length() > 0) {
            dataSource.setValidationQuery(myValidationQuery);
        }
        return dataSource;
    }

    private int parseIntParameter(String param, String database) {
        String my = this.parseParameter(param, database);
        return my.matches("\\d+") ? Integer.parseInt(my) : 0;
    }

    private String parseParameter(String param, String database) {
        if (param == null || param.length() == 0) {
            return "";
        }
        StringBuilder parsed = new StringBuilder();
        Splitter.MapSplitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings().withKeyValueSeparator("->");
        int startPos = 0;
        while (startPos < param.length()) {
            int rightBracePos;
            int leftBracePos = param.indexOf(123, startPos);
            if (leftBracePos < 0) {
                parsed.append(param.substring(startPos));
                break;
            }
            if (leftBracePos > 0) {
                parsed.append(param.substring(startPos, leftBracePos));
            }
            if ((rightBracePos = param.indexOf(125, leftBracePos)) < 0) {
                this.logger.warn("invalid parameter format: " + param);
                return param;
            }
            String map = param.substring(leftBracePos + 1, rightBracePos);
            Map data = splitter.split((CharSequence)map);
            String specified = (String)data.get(database);
            if (specified == null) {
                specified = (String)data.get(DEFAULT);
            }
            if (specified == null) {
                this.logger.warn("invalid parameter mapping format: " + param);
                return param;
            }
            parsed.append(specified);
            startPos = rightBracePos + 1;
        }
        return parsed.toString();
    }

    @Override
    public Connection getConnection() {
        try {
            String databaseName = databaseNameTl.get();
            if (S.isBlank(databaseName)) {
                databaseName = DEFAULT;
            }
            this.logger.debug("use database [{}]", (Object)databaseName);
            return ((DruidDataSource)this.dataSourceCache.getUnchecked((Object)databaseName)).getConnection();
        }
        catch (SQLException e) {
            throw new EqlExecuteException(e);
        }
    }

    @Override
    public void destroy() {
        ConcurrentMap map = this.dataSourceCache.asMap();
        for (String databaseName : map.keySet()) {
            DruidDataSource druidDataSource = (DruidDataSource)map.get(databaseName);
            try {
                druidDataSource.close();
            }
            catch (Exception e) {}
        }
        this.dataSourceCache.invalidateAll();
        this.dataSourceCache = null;
    }
}

